/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.semantics.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.ItemRegistryChangeListener;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataProvider;
import org.openhab.core.semantics.Equipment;
import org.openhab.core.semantics.Location;
import org.openhab.core.semantics.Point;
import org.openhab.core.semantics.Property;
import org.openhab.core.semantics.SemanticTag;
import org.openhab.core.semantics.SemanticTagRegistry;
import org.openhab.core.semantics.SemanticTags;
import org.openhab.core.semantics.Tag;
import org.openhab.core.semantics.internal.SemanticTagRegistryImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={MetadataProvider.class})
@NonNullByDefault
public class SemanticsMetadataProvider
extends AbstractProvider<Metadata>
implements ItemRegistryChangeListener,
MetadataProvider {
    private final Logger logger = LoggerFactory.getLogger(SemanticsMetadataProvider.class);
    public static final String NAMESPACE = "semantics";
    private final Map<List<Class<? extends Tag>>, String> parentRelations = new HashMap<List<Class<? extends Tag>>, String>();
    private final Map<List<Class<? extends Tag>>, String> memberRelations = new HashMap<List<Class<? extends Tag>>, String>();
    private final Map<List<Class<? extends Tag>>, String> propertyRelations = new HashMap<List<Class<? extends Tag>>, String>();
    private final Map<String, Metadata> semantics = new TreeMap<String, Metadata>(String::compareTo);
    private final ItemRegistry itemRegistry;
    private final SemanticTagRegistry semanticTagRegistry;
    private SemanticTagRegistryChangeListener listener;

    @Activate
    public SemanticsMetadataProvider(@Reference ItemRegistry itemRegistry, @Reference SemanticTagRegistry semanticTagRegistry) {
        this.itemRegistry = itemRegistry;
        this.semanticTagRegistry = semanticTagRegistry;
        this.listener = new SemanticTagRegistryChangeListener(this);
    }

    @Activate
    protected void activate() {
        this.initRelations();
        for (Item item : this.itemRegistry.getAll()) {
            this.processItem(item);
        }
        this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
        this.semanticTagRegistry.addRegistryChangeListener(this.listener);
    }

    @Deactivate
    protected void deactivate() {
        this.semanticTagRegistry.removeRegistryChangeListener(this.listener);
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.semantics.clear();
    }

    public Collection<Metadata> getAll() {
        return this.semantics.values();
    }

    private void processItem(Item item) {
        this.processItem(item, new ArrayList<String>());
    }

    /*
     * WARNING - void declaration
     */
    private void processItem(Item item, List<String> parentItems) {
        Metadata removedMd;
        MetadataKey key = new MetadataKey(NAMESPACE, item.getName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        Class<? extends Tag> type = SemanticTags.getSemanticType(item);
        if (type != null) {
            this.processProperties(item, configuration);
            this.processHierarchy(item, configuration);
            Metadata md = new Metadata(key, SemanticTagRegistryImpl.buildId(type), configuration);
            Metadata oldMd = this.semantics.put(item.getName(), md);
            if (oldMd == null) {
                this.notifyListenersAboutAddedElement(md);
            } else {
                this.notifyListenersAboutUpdatedElement(oldMd, md);
            }
        } else {
            removedMd = this.semantics.remove(item.getName());
            if (removedMd != null) {
                this.notifyListenersAboutRemovedElement(removedMd);
            }
        }
        Item item2 = item;
        if (item2 instanceof GroupItem && (removedMd = (GroupItem)item2) == (GroupItem)item2) {
            void groupItem;
            parentItems.add(item.getName());
            for (Item memberItem : groupItem.getMembers()) {
                if (parentItems.contains(memberItem.getName())) {
                    this.logger.error("Recursive group membership found: {} is both, a direct or indirect parent and a child of {}.", (Object)memberItem.getName(), (Object)groupItem.getName());
                    continue;
                }
                this.processItem(memberItem, parentItems);
            }
        }
    }

    private void processProperties(Item item, Map<String, Object> configuration) {
        Class<? extends Tag> type = SemanticTags.getSemanticType(item);
        if (type == null) {
            return;
        }
        for (Map.Entry<List<Class<? extends Tag>>, String> relation : this.propertyRelations.entrySet()) {
            Class<? extends Property> p;
            Class<? extends Tag> entityClass = relation.getKey().get(0);
            if (!entityClass.isAssignableFrom(type) || (p = SemanticTags.getProperty(item)) == null) continue;
            configuration.put(relation.getValue(), SemanticTagRegistryImpl.buildId(p));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processHierarchy(Item item, Map<String, Object> configuration) {
        Class<? extends Tag> type = SemanticTags.getSemanticType(item);
        if (type != null) {
            String parent2;
            for (String parent2 : item.getGroupNames()) {
                Item parentItem = (Item)this.itemRegistry.get((Object)parent2);
                if (parentItem == null) continue;
                this.processParent(type, parentItem, configuration);
            }
            Item item2 = item;
            if (item2 instanceof GroupItem && (parent2 = (GroupItem)item2) == (GroupItem)item2) {
                void gItem;
                for (Item memberItem : gItem.getMembers()) {
                    this.processMember(type, memberItem, configuration);
                }
            }
        }
    }

    private void processParent(Class<? extends Tag> type, Item parentItem, Map<String, Object> configuration) {
        Class<? extends Tag> typeParent = SemanticTags.getSemanticType(parentItem);
        if (typeParent == null) {
            return;
        }
        for (Map.Entry<List<Class<? extends Tag>>, String> relation : this.parentRelations.entrySet()) {
            List<Class<? extends Tag>> relClasses = relation.getKey();
            Class<? extends Tag> entityClass = relClasses.get(0);
            Class<? extends Tag> parentClass = relClasses.get(1);
            if (!entityClass.isAssignableFrom(type) || !parentClass.isAssignableFrom(typeParent)) continue;
            configuration.put(relation.getValue(), parentItem.getName());
        }
    }

    private void processMember(Class<? extends Tag> type, Item memberItem, Map<String, Object> configuration) {
        Class<? extends Tag> typeMember = SemanticTags.getSemanticType(memberItem);
        if (typeMember == null) {
            return;
        }
        for (Map.Entry<List<Class<? extends Tag>>, String> relation : this.memberRelations.entrySet()) {
            List<Class<? extends Tag>> relClasses = relation.getKey();
            Class<? extends Tag> entityClass = relClasses.get(0);
            Class<? extends Tag> parentClass = relClasses.get(1);
            if (!entityClass.isAssignableFrom(type) || !parentClass.isAssignableFrom(typeMember)) continue;
            configuration.put(relation.getValue(), memberItem.getName());
        }
    }

    private void initRelations() {
        this.parentRelations.put(List.of(Equipment.class, Location.class), "hasLocation");
        this.parentRelations.put(List.of(Point.class, Location.class), "hasLocation");
        this.parentRelations.put(List.of(Location.class, Location.class), "isPartOf");
        this.parentRelations.put(List.of(Equipment.class, Equipment.class), "isPartOf");
        this.parentRelations.put(List.of(Point.class, Equipment.class), "isPointOf");
        this.memberRelations.put(List.of(Equipment.class, Point.class), "hasPoint");
        this.propertyRelations.put(List.of(Point.class), "relatesTo");
    }

    public void allItemsChanged(Collection<String> oldItemNames) {
        for (Item item : this.itemRegistry.getItems()) {
            this.added(item);
        }
    }

    public void added(Item item) {
        this.processItem(item);
    }

    public void removed(Item item) {
        Metadata removedMd = this.semantics.remove(item.getName());
        if (removedMd != null) {
            this.notifyListenersAboutRemovedElement(removedMd);
            if (item instanceof GroupItem var3_4) {
                for (Item memberItem : groupItem.getMembers()) {
                    this.processItem(memberItem);
                }
            }
        }
    }

    public void updated(Item oldItem, Item item) {
        this.processItem(item);
    }

    private class SemanticTagRegistryChangeListener
    implements RegistryChangeListener<SemanticTag> {
        private SemanticsMetadataProvider provider;

        public SemanticTagRegistryChangeListener(SemanticsMetadataProvider provider) {
            this.provider = provider;
        }

        public void added(SemanticTag element) {
            this.provider.allItemsChanged(List.of());
        }

        public void removed(SemanticTag element) {
            this.provider.allItemsChanged(List.of());
        }

        public void updated(SemanticTag oldElement, SemanticTag element) {
            this.provider.allItemsChanged(List.of());
        }
    }
}

