/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.semantics.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.objectweb.asm.ClassWriter;
import org.openhab.core.common.registry.AbstractRegistry;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.semantics.Equipment;
import org.openhab.core.semantics.Location;
import org.openhab.core.semantics.ManagedSemanticTagProvider;
import org.openhab.core.semantics.Point;
import org.openhab.core.semantics.Property;
import org.openhab.core.semantics.SemanticTag;
import org.openhab.core.semantics.SemanticTagProvider;
import org.openhab.core.semantics.SemanticTagRegistry;
import org.openhab.core.semantics.SemanticTags;
import org.openhab.core.semantics.Tag;
import org.openhab.core.semantics.model.DefaultSemanticTagProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true)
public class SemanticTagRegistryImpl
extends AbstractRegistry<SemanticTag, String, SemanticTagProvider>
implements SemanticTagRegistry {
    private static final SemanticClassLoader CLASS_LOADER = new SemanticClassLoader();
    private final Logger logger = LoggerFactory.getLogger(SemanticTagRegistryImpl.class);
    private final DefaultSemanticTagProvider defaultSemanticTagProvider;
    private final ManagedSemanticTagProvider managedProvider;

    @Activate
    public SemanticTagRegistryImpl(@Reference DefaultSemanticTagProvider defaultSemanticTagProvider, @Reference ManagedSemanticTagProvider managedProvider) {
        super(SemanticTagProvider.class);
        this.defaultSemanticTagProvider = defaultSemanticTagProvider;
        this.managedProvider = managedProvider;
        super.addProvider((Provider)defaultSemanticTagProvider);
        super.addProvider((Provider)managedProvider);
        this.setManagedProvider((ManagedProvider)managedProvider);
    }

    protected void addProvider(Provider<SemanticTag> provider) {
        if (!provider.equals((Object)this.defaultSemanticTagProvider) && !provider.equals((Object)this.managedProvider)) {
            this.logger.trace("addProvider {} => calling super.addProvider", (Object)provider.getClass().getSimpleName());
            super.addProvider(provider);
        } else {
            this.logger.trace("addProvider {} => ignoring it", (Object)provider.getClass().getSimpleName());
        }
    }

    @Override
    public @Nullable Class<? extends Tag> getTagClassById(String tagId) {
        return SemanticTags.getById(tagId);
    }

    public static String buildId(Class<? extends Tag> tag) {
        return SemanticTagRegistryImpl.buildId("", tag);
    }

    private static String buildId(String relativeId, Class<?> tag) {
        if (!(Location.class.isAssignableFrom(tag) || Equipment.class.isAssignableFrom(tag) || Point.class.isAssignableFrom(tag) || Property.class.isAssignableFrom(tag))) {
            return relativeId;
        }
        String id = tag.getSimpleName();
        if (!relativeId.isEmpty()) {
            id = String.valueOf(id) + "_" + relativeId;
        }
        return SemanticTagRegistryImpl.buildId(id, tag.getInterfaces()[0]);
    }

    @Override
    public boolean canBeAdded(SemanticTag tag) {
        String id = (String)tag.getUID();
        if (this.get(id) != null) {
            return false;
        }
        int lastSeparator = id.lastIndexOf("_");
        if (lastSeparator <= 0) {
            return false;
        }
        String name = id.substring(lastSeparator + 1);
        String parentId = id.substring(0, lastSeparator);
        SemanticTag parent = (SemanticTag)this.get(parentId);
        return name.matches("[A-Z][a-zA-Z0-9]+") && parent != null && (this.managedProvider.get(parentId) != null || this.defaultSemanticTagProvider.getAll().contains(parent)) && this.getTagClassById(name) == null;
    }

    @Override
    public List<SemanticTag> getSubTree(SemanticTag tag) {
        List<String> ids = this.getAll().stream().map(t -> (String)t.getUID()).filter(uid -> uid.startsWith(String.valueOf((String)tag.getUID()) + "_")).toList();
        ArrayList<SemanticTag> tags = new ArrayList<SemanticTag>();
        tags.add(tag);
        ids.forEach(id -> {
            SemanticTag t = (SemanticTag)this.get(id);
            if (t != null) {
                tags.add(t);
            }
        });
        return tags;
    }

    @Override
    public boolean isEditable(SemanticTag tag) {
        return this.managedProvider.get((String)tag.getUID()) != null;
    }

    @Override
    public void removeSubTree(SemanticTag tag) {
        List<String> ids = this.getSubTree(tag).stream().filter(this::isEditable).map(Identifiable::getUID).sorted(Comparator.reverseOrder()).toList();
        ids.forEach(arg_0 -> ((ManagedSemanticTagProvider)this.managedProvider).remove(arg_0));
    }

    protected void onAddElement(SemanticTag tag) throws IllegalArgumentException {
        String className;
        String type;
        Class newTag;
        String uid;
        block26: {
            int lastSeparator;
            Class<? extends Tag> tagClass;
            block24: {
                this.logger.trace("onAddElement {}", tag.getUID());
                super.onAddElement((Identifiable)tag);
                uid = (String)tag.getUID();
                tagClass = this.getTagClassById(uid);
                if (tagClass != null) {
                    return;
                }
                lastSeparator = uid.lastIndexOf("_");
                if (lastSeparator >= 0) break block24;
                switch (uid) {
                    case "Equipment": {
                        newTag = Equipment.class;
                        break;
                    }
                    case "Location": {
                        newTag = Location.class;
                        break;
                    }
                    case "Point": {
                        newTag = Point.class;
                        break;
                    }
                    case "Property": {
                        newTag = Property.class;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Failed to create semantic tag '" + uid + "': only Equipment, Location, Point and Property are allowed as root tags.");
                    }
                }
                type = uid;
                className = newTag.getClass().getName();
                break block26;
            }
            String name = uid.substring(lastSeparator + 1);
            String parentId = uid.substring(0, lastSeparator);
            Class<? extends Tag> parentTagClass = this.getTagClassById(parentId);
            if (parentTagClass == null) {
                throw new IllegalArgumentException("Failed to create semantic tag '" + uid + "': no existing parent tag with id " + parentId);
            }
            if (!name.matches("[A-Z][a-zA-Z0-9]+")) {
                throw new IllegalArgumentException("Failed to create semantic tag '" + uid + "': tag name must start with a capital letter and contain only alphanumerics.");
            }
            tagClass = this.getTagClassById(name);
            if (tagClass != null) {
                throw new IllegalArgumentException("Failed to create semantic tag '" + uid + "': tag '" + SemanticTagRegistryImpl.buildId(tagClass) + "' already exists.");
            }
            type = parentId.split("_")[0];
            className = "org.openhab.core.semantics.model." + type.toLowerCase() + "." + name;
            try {
                newTag = Class.forName(className, false, CLASS_LOADER);
                this.logger.debug("'{}' semantic {} tag already exists.", (Object)className, (Object)type);
            }
            catch (ClassNotFoundException e) {
                ClassWriter classWriter = new ClassWriter(0);
                classWriter.visit(55, 1537, className.replace('.', '/'), null, "java/lang/Object", new String[]{parentTagClass.getName().replace('.', '/')});
                classWriter.visitSource("Status.java", null);
                classWriter.visitEnd();
                byte[] byteCode = classWriter.toByteArray();
                try {
                    newTag = CLASS_LOADER.defineClass(className, byteCode);
                    this.logger.debug("'{}' semantic {} tag created.", (Object)className, (Object)type);
                }
                catch (Exception ex) {
                    this.logger.warn("Failed to create semantic tag '{}': {}", (Object)className, (Object)ex.getMessage());
                    throw new IllegalArgumentException("Failed to create semantic tag '" + className + "'", ex);
                }
            }
        }
        this.addTagSet(uid, newTag);
        this.logger.debug("'{}' semantic {} tag added.", (Object)className, (Object)type);
    }

    protected void onRemoveElement(SemanticTag tag) {
        this.logger.trace("onRemoveElement {}", tag.getUID());
        super.onRemoveElement((Identifiable)tag);
        this.removeTagSet((String)tag.getUID());
    }

    private void addTagSet(String tagId, Class<? extends Tag> tagSet) {
        this.logger.trace("addTagSet {}", (Object)tagId);
        String id = tagId;
        while (id.indexOf("_") != -1) {
            SemanticTags.addTagSet(id, tagSet);
            id = id.substring(id.indexOf("_") + 1);
        }
        SemanticTags.addTagSet(id, tagSet);
    }

    private void removeTagSet(String tagId) {
        this.logger.trace("removeTagSet {}", (Object)tagId);
        Class<? extends Tag> tagSet = this.getTagClassById(tagId);
        if (tagSet == null) {
            return;
        }
        String id = tagId;
        while (id.indexOf("_") != -1) {
            SemanticTags.removeTagSet(id, tagSet);
            id = id.substring(id.indexOf("_") + 1);
        }
        SemanticTags.removeTagSet(id, tagSet);
    }

    private static class SemanticClassLoader
    extends ClassLoader {
        public SemanticClassLoader() {
            super(SemanticTagRegistryImpl.class.getClassLoader());
        }

        public Class<?> defineClass(String className, byte[] byteCode) {
            return this.defineClass(className, byteCode, 0, byteCode.length);
        }
    }
}

