/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.internal.pooling;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.wimpi.modbus.net.ModbusSlaveConnection;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.net.TCPMasterConnection;
import net.wimpi.modbus.net.UDPMasterConnection;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.modbus.endpoint.EndpointPoolConfiguration;
import org.openhab.core.io.transport.modbus.endpoint.ModbusIPSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSerialSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSlaveEndpointVisitor;
import org.openhab.core.io.transport.modbus.endpoint.ModbusTCPSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusUDPSlaveEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ModbusSlaveConnectionFactoryImpl
extends BaseKeyedPooledObjectFactory<ModbusSlaveEndpoint, ModbusSlaveConnection> {
    private final Logger logger = LoggerFactory.getLogger(ModbusSlaveConnectionFactoryImpl.class);
    private volatile Map<ModbusSlaveEndpoint, EndpointPoolConfiguration> endpointPoolConfigs = new ConcurrentHashMap<ModbusSlaveEndpoint, EndpointPoolConfiguration>();
    private volatile Map<ModbusSlaveEndpoint, Long> lastPassivateMillis = new ConcurrentHashMap<ModbusSlaveEndpoint, Long>();
    private volatile Map<ModbusSlaveEndpoint, Long> lastConnectMillis = new ConcurrentHashMap<ModbusSlaveEndpoint, Long>();
    private volatile Map<ModbusSlaveEndpoint, Long> disconnectIfConnectedBefore = new ConcurrentHashMap<ModbusSlaveEndpoint, Long>();
    private final Function<ModbusSlaveEndpoint, EndpointPoolConfiguration> defaultPoolConfigurationFactory;

    public ModbusSlaveConnectionFactoryImpl(Function<ModbusSlaveEndpoint, EndpointPoolConfiguration> defaultPoolConfigurationFactory) {
        this.defaultPoolConfigurationFactory = defaultPoolConfigurationFactory;
    }

    private @Nullable InetAddress getInetAddress(ModbusIPSlaveEndpoint key) {
        try {
            return InetAddress.getByName(key.getAddress());
        }
        catch (UnknownHostException e) {
            this.logger.warn("KeyedPooledModbusSlaveConnectionFactory: Unknown host: {}. Connection creation failed.", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public @Nullable ModbusSlaveConnection create(ModbusSlaveEndpoint endpoint) throws Exception {
        return endpoint.accept(new ModbusSlaveEndpointVisitor<ModbusSlaveConnection>(){

            @Override
            public @Nullable ModbusSlaveConnection visit(ModbusSerialSlaveEndpoint modbusSerialSlavePoolingKey) {
                SerialConnection connection = new SerialConnection(modbusSerialSlavePoolingKey.getSerialParameters());
                ModbusSlaveConnectionFactoryImpl.this.logger.trace("Created connection {} for endpoint {}", (Object)connection, (Object)modbusSerialSlavePoolingKey);
                return connection;
            }

            @Override
            public @Nullable ModbusSlaveConnection visit(ModbusTCPSlaveEndpoint key) {
                InetAddress address = ModbusSlaveConnectionFactoryImpl.this.getInetAddress(key);
                if (address == null) {
                    return null;
                }
                int connectTimeoutMillis = ModbusSlaveConnectionFactoryImpl.this.getEndpointPoolConfiguration(key).getConnectTimeoutMillis();
                TCPMasterConnection connection = new TCPMasterConnection(address, key.getPort(), connectTimeoutMillis, key.getRtuEncoded());
                ModbusSlaveConnectionFactoryImpl.this.logger.trace("Created connection {} for endpoint {}", (Object)connection, (Object)key);
                return connection;
            }

            @Override
            public @Nullable ModbusSlaveConnection visit(ModbusUDPSlaveEndpoint key) {
                InetAddress address = ModbusSlaveConnectionFactoryImpl.this.getInetAddress(key);
                if (address == null) {
                    return null;
                }
                UDPMasterConnection connection = new UDPMasterConnection(address, key.getPort());
                ModbusSlaveConnectionFactoryImpl.this.logger.trace("Created connection {} for endpoint {}", (Object)connection, (Object)key);
                return connection;
            }
        });
    }

    @Override
    public PooledObject<@Nullable ModbusSlaveConnection> wrap(@Nullable ModbusSlaveConnection connection) {
        return new PooledConnection(connection);
    }

    @Override
    public void destroyObject(ModbusSlaveEndpoint endpoint, @Nullable PooledObject<@Nullable ModbusSlaveConnection> obj) {
        if (obj == null) {
            return;
        }
        ModbusSlaveConnection connection = obj.getObject();
        if (connection == null) {
            return;
        }
        this.logger.trace("destroyObject for connection {} and endpoint {} -> closing the connection", (Object)connection, (Object)endpoint);
        connection.resetConnection();
    }

    @Override
    public void activateObject(ModbusSlaveEndpoint endpoint, @Nullable PooledObject<@Nullable ModbusSlaveConnection> obj) throws Exception {
        if (obj == null) {
            return;
        }
        ModbusSlaveConnection connection = obj.getObject();
        if (connection == null) {
            return;
        }
        try {
            EndpointPoolConfiguration config = this.getEndpointPoolConfiguration(endpoint);
            if (!connection.isConnected()) {
                this.tryConnect(endpoint, obj, connection, config);
            }
            long waited = ModbusSlaveConnectionFactoryImpl.waitAtleast(this.lastPassivateMillis.get(endpoint), config.getInterTransactionDelayMillis());
            this.logger.trace("Waited {}ms (interTransactionDelayMillis {}ms) before giving returning connection {} for endpoint {}, to ensure delay between transactions.", new Object[]{waited, config.getInterTransactionDelayMillis(), obj.getObject(), endpoint});
        }
        catch (InterruptedException e) {
            if (connection.isConnected()) {
                connection.resetConnection();
            }
        }
        catch (Exception e) {
            this.logger.warn("Error connecting connection {} for endpoint {}: {}", new Object[]{obj.getObject(), endpoint, e.getMessage()});
        }
    }

    @Override
    public void passivateObject(ModbusSlaveEndpoint endpoint, @Nullable PooledObject<@Nullable ModbusSlaveConnection> obj) {
        if (obj == null) {
            return;
        }
        ModbusSlaveConnection connection = obj.getObject();
        this.logger.trace("Passivating connection {} for endpoint {}...", (Object)connection, (Object)endpoint);
        this.lastPassivateMillis.put(endpoint, System.currentTimeMillis());
        ((PooledConnection)obj).maybeResetConnection("passivate");
        this.logger.trace("...Passivated connection {} for endpoint {}", (Object)obj.getObject(), (Object)endpoint);
    }

    @Override
    public boolean validateObject(ModbusSlaveEndpoint key, @Nullable PooledObject<@Nullable ModbusSlaveConnection> p) {
        boolean valid = p != null && p.getObject() != null && p.getObject().isConnected();
        ModbusSlaveConnection slaveConnection = p != null ? p.getObject() : null;
        this.logger.trace("Validating endpoint {} connection {} -> {}", new Object[]{key, slaveConnection, valid});
        return valid;
    }

    public void setEndpointPoolConfiguration(ModbusSlaveEndpoint endpoint, @Nullable EndpointPoolConfiguration config) {
        if (config == null) {
            this.endpointPoolConfigs.remove(endpoint);
        } else {
            this.endpointPoolConfigs.put(endpoint, config);
        }
    }

    public EndpointPoolConfiguration getEndpointPoolConfiguration(ModbusSlaveEndpoint endpoint) {
        return Optional.ofNullable(this.endpointPoolConfigs.get(endpoint)).orElseGet(() -> this.defaultPoolConfigurationFactory.apply(endpoint));
    }

    private void tryConnect(ModbusSlaveEndpoint endpoint, PooledObject<@Nullable ModbusSlaveConnection> obj, ModbusSlaveConnection connection, EndpointPoolConfiguration config) throws Exception {
        if (connection.isConnected()) {
            return;
        }
        int tryIndex = 0;
        Long lastConnect = this.lastConnectMillis.get(endpoint);
        int maxTries = config.getConnectMaxTries();
        while (true) {
            try {
                long waited = ModbusSlaveConnectionFactoryImpl.waitAtleast(lastConnect, Math.max(config.getInterConnectDelayMillis(), config.getInterTransactionDelayMillis()));
                if (waited > 0L) {
                    this.logger.trace("Waited {}ms (interConnectDelayMillis {}ms, interTransactionDelayMillis {}ms) before connecting disconnected connection {} for endpoint {}, to allow delay between connections re-connects", new Object[]{waited, config.getInterConnectDelayMillis(), config.getInterTransactionDelayMillis(), obj.getObject(), endpoint});
                }
                connection.connect();
                this.logger.trace("Waiting {}ms for connection to warm up...", (Object)config.getAfterConnectionDelayMillis());
                if (config.getAfterConnectionDelayMillis() > 0L) {
                    try {
                        Thread.sleep(config.getAfterConnectionDelayMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                long curTime = System.currentTimeMillis();
                ((PooledConnection)obj).setLastConnected(endpoint, curTime);
                this.lastConnectMillis.put(endpoint, curTime);
            }
            catch (InterruptedException e) {
                this.logger.info("Connect try {}/{} failed: {}. Aborting since interrupted. Connection {}. Endpoint {}.", new Object[]{tryIndex, maxTries, e.getMessage(), connection, endpoint});
                throw e;
            }
            catch (Exception e) {
                this.logger.debug("Connect try {}/{} failed: {}. Connection {}. Endpoint {}", new Object[]{++tryIndex, maxTries, e.getMessage(), connection, endpoint});
                if (tryIndex >= maxTries) {
                    this.logger.warn("Connect reached max tries {}, throwing last error: {}. Connection {}. Endpoint {}", new Object[]{maxTries, e.getMessage(), connection, endpoint});
                    throw e;
                }
                lastConnect = System.currentTimeMillis();
                continue;
            }
            break;
        }
    }

    public static long waitAtleast(@Nullable Long lastOperation, long waitMillis) throws InterruptedException {
        if (lastOperation == null) {
            return 0L;
        }
        long millisSinceLast = System.currentTimeMillis() - lastOperation;
        long millisToWaitStill = Math.min(waitMillis, Math.max(0L, waitMillis - millisSinceLast));
        try {
            Thread.sleep(millisToWaitStill);
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(ModbusSlaveConnectionFactoryImpl.class).debug("wait interrupted", (Throwable)e);
            throw e;
        }
        return millisToWaitStill;
    }

    public void disconnectOnReturn(ModbusSlaveEndpoint endpoint, long disconnectBeforeConnectedMillis) {
        this.disconnectIfConnectedBefore.put(endpoint, disconnectBeforeConnectedMillis);
    }

    class PooledConnection
    extends DefaultPooledObject<ModbusSlaveConnection> {
        private volatile long lastConnected;
        private volatile @Nullable ModbusSlaveEndpoint endpoint;

        public PooledConnection(ModbusSlaveConnection object) {
            super(object);
        }

        public long getLastConnected() {
            return this.lastConnected;
        }

        public void setLastConnected(ModbusSlaveEndpoint endpoint, long lastConnected) {
            this.endpoint = endpoint;
            this.lastConnected = lastConnected;
        }

        public boolean maybeResetConnection(String activityName) {
            boolean shouldBeDisconnected;
            ModbusSlaveEndpoint localEndpoint = this.endpoint;
            if (localEndpoint == null) {
                return false;
            }
            long localLastConnected = this.lastConnected;
            ModbusSlaveConnection connection = (ModbusSlaveConnection)this.getObject();
            if (connection == null) {
                return false;
            }
            EndpointPoolConfiguration configuration = ModbusSlaveConnectionFactoryImpl.this.getEndpointPoolConfiguration(localEndpoint);
            long reconnectAfterMillis = configuration.getReconnectAfterMillis();
            long connectionAgeMillis = System.currentTimeMillis() - localLastConnected;
            long disconnectIfConnectedBeforeMillis = ModbusSlaveConnectionFactoryImpl.this.disconnectIfConnectedBefore.getOrDefault(localEndpoint, -1L);
            boolean disconnectSinceTooOldConnection = disconnectIfConnectedBeforeMillis < 0L ? false : localLastConnected <= disconnectIfConnectedBeforeMillis;
            boolean bl = shouldBeDisconnected = reconnectAfterMillis == 0L || reconnectAfterMillis > 0L && connectionAgeMillis > reconnectAfterMillis || disconnectSinceTooOldConnection;
            if (shouldBeDisconnected) {
                ModbusSlaveConnectionFactoryImpl.this.logger.trace("({}) Connection {} (endpoint {}) age {}ms is over the reconnectAfterMillis={}ms limit or has been connection time ({}) is after the \"disconnectBeforeConnectedMillis\"={} -> disconnecting.", new Object[]{activityName, connection, localEndpoint, connectionAgeMillis, reconnectAfterMillis, localLastConnected, disconnectIfConnectedBeforeMillis});
                connection.resetConnection();
                return true;
            }
            ModbusSlaveConnectionFactoryImpl.this.logger.trace("({}) Connection {} (endpoint {}) age ({}ms) is below the reconnectAfterMillis ({}ms) limit and connection time ({}) is after the \"disconnectBeforeConnectedMillis\"={}. Keep the connection open.", new Object[]{activityName, connection, localEndpoint, connectionAgeMillis, reconnectAfterMillis, localLastConnected, disconnectIfConnectedBeforeMillis});
            return false;
        }
    }
}

