/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.modbus.ModbusReadFunctionCode;

@NonNullByDefault
public class ModbusReadRequestBlueprint {
    private final int slaveId;
    private final ModbusReadFunctionCode functionCode;
    private final int start;
    private final int length;
    private final int maxTries;

    public ModbusReadRequestBlueprint(int slaveId, ModbusReadFunctionCode functionCode, int start, int length, int maxTries) {
        this.slaveId = slaveId;
        this.functionCode = functionCode;
        this.start = start;
        this.length = length;
        this.maxTries = maxTries;
    }

    public int getUnitID() {
        return this.slaveId;
    }

    public int getReference() {
        return this.start;
    }

    public ModbusReadFunctionCode getFunctionCode() {
        return this.functionCode;
    }

    public int getDataLength() {
        return this.length;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public int getProtocolID() {
        return 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.functionCode, this.length, this.maxTries, this.slaveId, this.start});
    }

    public String toString() {
        return "ModbusReadRequestBlueprint [slaveId=" + this.slaveId + ", functionCode=" + (Object)((Object)this.functionCode) + ", start=" + this.start + ", length=" + this.length + ", maxTries=" + this.maxTries + "]";
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ModbusReadRequestBlueprint rhs = (ModbusReadRequestBlueprint)obj;
        return this.functionCode == rhs.functionCode && this.length == rhs.length && this.slaveId == rhs.slaveId && this.start == rhs.start;
    }
}

