/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.storage.json.internal;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.storage.json.internal.StorageEntry;

@NonNullByDefault
public class StorageEntryMapDeserializer
implements JsonDeserializer<Map<String, StorageEntry>> {
    private boolean isOuterMap(JsonObject obj) {
        for (Map.Entry me : obj.entrySet()) {
            JsonElement v = (JsonElement)me.getValue();
            if (!v.isJsonObject()) {
                return false;
            }
            Set entrySet = ((JsonObject)v).entrySet();
            if (entrySet.size() != 2) {
                return false;
            }
            Set keys = entrySet.stream().map(e -> (String)e.getKey()).collect(Collectors.toSet());
            if (keys.contains("class") && keys.contains("value")) continue;
            return false;
        }
        return true;
    }

    public @Nullable Map<String, StorageEntry> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        if (!this.isOuterMap(obj)) {
            throw new IllegalArgumentException("Object {} is not an outer map: " + obj);
        }
        return this.readOuterMap(obj, context);
    }

    private Map<String, StorageEntry> readOuterMap(JsonObject obj, JsonDeserializationContext context) {
        ConcurrentHashMap<String, StorageEntry> map = new ConcurrentHashMap<String, StorageEntry>();
        for (Map.Entry me : obj.entrySet()) {
            String key = (String)me.getKey();
            JsonObject value = ((JsonElement)me.getValue()).getAsJsonObject();
            StorageEntry innerMap = new StorageEntry(value.get("class").getAsString(), value.get("value"));
            map.put(key, innerMap);
        }
        return map;
    }
}

