/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.core.valueconverter;

import java.math.BigDecimal;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

@NonNullByDefault
public class ValueTypeToStringConverter
implements IValueConverter<Object> {
    public @Nullable Object toValue(@Nullable String string, @Nullable INode node) throws ValueConverterException {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            try {
                return Strings.convertFromJavaString((String)string.substring(1, string.length() - 1), (boolean)true);
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }
        if ("true".equals(string) || "false".equals(string)) {
            return Boolean.valueOf(string);
        }
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Number expected.", node, (Exception)e);
        }
    }

    public String toString(@Nullable Object value) throws ValueConverterException {
        if (value == null) {
            throw new ValueConverterException("Value may not be null.", null, null);
        }
        Object object = value;
        if (object instanceof String && (var2_3 = (String)object) == (String)var3_2) {
            return this.toEscapedString((String)string);
        }
        if (value instanceof BigDecimal var4_5) {
            return decimalValue.toPlainString();
        }
        if (value instanceof Boolean var6_7) {
            return boolean1.toString();
        }
        throw new ValueConverterException("Unknown value type: " + value.getClass().getSimpleName(), null, null);
    }

    protected String toEscapedString(String value) {
        return String.valueOf('\"') + Strings.convertToJavaString((String)value, (boolean)false) + '\"';
    }
}

