/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.thing.valueconverter;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class UIDtoStringConverter
implements IValueConverter<String> {
    private static final String SEPERATOR = ":";

    public String toValue(String string, INode node) throws ValueConverterException {
        if (string == null) {
            return null;
        }
        String[] ids = string.split(SEPERATOR);
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            if (id != null && id.startsWith("\"") && id.endsWith("\"")) {
                try {
                    ids[i] = Strings.convertFromJavaString((String)id.substring(1, id.length() - 1), (boolean)true);
                }
                catch (IllegalArgumentException e) {
                    throw new ValueConverterException(e.getMessage(), node, (Exception)e);
                }
            }
            ++i;
        }
        return Arrays.stream(ids).collect(Collectors.joining(SEPERATOR));
    }

    public String toString(String value) throws ValueConverterException {
        if (value == null) {
            throw new ValueConverterException("Value may not be null.", null, null);
        }
        String[] ids = value.split(SEPERATOR);
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            if (id != null && !id.matches("[A-Za-z0-9_]*")) {
                ids[i] = this.toEscapedString(id);
            }
            ++i;
        }
        return Arrays.stream(ids).collect(Collectors.joining(SEPERATOR));
    }

    protected String toEscapedString(String value) {
        return String.valueOf('\"') + Strings.convertToJavaString((String)value, (boolean)false) + '\"';
    }
}

