/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.thing.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.model.core.EventType;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.core.ModelRepositoryChangeListener;
import org.openhab.core.model.thing.internal.AbstractProviderLazyNullness;
import org.openhab.core.model.thing.thing.ModelBridge;
import org.openhab.core.model.thing.thing.ModelChannel;
import org.openhab.core.model.thing.thing.ModelProperty;
import org.openhab.core.model.thing.thing.ModelPropertyContainer;
import org.openhab.core.model.thing.thing.ModelThing;
import org.openhab.core.model.thing.thing.ThingModel;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyService;
import org.openhab.core.thing.Channel;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingProvider;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.binding.ThingHandlerFactory;
import org.openhab.core.thing.binding.builder.BridgeBuilder;
import org.openhab.core.thing.binding.builder.ChannelBuilder;
import org.openhab.core.thing.binding.builder.ThingBuilder;
import org.openhab.core.thing.type.AutoUpdatePolicy;
import org.openhab.core.thing.type.ChannelDefinition;
import org.openhab.core.thing.type.ChannelKind;
import org.openhab.core.thing.type.ChannelType;
import org.openhab.core.thing.type.ChannelTypeRegistry;
import org.openhab.core.thing.type.ChannelTypeUID;
import org.openhab.core.thing.type.ThingType;
import org.openhab.core.thing.type.ThingTypeRegistry;
import org.openhab.core.thing.util.ThingHelper;
import org.openhab.core.util.BundleResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ThingProvider.class})
public class GenericThingProvider
extends AbstractProviderLazyNullness<Thing>
implements ThingProvider,
ModelRepositoryChangeListener,
ReadyService.ReadyTracker {
    private static final String XML_THING_TYPE = "openhab.xmlThingTypes";
    private LocaleProvider localeProvider;
    private ModelRepository modelRepository;
    private ThingTypeRegistry thingTypeRegistry;
    private ChannelTypeRegistry channelTypeRegistry;
    private BundleResolver bundleResolver;
    private Map<String, Collection<Thing>> thingsMap = new ConcurrentHashMap<String, Collection<Thing>>();
    private List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();
    private ConfigDescriptionRegistry configDescriptionRegistry;
    private final List<QueueContent> queue = new CopyOnWriteArrayList<QueueContent>();
    private Thread lazyRetryThread = null;
    private static final Logger logger = LoggerFactory.getLogger(GenericThingProvider.class);
    private final Set<String> loadedXmlThingTypes = new CopyOnWriteArraySet<String>();
    private boolean modelLoaded = false;
    private final Runnable lazyRetryRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                logger.debug("Starting lazy retry thread");
                while (!GenericThingProvider.this.queue.isEmpty()) {
                    boolean _isEmpty_2;
                    boolean _not_2;
                    boolean _not;
                    boolean _isEmpty = GenericThingProvider.this.queue.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        boolean _not_1;
                        ArrayList<Thing> newThings = new ArrayList<Thing>();
                        Consumer<QueueContent> _function = qc -> {
                            logger.trace("Searching thingHandlerFactory for thingType: {}", (Object)qc.thingTypeUID);
                            Thing thing = qc.thingHandlerFactory.createThing(qc.thingTypeUID, qc.configuration, qc.thingUID, qc.bridgeUID);
                            if (thing != null) {
                                GenericThingProvider.this.queue.remove(qc);
                                logger.debug("Successfully loaded '{}' during retry", (Object)qc.thingUID);
                                newThings.add(thing);
                            }
                        };
                        GenericThingProvider.this.queue.forEach(_function);
                        boolean _isEmpty_1 = newThings.isEmpty();
                        boolean bl2 = _not_1 = !_isEmpty_1;
                        if (_not_1) {
                            Consumer<Thing> _function_1 = newThing -> {
                                Functions.Function1 _function_2 = mName -> {
                                    Functions.Function1 _function_3 = it -> {
                                        ThingUID _uID = it.getUID();
                                        ThingUID _uID_1 = newThing.getUID();
                                        return Objects.equal((Object)_uID, (Object)_uID_1);
                                    };
                                    boolean _isEmpty_2 = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)GenericThingProvider.this.thingsMap.get(mName), (Functions.Function1)_function_3));
                                    return !_isEmpty_2;
                                };
                                String modelName = (String)IterableExtensions.findFirst(GenericThingProvider.this.thingsMap.keySet(), (Functions.Function1)_function_2);
                                Functions.Function1 _function_3 = it -> {
                                    ThingUID _uID = it.getUID();
                                    ThingUID _uID_1 = newThing.getUID();
                                    return Objects.equal((Object)_uID, (Object)_uID_1);
                                };
                                Thing oldThing = (Thing)IterableExtensions.findFirst((Iterable)GenericThingProvider.this.thingsMap.get(modelName), (Functions.Function1)_function_3);
                                if (oldThing != null) {
                                    boolean _not_2;
                                    GenericThingProvider.this.merge(newThing, oldThing);
                                    GenericThingProvider.this.thingsMap.get(modelName).remove(oldThing);
                                    GenericThingProvider.this.thingsMap.get(modelName).add((Thing)newThing);
                                    logger.debug("Refreshing thing '{}' after successful retry", (Object)newThing.getUID());
                                    boolean _equals = ThingHelper.equals((Thing)oldThing, (Thing)newThing);
                                    boolean bl = _not_2 = !_equals;
                                    if (_not_2) {
                                        GenericThingProvider.this.notifyListenersAboutUpdatedElement(oldThing, newThing);
                                    }
                                } else {
                                    String _format = String.format("Item %s not yet known", newThing.getUID());
                                    throw new IllegalStateException(_format);
                                }
                            };
                            newThings.forEach(_function_1);
                        }
                    }
                    boolean bl3 = _not_2 = !(_isEmpty_2 = GenericThingProvider.this.queue.isEmpty());
                    if (!_not_2) continue;
                    Thread.sleep(1000L);
                }
                logger.debug("Lazy retry thread ran out of work. Good bye.");
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    };

    public void activate() {
        Consumer<String> _function = it -> this.createThingsFromModel((String)it);
        this.modelRepository.getAllModelNamesOfType("things").forEach(_function);
    }

    public Collection<Thing> getAll() {
        return IterableExtensions.toList((Iterable)Iterables.concat(this.thingsMap.values()));
    }

    private void createThingsFromModel(String modelName) {
        boolean _tripleEquals;
        logger.debug("Read things from model '{}'", (Object)modelName);
        Collection<Thing> _get = this.thingsMap.get(modelName);
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            this.thingsMap.put(modelName, CollectionLiterals.newArrayList());
        }
        if (this.modelRepository != null) {
            EObject _model = this.modelRepository.getModel(modelName);
            ThingModel model = (ThingModel)_model;
            if (model == null) {
                return;
            }
            Functions.Function1 _function = it -> {
                ThingUID thingUID = this.constructThingUID((ModelThing)it);
                if (thingUID == null) {
                    return null;
                }
                ThingTypeUID thingTypeUID = this.constructThingTypeUID((ModelThing)it, thingUID);
                if (thingTypeUID == null) {
                    return null;
                }
                Functions.Function1 _function_1 = it_1 -> it_1.supportsThingType(thingTypeUID);
                ThingHandlerFactory factory = (ThingHandlerFactory)IterableExtensions.findFirst(this.thingHandlerFactories, (Functions.Function1)_function_1);
                if (Objects.equal((Object)factory, null) && this.modelLoaded) {
                    logger.info("No ThingHandlerFactory found for thing {} (thing-type is {}). Deferring initialization.", (Object)thingUID, (Object)thingTypeUID);
                }
                return factory;
            };
            Iterable _map = IterableExtensions.map(this.flattenModelThings((Iterable<ModelThing>)model.getThings()), (Functions.Function1)_function);
            Iterable _filter = null;
            if (_map != null) {
                Functions.Function1 _function_1 = it -> it != null;
                _filter = IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
            }
            Set _set = null;
            if (_filter != null) {
                _set = IterableExtensions.toSet((Iterable)_filter);
            }
            if (_set != null) {
                Consumer<ThingHandlerFactory> _function_2 = it -> this.createThingsFromModelForThingHandlerFactory(modelName, (ThingHandlerFactory)it);
                _set.forEach(_function_2);
            }
        }
    }

    private ThingUID constructThingUID(ModelThing modelThing) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        String _id = modelThing.getId();
        boolean bl = _tripleNotEquals = _id != null;
        if (_tripleNotEquals) {
            String _id_1 = modelThing.getId();
            return new ThingUID(_id_1);
        }
        String _bridgeUID = modelThing.getBridgeUID();
        boolean bl2 = _tripleNotEquals_1 = _bridgeUID != null;
        if (_tripleNotEquals_1) {
            String _bridgeUID_1 = modelThing.getBridgeUID();
            String bindingId = new ThingUID(_bridgeUID_1).getBindingId();
            String _thingTypeId = modelThing.getThingTypeId();
            String _thingId = modelThing.getThingId();
            return new ThingUID(bindingId, _thingTypeId, _thingId);
        }
        logger.warn("Thing {} does not have a bridge so it needs to be defined in full notation like <bindingId>:{}:{}", new Object[]{modelThing.getThingTypeId(), modelThing.getThingTypeId(), modelThing.getThingId()});
        return null;
    }

    private ThingTypeUID constructThingTypeUID(ModelThing modelThing, ThingUID thingUID) {
        boolean _not;
        boolean _tripleNotEquals;
        String _thingTypeId = modelThing.getThingTypeId();
        boolean bl = _tripleNotEquals = _thingTypeId != null;
        if (_tripleNotEquals) {
            String _bindingId = thingUID.getBindingId();
            String _thingTypeId_1 = modelThing.getThingTypeId();
            return new ThingTypeUID(_bindingId, _thingTypeId_1);
        }
        String[] segments = thingUID.getAsString().split(":");
        boolean _isEmpty = segments[1].isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            String _bindingId_1 = thingUID.getBindingId();
            String _get = segments[1];
            return new ThingTypeUID(_bindingId_1, _get);
        }
        return null;
    }

    private Iterable<ModelThing> flattenModelThings(Iterable<ModelThing> things) {
        if (things == null || ((Object[])Conversions.unwrapArray(things, Object.class)).length == 0) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Consumer<ModelThing> _function = it -> {
            String _string;
            String _elvis = null;
            String _thingId = it.getThingId();
            _elvis = _thingId != null ? _thingId : (_string = this.constructThingUID((ModelThing)it).toString());
            it.setThingId(_elvis);
        };
        things.forEach(_function);
        Consumer<ModelBridge> _function_1 = it -> {
            ModelBridge bridge = it;
            Consumer<ModelThing> _function_2 = it_1 -> {
                ModelThing thing = it_1;
                thing.setBridgeUID(bridge.getId());
                String _elvis = null;
                String _id = it_1.getId();
                if (_id != null) {
                    _elvis = _id;
                } else {
                    String _string;
                    String _id_1 = bridge.getId();
                    ThingUID _thingUID = new ThingUID(_id_1);
                    _elvis = _string = this.getThingUID((ModelThing)it_1, _thingUID).toString();
                }
                thing.setId(_elvis);
            };
            bridge.getThings().forEach(_function_2);
        };
        Iterables.filter(things, ModelBridge.class).forEach(_function_1);
        Functions.Function1 _function_2 = b -> b.getThings();
        Iterable<ModelThing> _flattenModelThings = this.flattenModelThings(Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter(things, ModelBridge.class), (Functions.Function1)_function_2)));
        return Iterables.concat(things, _flattenModelThings);
    }

    private void createThing(ModelThing modelThing, Collection<Thing> thingList, ThingHandlerFactory thingHandlerFactory) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        boolean _not;
        ThingUID thingUID = this.getThingUID(modelThing, null);
        if (thingUID == null) {
            return;
        }
        ThingTypeUID thingTypeUID = this.constructThingTypeUID(modelThing, thingUID);
        if (thingTypeUID == null) {
            return;
        }
        boolean _isSupportedByThingHandlerFactory = this.isSupportedByThingHandlerFactory(thingTypeUID, thingHandlerFactory);
        boolean bl = _not = !_isSupportedByThingHandlerFactory;
        if (_not) {
            return;
        }
        logger.trace("Creating thing for type '{}' with UID '{}.", (Object)thingTypeUID, (Object)thingUID);
        Configuration configuration = this.createConfiguration(modelThing);
        ThingUID uid = thingUID;
        Functions.Function1 _function = it -> it.getUID().equals((Object)uid);
        boolean _exists = IterableExtensions.exists(thingList, (Functions.Function1)_function);
        if (_exists) {
            logger.debug("Thing already exists {}", (Object)uid.toString());
            return;
        }
        ThingType thingType = this.getThingType(thingTypeUID);
        String _xifexpression = null;
        String _label = modelThing.getLabel();
        boolean bl2 = _tripleNotEquals = _label != null;
        if (_tripleNotEquals) {
            _xifexpression = modelThing.getLabel();
        } else {
            String _label_1 = null;
            if (thingType != null) {
                _label_1 = thingType.getLabel();
            }
            _xifexpression = _label_1;
        }
        String label = _xifexpression;
        String location = modelThing.getLocation();
        ThingUID _xifexpression_1 = null;
        String _bridgeUID = modelThing.getBridgeUID();
        boolean bl3 = _tripleNotEquals_1 = _bridgeUID != null;
        if (_tripleNotEquals_1) {
            String _bridgeUID_1 = modelThing.getBridgeUID();
            _xifexpression_1 = new ThingUID(_bridgeUID_1);
        }
        ThingUID bridgeUID = _xifexpression_1;
        Thing thingFromHandler = this.getThingFromThingHandlerFactories(thingTypeUID, label, configuration, thingUID, bridgeUID, thingHandlerFactory);
        Object _xifexpression_2 = null;
        _xifexpression_2 = modelThing instanceof ModelBridge ? BridgeBuilder.create((ThingTypeUID)thingTypeUID, (ThingUID)thingUID) : ThingBuilder.create((ThingTypeUID)thingTypeUID, (ThingUID)thingUID);
        BridgeBuilder thingBuilder = _xifexpression_2;
        thingBuilder.withConfiguration(configuration);
        thingBuilder.withBridge(bridgeUID);
        thingBuilder.withLabel(label);
        thingBuilder.withLocation(location);
        EList<ModelChannel> _channels = modelThing.getChannels();
        List _elvis = null;
        List _channelDefinitions = null;
        if (thingType != null) {
            _channelDefinitions = thingType.getChannelDefinitions();
        }
        if (_channelDefinitions != null) {
            _elvis = _channelDefinitions;
        } else {
            ArrayList _newArrayList = CollectionLiterals.newArrayList();
            _elvis = _newArrayList;
        }
        List<Channel> channels = this.createChannels(thingTypeUID, thingUID, (List<ModelChannel>)_channels, _elvis);
        thingBuilder.withChannels(channels);
        Thing thing = thingBuilder.build();
        if (thingFromHandler != null) {
            this.merge(thingFromHandler, thing);
        }
        Thing _elvis_1 = null;
        _elvis_1 = thingFromHandler != null ? thingFromHandler : thing;
        thingList.add(_elvis_1);
    }

    private boolean isSupportedByThingHandlerFactory(ThingTypeUID thingTypeUID, ThingHandlerFactory specific) {
        if (specific != null) {
            return specific.supportsThingType(thingTypeUID);
        }
        for (ThingHandlerFactory thingHandlerFactory : this.thingHandlerFactories) {
            boolean _supportsThingType = thingHandlerFactory.supportsThingType(thingTypeUID);
            if (!_supportsThingType) continue;
            return true;
        }
        return false;
    }

    private Thing getThingFromThingHandlerFactories(ThingTypeUID thingTypeUID, String label, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID, ThingHandlerFactory specific) {
        Object _xblockexpression = null;
        if (specific != null && specific.supportsThingType(thingTypeUID)) {
            logger.trace("Creating thing from specific ThingHandlerFactory {} for thingType {}", (Object)specific, (Object)thingTypeUID);
            return this.getThingFromThingHandlerFactory(thingTypeUID, label, configuration, thingUID, bridgeUID, specific);
        }
        for (ThingHandlerFactory thingHandlerFactory : this.thingHandlerFactories) {
            logger.trace("Searching thingHandlerFactory for thingType: {}", (Object)thingTypeUID);
            boolean _supportsThingType = thingHandlerFactory.supportsThingType(thingTypeUID);
            if (!_supportsThingType) continue;
            return this.getThingFromThingHandlerFactory(thingTypeUID, label, configuration, thingUID, bridgeUID, thingHandlerFactory);
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    private Thing getThingFromThingHandlerFactory(ThingTypeUID thingTypeUID, String label, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID, ThingHandlerFactory thingHandlerFactory) {
        Thing thing = thingHandlerFactory.createThing(thingTypeUID, configuration, thingUID, bridgeUID);
        if (thing == null) {
            logger.debug("ThingHandlerFactory '{}' claimed it can handle '{}' type but actually did not. Queued for later refresh.", (Object)thingHandlerFactory.getClass().getSimpleName(), (Object)thingTypeUID.getAsString());
            QueueContent _queueContent = new QueueContent(thingTypeUID, label, configuration, thingUID, bridgeUID, thingHandlerFactory);
            this.queue.add(_queueContent);
            if (this.lazyRetryThread == null || !this.lazyRetryThread.isAlive()) {
                Thread _thread;
                this.lazyRetryThread = _thread = new Thread(this.lazyRetryRunnable);
                this.lazyRetryThread.start();
            }
        } else {
            thing.setLabel(label);
        }
        return thing;
    }

    protected void _merge(Thing targetThing, Thing sourceThing) {
        targetThing.setBridgeUID(sourceThing.getBridgeUID());
        this.merge(targetThing.getConfiguration(), sourceThing.getConfiguration());
        this.merge(targetThing, sourceThing.getChannels());
        targetThing.setLocation(sourceThing.getLocation());
        targetThing.setLabel(sourceThing.getLabel());
    }

    protected void _merge(Configuration target, Configuration source) {
        Consumer<String> _function = it -> target.put(it, source.get(it));
        source.keySet().forEach(_function);
    }

    protected void _merge(Thing targetThing, List<Channel> source) {
        ArrayList channelsToAdd = CollectionLiterals.newArrayList();
        Consumer<Channel> _function = sourceChannel -> {
            Functions.Function1 _function_1 = it -> it.getUID().equals((Object)sourceChannel.getUID());
            Iterable targetChannels = IterableExtensions.filter((Iterable)targetThing.getChannels(), (Functions.Function1)_function_1);
            Consumer<Channel> _function_2 = it -> this.merge(it, sourceChannel);
            targetChannels.forEach(_function_2);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)targetChannels);
            if (_isEmpty) {
                channelsToAdd.add(sourceChannel);
            }
        };
        source.forEach(_function);
        ThingHelper.addChannelsToThing((Thing)targetThing, (Collection)channelsToAdd);
    }

    protected void _merge(Channel target, Channel source) {
        this.merge(target.getConfiguration(), source.getConfiguration());
    }

    private ArrayList<String> getParentPath(ThingUID bridgeUID) {
        ArrayList bridgeIds = CollectionLiterals.newArrayList();
        bridgeIds.addAll(bridgeUID.getBridgeIds());
        bridgeIds.add(bridgeUID.getId());
        return bridgeIds;
    }

    private List<Channel> createChannels(ThingTypeUID thingTypeUID, ThingUID thingUID, List<ModelChannel> modelChannels, List<ChannelDefinition> channelDefinitions) {
        ArrayList _xblockexpression = null;
        HashSet addedChannelIds = CollectionLiterals.newHashSet();
        ArrayList channels = CollectionLiterals.newArrayList();
        Consumer<ModelChannel> _function = it -> {
            boolean _add = addedChannelIds.add(it.getId());
            if (_add) {
                boolean _tripleNotEquals;
                ChannelKind parsedKind = ChannelKind.STATE;
                ChannelTypeUID channelTypeUID = null;
                String itemType = null;
                String label = it.getLabel();
                Configuration configuration = this.createConfiguration((ModelPropertyContainer)it);
                AutoUpdatePolicy autoUpdatePolicy = null;
                String _channelType = it.getChannelType();
                boolean bl = _tripleNotEquals = _channelType != null;
                if (_tripleNotEquals) {
                    String _channelType_1;
                    String _bindingId = thingUID.getBindingId();
                    ChannelTypeUID _channelTypeUID = new ChannelTypeUID(_bindingId, _channelType_1 = it.getChannelType());
                    channelTypeUID = _channelTypeUID;
                    ChannelType resolvedChannelType = this.getChannelType(channelTypeUID);
                    if (resolvedChannelType != null) {
                        itemType = resolvedChannelType.getItemType();
                        parsedKind = resolvedChannelType.getKind();
                        if (label == null) {
                            label = resolvedChannelType.getLabel();
                        }
                        autoUpdatePolicy = resolvedChannelType.getAutoUpdatePolicy();
                        URI cfgDescUriOfresolvedChannelType = resolvedChannelType.getConfigDescriptionURI();
                        if (cfgDescUriOfresolvedChannelType != null) {
                            ConfigUtil.applyDefaultConfiguration((Configuration)configuration, (ConfigDescription)this.configDescriptionRegistry.getConfigDescription(cfgDescUriOfresolvedChannelType));
                        }
                    } else {
                        logger.error("Channel type {} could not be resolved.", (Object)channelTypeUID.getAsString());
                    }
                } else {
                    itemType = it.getType();
                    String _xifexpression = null;
                    String _channelKind = it.getChannelKind();
                    boolean _tripleEquals = _channelKind == null;
                    _xifexpression = _tripleEquals ? "State" : it.getChannelKind();
                    String kind = _xifexpression;
                    parsedKind = ChannelKind.parse((String)kind);
                }
                String _id = it.getId();
                ChannelUID _channelUID = new ChannelUID(thingUID, _id);
                ChannelBuilder channel = ChannelBuilder.create((ChannelUID)_channelUID, (String)itemType).withKind(parsedKind).withConfiguration(configuration).withType(channelTypeUID).withLabel(label).withAutoUpdatePolicy(autoUpdatePolicy);
                Channel _build = channel.build();
                channels.add(_build);
            }
        };
        modelChannels.forEach(_function);
        Consumer<ChannelDefinition> _function_1 = it -> {
            boolean _add = addedChannelIds.add(it.getId());
            if (_add) {
                ChannelType channelType = this.getChannelType(it.getChannelTypeUID());
                if (channelType != null) {
                    String _id = it.getId();
                    ChannelUID _channelUID = new ChannelUID(thingUID, _id);
                    Channel _build = ChannelBuilder.create((ChannelUID)_channelUID, (String)channelType.getItemType()).withType(it.getChannelTypeUID()).withAutoUpdatePolicy(channelType.getAutoUpdatePolicy()).build();
                    channels.add(_build);
                } else {
                    logger.warn("Could not create channel '{}' for thing '{}', because channel type '{}' could not be found.", new Object[]{it.getId(), thingUID, it.getChannelTypeUID()});
                }
            }
        };
        channelDefinitions.forEach(_function_1);
        _xblockexpression = channels;
        return _xblockexpression;
    }

    private Configuration createConfiguration(ModelPropertyContainer propertyContainer) {
        Configuration _xblockexpression = null;
        Configuration configuration = new Configuration();
        Consumer<ModelProperty> _function = it -> {
            boolean _tripleEquals;
            int _size = it.getValue().size();
            boolean bl = _tripleEquals = _size == 1;
            if (_tripleEquals) {
                configuration.put(it.getKey(), it.getValue().get(0));
            } else {
                configuration.put(it.getKey(), it.getValue());
            }
        };
        propertyContainer.getProperties().forEach(_function);
        _xblockexpression = configuration;
        return _xblockexpression;
    }

    private ThingType getThingType(ThingTypeUID thingTypeUID) {
        ThingType _thingType = null;
        if (this.thingTypeRegistry != null) {
            _thingType = this.thingTypeRegistry.getThingType(thingTypeUID, this.localeProvider.getLocale());
        }
        return _thingType;
    }

    private ChannelType getChannelType(ChannelTypeUID channelTypeUID) {
        ChannelType _channelType = null;
        if (this.channelTypeRegistry != null) {
            _channelType = this.channelTypeRegistry.getChannelType(channelTypeUID, this.localeProvider.getLocale());
        }
        return _channelType;
    }

    @Reference
    protected void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
    }

    protected void unsetModelRepository(ModelRepository modelRepository) {
        modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepository = null;
    }

    @Reference
    protected void setBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = bundleResolver;
    }

    protected void unsetBundleResolver(BundleResolver bundleResolver) {
        this.bundleResolver = null;
    }

    public void modelChanged(String modelName, EventType type) {
        boolean _endsWith = modelName.endsWith("things");
        if (_endsWith && type != null) {
            switch (type) {
                case ADDED: {
                    this.createThingsFromModel(modelName);
                    break;
                }
                case MODIFIED: {
                    ArrayList _newArrayList;
                    ArrayList _elvis = null;
                    ArrayList _get = this.thingsMap.get(modelName);
                    _elvis = _get != null ? _get : (_newArrayList = CollectionLiterals.newArrayList());
                    ArrayList oldThings = _elvis;
                    EObject _model = this.modelRepository.getModel(modelName);
                    ThingModel model = (ThingModel)_model;
                    if (model == null) break;
                    Set<ThingUID> newThingUIDs = this.getAllThingUIDs(model);
                    Functions.Function1 _function = it -> {
                        boolean _contains = newThingUIDs.contains(it.getUID());
                        return !_contains;
                    };
                    Iterable removedThings = IterableExtensions.filter((Iterable)oldThings, (Functions.Function1)_function);
                    Consumer<Thing> _function_1 = it -> {
                        logger.debug("Removing thing '{}' from model '{}'.", (Object)it.getUID(), (Object)modelName);
                        this.notifyListenersAboutRemovedElement(it);
                    };
                    removedThings.forEach(_function_1);
                    this.createThingsFromModel(modelName);
                    CollectionExtensions.removeAll(this.thingsMap.get(modelName), (Iterable)removedThings);
                    break;
                }
                case REMOVED: {
                    ArrayList _newArrayList_1;
                    logger.debug("Removing all things from model '{}'.", (Object)modelName);
                    ArrayList _elvis_1 = null;
                    ArrayList _remove = this.thingsMap.remove(modelName);
                    _elvis_1 = _remove != null ? _remove : (_newArrayList_1 = CollectionLiterals.newArrayList());
                    ArrayList things = _elvis_1;
                    Consumer<Thing> _function_2 = it -> this.notifyListenersAboutRemovedElement(it);
                    things.forEach(_function_2);
                    break;
                }
            }
        }
    }

    private Set<ThingUID> getAllThingUIDs(ThingModel model) {
        return this.getAllThingUIDs((List<ModelThing>)model.getThings(), null);
    }

    private Set<ThingUID> getAllThingUIDs(List<ModelThing> thingList, ThingUID parentUID) {
        HashSet<ThingUID> ret = new HashSet<ThingUID>();
        Consumer<ModelThing> _function = it -> {
            ThingUID thingUID2 = this.getThingUID((ModelThing)it, parentUID);
            ret.add(thingUID2);
            if (it instanceof ModelBridge) {
                ret.addAll(this.getAllThingUIDs((List<ModelThing>)((ModelBridge)it).getThings(), thingUID2));
            }
        };
        thingList.forEach(_function);
        return ret;
    }

    private ThingUID getThingUID(ModelThing modelThing, ThingUID parentUID) {
        if (parentUID != null && modelThing.getId() == null) {
            String _bindingId = parentUID.getBindingId();
            String _thingTypeId = modelThing.getThingTypeId();
            ThingTypeUID thingTypeUID = new ThingTypeUID(_bindingId, _thingTypeId);
            String _thingId = modelThing.getThingId();
            ArrayList<String> _parentPath = this.getParentPath(parentUID);
            return new ThingUID(thingTypeUID, _thingId, (String[])Conversions.unwrapArray(_parentPath, String.class));
        }
        return this.constructThingUID(modelThing);
    }

    @Reference
    protected void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    protected void unsetLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = thingTypeRegistry;
    }

    protected void unsetThingTypeRegistry(ThingTypeRegistry thingTypeRegistry) {
        this.thingTypeRegistry = null;
    }

    @Reference
    protected void setChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
    }

    protected void unsetChannelTypeRegistry(ChannelTypeRegistry channelTypeRegistry) {
        this.channelTypeRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        logger.debug("ThingHandlerFactory added {}", (Object)thingHandlerFactory);
        this.thingHandlerFactories.add(thingHandlerFactory);
        this.thingHandlerFactoryAdded(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
        this.thingHandlerFactoryRemoved();
    }

    private Object thingHandlerFactoryRemoved() {
        return null;
    }

    public void thingHandlerFactoryAdded(ThingHandlerFactory thingHandlerFactory) {
        Consumer<String> _function = it -> this.createThingsFromModelForThingHandlerFactory((String)it, thingHandlerFactory);
        this.thingsMap.keySet().forEach(_function);
    }

    @Reference
    public void setReadyService(ReadyService readyService) {
        readyService.registerTracker((ReadyService.ReadyTracker)this);
    }

    public void unsetReadyService(ReadyService readyService) {
        readyService.unregisterTracker((ReadyService.ReadyTracker)this);
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        String type = readyMarker.getType();
        boolean _equals = "startlevel".equals(type);
        if (_equals) {
            boolean _greaterEqualsThan;
            int _parseInt = Integer.parseInt(readyMarker.getIdentifier());
            this.modelLoaded = _greaterEqualsThan = _parseInt >= 20;
        } else {
            boolean _equals_1 = XML_THING_TYPE.equals(type);
            if (_equals_1) {
                String bsn = readyMarker.getIdentifier();
                this.loadedXmlThingTypes.add(bsn);
                this.handleXmlThingTypesLoaded(bsn);
            }
        }
    }

    private String getBundleName(ThingHandlerFactory thingHandlerFactory) {
        return this.bundleResolver.resolveBundle(thingHandlerFactory.getClass()).getSymbolicName();
    }

    private void handleXmlThingTypesLoaded(String bsn) {
        Functions.Function1 _function = it -> this.getBundleName((ThingHandlerFactory)it).equals(bsn);
        Consumer<ThingHandlerFactory> _function_1 = thingHandlerFactory -> this.thingHandlerFactoryAdded((ThingHandlerFactory)thingHandlerFactory);
        IterableExtensions.filter(this.thingHandlerFactories, (Functions.Function1)_function).forEach(_function_1);
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        String bsn = readyMarker.getIdentifier();
        this.loadedXmlThingTypes.remove(bsn);
    }

    private void createThingsFromModelForThingHandlerFactory(String modelName, ThingHandlerFactory factory) {
        if (!this.loadedXmlThingTypes.contains(this.getBundleName(factory)) || Objects.equal((Object)this.modelRepository, null)) {
            return;
        }
        Thing[] oldThings = (Thing[])((Thing[])Conversions.unwrapArray(this.thingsMap.get(modelName), Thing.class)).clone();
        ArrayList newThings = CollectionLiterals.newArrayList();
        EObject _model = this.modelRepository.getModel(modelName);
        ThingModel model = (ThingModel)_model;
        if (model != null) {
            Consumer<ModelThing> _function = it -> this.createThing((ModelThing)it, newThings, factory);
            this.flattenModelThings((Iterable<ModelThing>)model.getThings()).forEach(_function);
        }
        Consumer<Thing> _function_1 = newThing -> {
            this.thingsMap.get(modelName).add((Thing)newThing);
            Functions.Function1 _function_2 = it -> {
                ThingUID _uID = it.getUID();
                ThingUID _uID_1 = newThing.getUID();
                return Objects.equal((Object)_uID, (Object)_uID_1);
            };
            Thing oldThing = (Thing)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)oldThings)), (Functions.Function1)_function_2);
            if (oldThing != null) {
                boolean _not;
                boolean _equals = ThingHelper.equals((Thing)oldThing, (Thing)newThing);
                boolean bl = _not = !_equals;
                if (_not) {
                    logger.debug("Updating thing '{}' from model '{}'.", (Object)newThing.getUID(), (Object)modelName);
                    this.notifyListenersAboutUpdatedElement(oldThing, newThing);
                }
            } else {
                logger.debug("Adding thing '{}' from model '{}'.", (Object)newThing.getUID(), (Object)modelName);
                this.notifyListenersAboutAddedElement(newThing);
            }
        };
        newThings.forEach(_function_1);
    }

    @Reference
    protected void setConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = configDescriptionRegistry;
    }

    protected void unsetConfigDescriptionRegistry(ConfigDescriptionRegistry configDescriptionRegistry) {
        this.configDescriptionRegistry = null;
    }

    public void merge(Object targetThing, Object source) {
        if (targetThing instanceof Thing && source instanceof List) {
            this._merge((Thing)targetThing, (List)source);
            return;
        }
        if (targetThing instanceof Thing && source instanceof Thing) {
            this._merge((Thing)targetThing, (Thing)source);
            return;
        }
        if (targetThing instanceof Configuration && source instanceof Configuration) {
            this._merge((Configuration)targetThing, (Configuration)source);
            return;
        }
        if (targetThing instanceof Channel && source instanceof Channel) {
            this._merge((Channel)targetThing, (Channel)source);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(targetThing, source).toString());
    }

    @Data
    private static final class QueueContent {
        private final ThingTypeUID thingTypeUID;
        private final String label;
        private final Configuration configuration;
        private final ThingUID thingUID;
        private final ThingUID bridgeUID;
        private final ThingHandlerFactory thingHandlerFactory;

        public QueueContent(ThingTypeUID thingTypeUID, String label, Configuration configuration, ThingUID thingUID, ThingUID bridgeUID, ThingHandlerFactory thingHandlerFactory) {
            this.thingTypeUID = thingTypeUID;
            this.label = label;
            this.configuration = configuration;
            this.thingUID = thingUID;
            this.bridgeUID = bridgeUID;
            this.thingHandlerFactory = thingHandlerFactory;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.thingTypeUID == null ? 0 : this.thingTypeUID.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
            result = 31 * result + (this.thingUID == null ? 0 : this.thingUID.hashCode());
            result = 31 * result + (this.bridgeUID == null ? 0 : this.bridgeUID.hashCode());
            return 31 * result + (this.thingHandlerFactory == null ? 0 : this.thingHandlerFactory.hashCode());
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueContent other = (QueueContent)obj;
            if (this.thingTypeUID == null ? other.thingTypeUID != null : !this.thingTypeUID.equals((Object)other.thingTypeUID)) {
                return false;
            }
            if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                return false;
            }
            if (this.configuration == null ? other.configuration != null : !this.configuration.equals((Object)other.configuration)) {
                return false;
            }
            if (this.thingUID == null ? other.thingUID != null : !this.thingUID.equals((Object)other.thingUID)) {
                return false;
            }
            if (this.bridgeUID == null ? other.bridgeUID != null : !this.bridgeUID.equals((Object)other.bridgeUID)) {
                return false;
            }
            return !(this.thingHandlerFactory == null ? other.thingHandlerFactory != null : !this.thingHandlerFactory.equals(other.thingHandlerFactory));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("thingTypeUID", (Object)this.thingTypeUID);
            b.add("label", (Object)this.label);
            b.add("configuration", (Object)this.configuration);
            b.add("thingUID", (Object)this.thingUID);
            b.add("bridgeUID", (Object)this.bridgeUID);
            b.add("thingHandlerFactory", (Object)this.thingHandlerFactory);
            return b.toString();
        }

        @Pure
        public ThingTypeUID getThingTypeUID() {
            return this.thingTypeUID;
        }

        @Pure
        public String getLabel() {
            return this.label;
        }

        @Pure
        public Configuration getConfiguration() {
            return this.configuration;
        }

        @Pure
        public ThingUID getThingUID() {
            return this.thingUID;
        }

        @Pure
        public ThingUID getBridgeUID() {
            return this.bridgeUID;
        }

        @Pure
        public ThingHandlerFactory getThingHandlerFactory() {
            return this.thingHandlerFactory;
        }
    }
}

