/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.thing.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.model.item.BindingConfigParseException;
import org.openhab.core.model.item.BindingConfigReader;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.link.ItemChannelLink;
import org.openhab.core.thing.link.ItemChannelLinkProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ItemChannelLinkProvider.class, BindingConfigReader.class})
public class GenericItemChannelLinkProvider
extends AbstractProvider<ItemChannelLink>
implements BindingConfigReader,
ItemChannelLinkProvider {
    private final Logger logger = LoggerFactory.getLogger(GenericItemChannelLinkProvider.class);
    protected Map<String, Set<ItemChannelLink>> itemChannelLinkMap = new ConcurrentHashMap<String, Set<ItemChannelLink>>();
    protected Map<String, Set<String>> contextMap = new ConcurrentHashMap<String, Set<String>>();
    private @Nullable Set<String> previousItemNames;

    public String getBindingType() {
        return "channel";
    }

    public void validateItemType(String itemType, String bindingConfig) throws BindingConfigParseException {
    }

    public void processBindingConfiguration(String context, String itemType, String itemName, String bindingConfig, Configuration configuration) throws BindingConfigParseException {
        String[] uids = bindingConfig.split(",");
        if (uids.length == 0) {
            throw new BindingConfigParseException("At least one Channel UID should be provided: <bindingID>.<thingTypeId>.<thingId>.<channelId>");
        }
        String[] stringArray = uids;
        int n = uids.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            this.createItemChannelLink(context, itemName, uid.trim(), configuration);
            ++n2;
        }
    }

    private void createItemChannelLink(String context, String itemName, String channelUID, Configuration configuration) throws BindingConfigParseException {
        Set<ItemChannelLink> links;
        ChannelUID channelUIDObject = null;
        try {
            channelUIDObject = new ChannelUID(channelUID);
        }
        catch (IllegalArgumentException e) {
            throw new BindingConfigParseException(e.getMessage());
        }
        ItemChannelLink itemChannelLink = new ItemChannelLink(itemName, channelUIDObject, configuration);
        Set<String> itemNames = this.contextMap.get(context);
        if (itemNames == null) {
            itemNames = new HashSet<String>();
            this.contextMap.put(context, itemNames);
        }
        itemNames.add(itemName);
        if (this.previousItemNames != null) {
            this.previousItemNames.remove(itemName);
        }
        if ((links = this.itemChannelLinkMap.get(itemName)) == null) {
            links = new HashSet<ItemChannelLink>();
            this.itemChannelLinkMap.put(itemName, links);
        }
        if (!links.contains(itemChannelLink)) {
            links.add(itemChannelLink);
            this.notifyListenersAboutAddedElement(itemChannelLink);
        } else {
            this.notifyListenersAboutUpdatedElement(itemChannelLink, itemChannelLink);
        }
    }

    public void startConfigurationUpdate(String context) {
        Set<String> previous;
        if (this.previousItemNames != null) {
            this.logger.warn("There already is an update transaction for generic item channel links. Continuing anyway.");
        }
        this.previousItemNames = (previous = this.contextMap.get(context)) != null ? new HashSet<String>(previous) : new HashSet();
    }

    public void stopConfigurationUpdate(String context) {
        Set<String> previousItemNames = this.previousItemNames;
        this.previousItemNames = null;
        if (previousItemNames == null) {
            return;
        }
        for (String itemName : previousItemNames) {
            Set<ItemChannelLink> links = this.itemChannelLinkMap.remove(itemName);
            if (links == null) continue;
            for (ItemChannelLink removedItemChannelLink : links) {
                this.notifyListenersAboutRemovedElement(removedItemChannelLink);
            }
        }
        Optional.ofNullable(this.contextMap.get(context)).ifPresent(ctx -> {
            boolean bl = ctx.removeAll(previousItemNames);
        });
    }

    public Collection<ItemChannelLink> getAll() {
        return this.itemChannelLinkMap.values().stream().flatMap(Collection::stream).toList();
    }
}

