/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.swagger.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.rest.RESTResource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/spec")
@Component(service={OpenApiResource.class})
@JaxrsResource
@JaxrsName(value="spec")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class OpenApiResource
implements RESTResource {
    public static final String API_TITLE = "openHAB REST API";
    public static final String CONTACT_NAME = "openHAB";
    public static final String CONTACT_URL = "https://www.openhab.org/docs/";
    public static final String OAUTH_AUTHORIZE_ENDPOINT = "/auth/authorize";
    public static final String OAUTH_TOKEN_ENDPOINT = "/rest/auth/token";
    private final Logger logger = LoggerFactory.getLogger(OpenApiResource.class);
    private final BundleContext bundleContext;

    @Activate
    public OpenApiResource(BundleContext bc, @Reference Application application) {
        this.bundleContext = bc;
    }

    @GET
    @Produces(value={"application/json"})
    public Object getOpenAPI() {
        try {
            Reader reader = new Reader();
            OpenAPI openAPI = reader.read(this.getReaderClasses());
            openAPI.setInfo(this.createInfo());
            openAPI.setServers(List.of(this.createServer()));
            openAPI.schemaRequirement("oauth2", this.createOAuth2SecurityScheme());
            String json = Json.mapper().writeValueAsString((Object)openAPI);
            return Response.status((Response.Status)Response.Status.OK).entity(Json.mapper().readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){})).build();
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error while serializing the OpenAPI object to JSON");
            return Response.serverError().build();
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Error while enumerating services for OpenAPI generation");
            return Response.serverError().build();
        }
    }

    private Set<Class<?>> getReaderClasses() throws InvalidSyntaxException {
        return this.bundleContext.getServiceReferences(RESTResource.class, null).stream().map(reference -> ((RESTResource)this.bundleContext.getService(reference)).getClass()).collect(Collectors.toSet());
    }

    private Server createServer() {
        ServiceReference applicationReference = this.bundleContext.getServiceReference(Application.class);
        Server server = new Server();
        server.setUrl("/" + applicationReference.getProperty("osgi.jaxrs.application.base"));
        return server;
    }

    private Info createInfo() {
        Contact contact = new Contact();
        contact.setName(CONTACT_NAME);
        contact.setUrl(CONTACT_URL);
        Info info = new Info();
        info.setContact(contact);
        info.setTitle(API_TITLE);
        info.setVersion("6");
        return info;
    }

    private SecurityScheme createOAuth2SecurityScheme() {
        Scopes scopes = new Scopes();
        scopes.addString("admin", "Administration operations");
        OAuthFlow authorizationCode = new OAuthFlow();
        authorizationCode.setAuthorizationUrl(OAUTH_AUTHORIZE_ENDPOINT);
        authorizationCode.setTokenUrl(OAUTH_TOKEN_ENDPOINT);
        authorizationCode.setScopes(scopes);
        OAuthFlows flows = new OAuthFlows();
        flows.setAuthorizationCode(authorizationCode);
        SecurityScheme securityScheme = new SecurityScheme();
        securityScheme.setType(SecurityScheme.Type.OAUTH2);
        securityScheme.setFlows(flows);
        return securityScheme;
    }
}

