/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.sitemap.internal;

import com.google.common.collect.MapMaker;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.SseBroadcaster;
import org.openhab.core.io.rest.core.item.EnrichedItemDTOMapper;
import org.openhab.core.io.rest.sitemap.SitemapSubscriptionService;
import org.openhab.core.io.rest.sitemap.internal.JerseyResponseBuilderUtils;
import org.openhab.core.io.rest.sitemap.internal.MappingDTO;
import org.openhab.core.io.rest.sitemap.internal.PageDTO;
import org.openhab.core.io.rest.sitemap.internal.ServerAliveEvent;
import org.openhab.core.io.rest.sitemap.internal.SitemapDTO;
import org.openhab.core.io.rest.sitemap.internal.SitemapEvent;
import org.openhab.core.io.rest.sitemap.internal.SitemapWidgetEvent;
import org.openhab.core.io.rest.sitemap.internal.SseSinkInfo;
import org.openhab.core.io.rest.sitemap.internal.WidgetDTO;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.model.sitemap.SitemapProvider;
import org.openhab.core.model.sitemap.sitemap.Button;
import org.openhab.core.model.sitemap.sitemap.Buttongrid;
import org.openhab.core.model.sitemap.sitemap.Chart;
import org.openhab.core.model.sitemap.sitemap.ColorArray;
import org.openhab.core.model.sitemap.sitemap.Condition;
import org.openhab.core.model.sitemap.sitemap.Frame;
import org.openhab.core.model.sitemap.sitemap.IconRule;
import org.openhab.core.model.sitemap.sitemap.Image;
import org.openhab.core.model.sitemap.sitemap.Input;
import org.openhab.core.model.sitemap.sitemap.LinkableWidget;
import org.openhab.core.model.sitemap.sitemap.Mapview;
import org.openhab.core.model.sitemap.sitemap.Selection;
import org.openhab.core.model.sitemap.sitemap.Setpoint;
import org.openhab.core.model.sitemap.sitemap.Sitemap;
import org.openhab.core.model.sitemap.sitemap.Slider;
import org.openhab.core.model.sitemap.sitemap.Switch;
import org.openhab.core.model.sitemap.sitemap.Video;
import org.openhab.core.model.sitemap.sitemap.VisibilityRule;
import org.openhab.core.model.sitemap.sitemap.Webview;
import org.openhab.core.model.sitemap.sitemap.Widget;
import org.openhab.core.types.State;
import org.openhab.core.ui.items.ItemUIRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="sitemaps")
@RolesAllowed(value={"user", "administrator"})
@Tag(name="sitemaps")
@Component(service={RESTResource.class, EventSubscriber.class})
@JaxrsResource
@JaxrsName(value="sitemaps")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class SitemapResource
implements RESTResource,
SitemapSubscriptionService.SitemapSubscriptionCallback,
SseBroadcaster.Listener<SseSinkInfo>,
EventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(SitemapResource.class);
    public static final String PATH_SITEMAPS = "sitemaps";
    private static final String SEGMENT_EVENTS = "events";
    private static final String X_ACCEL_BUFFERING_HEADER = "X-Accel-Buffering";
    private static final long TIMEOUT_IN_MS = 30000L;
    private SseBroadcaster<@NonNull SseSinkInfo> broadcaster;
    @Context
    @NonNullByDefault(value={})
    UriInfo uriInfo;
    @Context
    @NonNullByDefault(value={})
    HttpServletRequest request;
    @Context
    @NonNullByDefault(value={})
    HttpServletResponse response;
    @Context
    @NonNullByDefault(value={})
    Sse sse;
    private final ItemUIRegistry itemUIRegistry;
    private final SitemapSubscriptionService subscriptions;
    private final LocaleService localeService;
    private final List<SitemapProvider> sitemapProviders = new ArrayList<SitemapProvider>();
    private final Map<String, SseSinkInfo> knownSubscriptions = new MapMaker().weakValues().makeMap();
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private @Nullable ScheduledFuture<?> cleanSubscriptionsJob;
    private Set<BlockingStateChangeListener> stateChangeListeners = new CopyOnWriteArraySet<BlockingStateChangeListener>();

    @Activate
    public SitemapResource(@Reference ItemUIRegistry itemUIRegistry, @Reference LocaleService localeService, @Reference SitemapSubscriptionService subscriptions) {
        this.itemUIRegistry = itemUIRegistry;
        this.localeService = localeService;
        this.subscriptions = subscriptions;
        this.broadcaster = new SseBroadcaster();
        this.broadcaster.addListener((SseBroadcaster.Listener)this);
        this.cleanSubscriptionsJob = this.scheduler.scheduleAtFixedRate(() -> {
            this.logger.debug("Run clean SSE subscriptions job");
            subscriptions.checkAliveClients();
        }, 1L, 2L, TimeUnit.MINUTES);
    }

    @Deactivate
    protected void deactivate() {
        ScheduledFuture<?> job = this.cleanSubscriptionsJob;
        if (job != null && !job.isCancelled()) {
            this.logger.debug("Cancel clean SSE subscriptions job");
            job.cancel(true);
            this.cleanSubscriptionsJob = null;
        }
        this.broadcaster.removeListener((SseBroadcaster.Listener)this);
        this.broadcaster.close();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.add(provider);
    }

    public void removeSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.remove(provider);
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getSitemaps", summary="Get all available sitemaps.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SitemapDTO.class)))})})
    public Response getSitemaps() {
        this.logger.debug("Received HTTP GET request from IP {} at '{}'", (Object)this.request.getRemoteAddr(), (Object)this.uriInfo.getPath());
        Collection<SitemapDTO> responseObject = this.getSitemapBeans(this.uriInfo.getAbsolutePathBuilder().build(new Object[0]));
        return Response.ok(responseObject).build();
    }

    @GET
    @Path(value="/{sitemapname: [a-zA-Z_0-9]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="getSitemapByName", summary="Get sitemap by name.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SitemapDTO.class))})})
    public Response getSitemapData(@Context HttpHeaders headers, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="sitemapname") @Parameter(description="sitemap name") String sitemapname, @QueryParam(value="type") String type, @QueryParam(value="jsoncallback") @DefaultValue(value="callback") String callback, @QueryParam(value="includeHidden") @Parameter(description="include hidden widgets") boolean includeHiddenWidgets) {
        Locale locale = this.localeService.getLocale(language);
        this.logger.debug("Received HTTP GET request from IP {} at '{}' for media type '{}'.", new Object[]{this.request.getRemoteAddr(), this.uriInfo.getPath(), type});
        SitemapDTO responseObject = this.getSitemapBean(sitemapname, this.uriInfo.getBaseUriBuilder().build(new Object[0]), locale, includeHiddenWidgets);
        return Response.ok((Object)responseObject).build();
    }

    @GET
    @Path(value="/{sitemapname: [a-zA-Z_0-9]+}/{pageid: [a-zA-Z_0-9]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="pollDataForSitemap", summary="Polls the data for a sitemap.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=PageDTO.class))}), @ApiResponse(responseCode="404", description="Sitemap with requested name does not exist or page does not exist, or page refers to a non-linkable widget"), @ApiResponse(responseCode="400", description="Invalid subscription id has been provided.")})
    public Response getPageData(@Context HttpHeaders headers, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="sitemapname") @Parameter(description="sitemap name") String sitemapname, @PathParam(value="pageid") @Parameter(description="page id") String pageId, @QueryParam(value="subscriptionid") @Parameter(description="subscriptionid") @Nullable String subscriptionId, @QueryParam(value="includeHidden") @Parameter(description="include hidden widgets") boolean includeHiddenWidgets) {
        Locale locale = this.localeService.getLocale(language);
        this.logger.debug("Received HTTP GET request from IP {} at '{}'", (Object)this.request.getRemoteAddr(), (Object)this.uriInfo.getPath());
        if (subscriptionId != null) {
            try {
                this.subscriptions.setPageId(subscriptionId, sitemapname, pageId);
            }
            catch (IllegalArgumentException e) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
            }
        }
        boolean timeout = false;
        if (headers.getRequestHeader("X-Atmosphere-Transport") != null) {
            timeout = this.blockUnlessChangeOccurs(sitemapname, pageId);
        }
        PageDTO responseObject = this.getPageBean(sitemapname, pageId, this.uriInfo.getBaseUriBuilder().build(new Object[0]), locale, timeout, includeHiddenWidgets);
        return Response.ok((Object)responseObject).build();
    }

    @POST
    @Path(value="events/subscribe")
    @Produces(value={"application/json"})
    @Operation(operationId="createSitemapEventSubscription", summary="Creates a sitemap event subscription.", responses={@ApiResponse(responseCode="201", description="Subscription created."), @ApiResponse(responseCode="503", description="Subscriptions limit reached.")})
    public Object createEventSubscription() {
        String subscriptionId = this.subscriptions.createSubscription(this);
        if (subscriptionId == null) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, null, (String)"Max number of subscriptions is reached.");
        }
        SseSinkInfo sinkInfo = new SseSinkInfo(subscriptionId, this.subscriptions);
        this.knownSubscriptions.put(subscriptionId, sinkInfo);
        URI uri = this.uriInfo.getBaseUriBuilder().path(PATH_SITEMAPS).path(SEGMENT_EVENTS).path(subscriptionId).build(new Object[0]);
        this.logger.debug("Client from IP {} requested new subscription => got id {}.", (Object)this.request.getRemoteAddr(), (Object)subscriptionId);
        return JerseyResponseBuilderUtils.created(uri.toASCIIString());
    }

    @GET
    @Path(value="events/{subscriptionid: [a-zA-Z_0-9-]+}")
    @Produces(value={"text/event-stream"})
    @Operation(operationId="getSitemapEvents", summary="Get sitemap events.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Page not linked to the subscription."), @ApiResponse(responseCode="404", description="Subscription not found.")})
    public void getSitemapEvents(@Context SseEventSink sseEventSink, @Context HttpServletResponse response, @PathParam(value="subscriptionid") @Parameter(description="subscription id") String subscriptionId, @QueryParam(value="sitemap") @Parameter(description="sitemap name") @Nullable String sitemapname, @QueryParam(value="pageid") @Parameter(description="page id") @Nullable String pageId) {
        SseSinkInfo sinkInfo = this.knownSubscriptions.get(subscriptionId);
        if (sinkInfo == null) {
            this.logger.debug("Subscription id {} does not exist.", (Object)subscriptionId);
            response.setStatus(Response.Status.NOT_FOUND.getStatusCode());
            return;
        }
        if (sitemapname != null && pageId != null) {
            this.subscriptions.setPageId(subscriptionId, sitemapname, pageId);
        }
        if (this.subscriptions.getSitemapName(subscriptionId) == null || this.subscriptions.getPageId(subscriptionId) == null) {
            this.logger.debug("Subscription id {} is not yet linked to a sitemap/page.", (Object)subscriptionId);
            response.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            return;
        }
        this.logger.debug("Client from IP {} requested sitemap event stream for subscription {}.", (Object)this.request.getRemoteAddr(), (Object)subscriptionId);
        response.addHeader(X_ACCEL_BUFFERING_HEADER, "no");
        this.broadcaster.add(sseEventSink, (Object)sinkInfo);
    }

    private PageDTO getPageBean(String sitemapName, String pageId, URI uri, Locale locale, boolean timeout, boolean includeHidden) {
        Sitemap sitemap = this.getSitemap(sitemapName);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                EList children = this.itemUIRegistry.getChildren(sitemap);
                return this.createPageBean(sitemapName, sitemap.getLabel(), sitemap.getIcon(), sitemap.getName(), (EList<Widget>)children, false, this.isLeaf((EList<Widget>)children), uri, locale, timeout, includeHidden);
            }
            Widget pageWidget = this.itemUIRegistry.getWidget(sitemap, pageId);
            if (pageWidget instanceof LinkableWidget var9_11) {
                EList children = this.itemUIRegistry.getChildren((LinkableWidget)widget);
                PageDTO pageBean = this.createPageBean(sitemapName, this.itemUIRegistry.getLabel(pageWidget), this.itemUIRegistry.getCategory(pageWidget), pageId, (EList<Widget>)children, false, this.isLeaf((EList<Widget>)children), uri, locale, timeout, includeHidden);
                EObject parentPage = pageWidget.eContainer();
                while (parentPage instanceof Frame) {
                    parentPage = parentPage.eContainer();
                }
                if (parentPage instanceof Widget var14_16) {
                    String parentId = this.itemUIRegistry.getWidgetId((Widget)parentPageWidget);
                    pageBean.parent = this.getPageBean(sitemapName, parentId, uri, locale, timeout, includeHidden);
                    pageBean.parent.widgets = null;
                    pageBean.parent.parent = null;
                } else if (parentPage instanceof Sitemap) {
                    pageBean.parent = this.getPageBean(sitemapName, sitemap.getName(), uri, locale, timeout, includeHidden);
                    pageBean.parent.widgets = null;
                }
                return pageBean;
            }
            if (this.logger.isDebugEnabled()) {
                if (pageWidget == null) {
                    this.logger.debug("Received HTTP GET request at '{}' for the unknown page id '{}'.", (Object)uri, (Object)pageId);
                } else {
                    this.logger.debug("Received HTTP GET request at '{}' for the page id '{}'. This id refers to a non-linkable widget and is therefore no valid page id.", (Object)uri, (Object)pageId);
                }
            }
            throw new WebApplicationException(404);
        }
        this.logger.info("Received HTTP GET request at '{}' for the unknown sitemap '{}'.", (Object)uri, (Object)sitemapName);
        throw new WebApplicationException(404);
    }

    public Collection<SitemapDTO> getSitemapBeans(URI uri) {
        LinkedList<SitemapDTO> beans = new LinkedList<SitemapDTO>();
        HashSet<String> names = new HashSet<String>();
        this.logger.debug("Received HTTP GET request at '{}'.", (Object)UriBuilder.fromUri((URI)uri).build(new Object[0]).toASCIIString());
        for (SitemapProvider provider : this.sitemapProviders) {
            for (String modelName : provider.getSitemapNames()) {
                Sitemap sitemap = provider.getSitemap(modelName);
                if (sitemap == null) continue;
                if (!names.contains(modelName)) {
                    names.add(modelName);
                    SitemapDTO bean = new SitemapDTO();
                    bean.name = modelName;
                    bean.icon = sitemap.getIcon();
                    bean.label = sitemap.getLabel();
                    bean.link = UriBuilder.fromUri((URI)uri).path(bean.name).build(new Object[0]).toASCIIString();
                    bean.homepage = new PageDTO();
                    bean.homepage.link = String.valueOf(bean.link) + "/" + sitemap.getName();
                    beans.add(bean);
                    continue;
                }
                this.logger.warn("Found duplicate sitemap name '{}' - ignoring it. Please check your configuration.", (Object)modelName);
            }
        }
        return beans;
    }

    private SitemapDTO getSitemapBean(String sitemapname, URI uri, Locale locale, boolean includeHiddenWidgets) {
        Sitemap sitemap = this.getSitemap(sitemapname);
        if (sitemap != null) {
            return this.createSitemapBean(sitemapname, sitemap, uri, locale, includeHiddenWidgets);
        }
        this.logger.info("Received HTTP GET request at '{}' for the unknown sitemap '{}'.", (Object)this.uriInfo.getPath(), (Object)sitemapname);
        throw new WebApplicationException(404);
    }

    private SitemapDTO createSitemapBean(String sitemapName, Sitemap sitemap, URI uri, Locale locale, boolean includeHiddenWidgets) {
        SitemapDTO bean = new SitemapDTO();
        bean.name = sitemapName;
        bean.icon = sitemap.getIcon();
        bean.label = sitemap.getLabel();
        bean.link = UriBuilder.fromUri((URI)uri).path(PATH_SITEMAPS).path(bean.name).build(new Object[0]).toASCIIString();
        bean.homepage = this.createPageBean(sitemap.getName(), sitemap.getLabel(), sitemap.getIcon(), sitemap.getName(), (EList<Widget>)this.itemUIRegistry.getChildren(sitemap), true, false, uri, locale, false, includeHiddenWidgets);
        return bean;
    }

    private PageDTO createPageBean(String sitemapName, @Nullable String title, @Nullable String icon, String pageId, @Nullable EList<Widget> children, boolean drillDown, boolean isLeaf, URI uri, Locale locale, boolean timeout, boolean includeHiddenWidgets) {
        PageDTO bean = new PageDTO();
        bean.timeout = timeout;
        bean.id = pageId;
        bean.title = title;
        bean.icon = icon;
        bean.leaf = isLeaf;
        bean.link = UriBuilder.fromUri((URI)uri).path(PATH_SITEMAPS).path(sitemapName).path(pageId).build(new Object[0]).toASCIIString();
        if (children != null) {
            for (Widget widget : children) {
                String widgetId;
                WidgetDTO subWidget = this.createWidgetBean(sitemapName, widget, drillDown, uri, widgetId = this.itemUIRegistry.getWidgetId(widget), locale, includeHiddenWidgets);
                if (subWidget == null) continue;
                bean.widgets.add(subWidget);
            }
        } else {
            bean.widgets = null;
        }
        return bean;
    }

    private @Nullable WidgetDTO createWidgetBean(String sitemapName, Widget widget, boolean drillDown, URI uri, String widgetId, Locale locale, boolean evenIfHidden) {
        if (!evenIfHidden && !this.itemUIRegistry.getVisiblity(widget)) {
            return null;
        }
        WidgetDTO bean = new WidgetDTO();
        State itemState = null;
        if (widget.getItem() != null) {
            try {
                Item item = this.itemUIRegistry.getItem(widget.getItem());
                itemState = item.getState();
                String widgetTypeName = widget.eClass().getInstanceTypeName().substring(widget.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
                boolean isMapview = "mapview".equalsIgnoreCase(widgetTypeName);
                Predicate<Item> itemFilter = i -> "Location".equals(i.getType());
                bean.item = EnrichedItemDTOMapper.map((Item)item, (boolean)isMapview, itemFilter, (UriBuilder)UriBuilder.fromUri((URI)uri).path("items/{itemName}"), (Locale)locale);
                bean.state = this.itemUIRegistry.getState(widget).toFullString();
                if (bean.state != null && bean.state.equals(bean.item.state)) {
                    bean.state = null;
                }
            }
            catch (ItemNotFoundException e) {
                this.logger.debug("{}", (Object)e.getMessage());
            }
        }
        bean.widgetId = widgetId;
        bean.icon = this.itemUIRegistry.getCategory(widget);
        bean.staticIcon = widget.getStaticIcon() != null || !widget.getIconRules().isEmpty();
        bean.labelcolor = SitemapResource.convertItemValueColor(this.itemUIRegistry.getLabelColor(widget), itemState);
        bean.valuecolor = SitemapResource.convertItemValueColor(this.itemUIRegistry.getValueColor(widget), itemState);
        bean.iconcolor = SitemapResource.convertItemValueColor(this.itemUIRegistry.getIconColor(widget), itemState);
        bean.label = this.itemUIRegistry.getLabel(widget);
        bean.labelSource = this.itemUIRegistry.getLabelSource(widget).toString();
        bean.pattern = this.itemUIRegistry.getFormatPattern(widget);
        bean.unit = this.itemUIRegistry.getUnitForWidget(widget);
        bean.type = widget.eClass().getName();
        bean.visibility = this.itemUIRegistry.getVisiblity(widget);
        if (widget instanceof LinkableWidget e) {
            EList children = this.itemUIRegistry.getChildren((LinkableWidget)linkableWidget);
            if (widget instanceof Frame) {
                for (Widget child : children) {
                    WidgetDTO subWidget = this.createWidgetBean(sitemapName, child, drillDown, uri, (String)(wID = this.itemUIRegistry.getWidgetId(child)), locale, evenIfHidden);
                    if (subWidget == null) continue;
                    bean.widgets.add(subWidget);
                }
            } else if (!children.isEmpty()) {
                String pageName = this.itemUIRegistry.getWidgetId((Widget)linkableWidget);
                bean.linkedPage = this.createPageBean(sitemapName, this.itemUIRegistry.getLabel(widget), this.itemUIRegistry.getCategory(widget), pageName, (EList<Widget>)(drillDown ? children : null), drillDown, this.isLeaf((EList<Widget>)children), uri, locale, false, evenIfHidden);
            }
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Switch children) {
            for (Selection mapping : switchWidget.getMappings()) {
                MappingDTO mappingBean = new MappingDTO();
                mappingBean.command = mapping.getCmd();
                mappingBean.label = mapping.getLabel();
                mappingBean.icon = mapping.getIcon();
                bean.mappings.add(mappingBean);
            }
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Selection mapping) {
            for (Input mapping : selectionWidget.getMappings()) {
                mappingBean = new MappingDTO();
                mappingBean.command = mapping.getCmd();
                mappingBean.label = mapping.getLabel();
                bean.mappings.add((MappingDTO)mappingBean);
            }
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Input mapping) {
            bean.inputHint = inputWidget.getInputHint();
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Slider && (mappingBean = (Slider) instanceOfPatternExpressionValue) == (Slider) instanceOfPatternExpressionValue) {
            bean.sendFrequency = sliderWidget.getFrequency();
            bean.switchSupport = sliderWidget.isSwitchEnabled();
            bean.minValue = sliderWidget.getMinValue();
            bean.maxValue = sliderWidget.getMaxValue();
            bean.step = sliderWidget.getStep();
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Image var20_24) {
            bean.url = this.buildProxyUrl(sitemapName, widget, uri);
            if (imageWidget.getRefresh() > 0) {
                bean.refresh = imageWidget.getRefresh();
            }
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Video var22_26) {
            if (videoWidget.getEncoding() != null) {
                bean.encoding = videoWidget.getEncoding();
            }
            bean.url = videoWidget.getEncoding() != null && videoWidget.getEncoding().toLowerCase().contains("hls") ? videoWidget.getUrl() : this.buildProxyUrl(sitemapName, (Widget)videoWidget, uri);
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Webview var24_28) {
            bean.url = webViewWidget.getUrl();
            bean.height = webViewWidget.getHeight();
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Mapview var26_30) {
            bean.height = mapViewWidget.getHeight();
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Chart var28_32) {
            bean.service = chartWidget.getService();
            bean.period = chartWidget.getPeriod();
            bean.legend = chartWidget.getLegend();
            bean.forceAsItem = chartWidget.getForceAsItem();
            bean.yAxisDecimalPattern = chartWidget.getYAxisDecimalPattern();
            if (chartWidget.getRefresh() > 0) {
                bean.refresh = chartWidget.getRefresh();
            }
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Setpoint var30_34) {
            bean.minValue = setpointWidget.getMinValue();
            bean.maxValue = setpointWidget.getMaxValue();
            bean.step = setpointWidget.getStep();
        }
        if (( instanceOfPatternExpressionValue = widget) instanceof Buttongrid var32_36) {
            for (Button button : buttonGridWidget.getButtons()) {
                MappingDTO mappingBean = new MappingDTO();
                mappingBean.row = button.getRow();
                mappingBean.column = button.getColumn();
                mappingBean.command = button.getCmd();
                mappingBean.label = button.getLabel();
                mappingBean.icon = button.getIcon();
                bean.mappings.add(mappingBean);
            }
        }
        return bean;
    }

    /*
     * WARNING - void declaration
     */
    public static @Nullable String convertItemValueColor(@Nullable String color, @Nullable State itemState) {
        if ("itemValue".equals(color)) {
            void var3_2;
            HSBType hSBType;
            State state = itemState;
            if (state instanceof HSBType && (hSBType = (HSBType)state) == (HSBType)var3_2) {
                void hsbState;
                return "#" + Integer.toHexString(hsbState.getRGB()).substring(2);
            }
            return null;
        }
        return color;
    }

    private String buildProxyUrl(String sitemapName, Widget widget, URI uri) {
        String wId = this.itemUIRegistry.getWidgetId(widget);
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme()).append("://").append(uri.getHost());
        if (uri.getPort() >= 0) {
            sb.append(":").append(uri.getPort());
        }
        sb.append("/proxy?sitemap=").append(sitemapName).append("&widgetId=").append(wId);
        return sb.toString();
    }

    private boolean isLeaf(EList<Widget> children) {
        for (Widget w : children) {
            if (!(w instanceof Frame var4_4 ? this.isLeaf((EList<Widget>)frame.getChildren()) : ( instanceOfPatternExpressionValue = w) instanceof LinkableWidget && (var6_6 = (LinkableWidget) instanceOfPatternExpressionValue) == (LinkableWidget) instanceOfPatternExpressionValue && !this.itemUIRegistry.getChildren((LinkableWidget)linkableWidget).isEmpty())) continue;
            return false;
        }
        return true;
    }

    private @Nullable Sitemap getSitemap(String sitemapname) {
        for (SitemapProvider provider : this.sitemapProviders) {
            Sitemap sitemap = provider.getSitemap(sitemapname);
            if (sitemap == null) continue;
            return sitemap;
        }
        return null;
    }

    private boolean blockUnlessChangeOccurs(String sitemapname, String pageId) {
        boolean timeout = false;
        Sitemap sitemap = this.getSitemap(sitemapname);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                EList children = this.itemUIRegistry.getChildren(sitemap);
                timeout = this.waitForChanges((EList<Widget>)children);
            } else {
                Widget pageWidget = this.itemUIRegistry.getWidget(sitemap, pageId);
                if (pageWidget instanceof LinkableWidget var6_8) {
                    EList children = this.itemUIRegistry.getChildren((LinkableWidget)widget);
                    timeout = this.waitForChanges((EList<Widget>)children);
                }
            }
        }
        return timeout;
    }

    private boolean waitForChanges(EList<Widget> widgets) {
        long startTime = new Date().getTime();
        boolean timeout = false;
        Set<String> items = this.getAllItems(widgets).stream().map(Item::getName).collect(Collectors.toSet());
        BlockingStateChangeListener listener = new BlockingStateChangeListener(items);
        this.stateChangeListeners.add(listener);
        while (!listener.hasChanged() && !timeout) {
            timeout = new Date().getTime() - startTime > 30000L;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                timeout = true;
                break;
            }
        }
        this.stateChangeListeners.remove(listener);
        return timeout;
    }

    private Set<GenericItem> getAllItems(EList<Widget> widgets) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (Widget widget : widgets) {
            boolean skipWidget = false;
            if (widget instanceof Chart var6_6) {
                skipWidget = chartWidget.getRefresh() > 0;
            }
            String itemName = widget.getItem();
            if (!skipWidget && itemName != null) {
                try {
                    Item item = item = this.itemUIRegistry.getItem(itemName);
                    if (item instanceof GenericItem var10_11) {
                        items.add((GenericItem)genericItem);
                    }
                }
                catch (ItemNotFoundException item) {
                    // empty catch block
                }
            }
            if (( instanceOfPatternExpressionValue = widget) instanceof Frame && (item = (Frame) instanceOfPatternExpressionValue) == (Frame) instanceOfPatternExpressionValue) {
                items.addAll(this.getAllItems((EList<Widget>)frame.getChildren()));
            }
            items.addAll(this.getItemsInIconCond((EList<IconRule>)widget.getIconRules()));
            items.addAll(this.getItemsInVisibilityCond((EList<VisibilityRule>)widget.getVisibility()));
            items.addAll(this.getItemsInColorCond((EList<ColorArray>)widget.getLabelColor()));
            items.addAll(this.getItemsInColorCond((EList<ColorArray>)widget.getValueColor()));
            items.addAll(this.getItemsInColorCond((EList<ColorArray>)widget.getIconColor()));
        }
        return items;
    }

    private Set<GenericItem> getItemsInVisibilityCond(EList<VisibilityRule> ruleList) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (VisibilityRule rule : ruleList) {
            this.getItemsInConditions((EList<Condition>)rule.getConditions(), items);
        }
        return items;
    }

    private Set<GenericItem> getItemsInColorCond(EList<ColorArray> colorList) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (ColorArray rule : colorList) {
            this.getItemsInConditions((EList<Condition>)rule.getConditions(), items);
        }
        return items;
    }

    private Set<GenericItem> getItemsInIconCond(EList<IconRule> ruleList) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (IconRule rule : ruleList) {
            this.getItemsInConditions((EList<Condition>)rule.getConditions(), items);
        }
        return items;
    }

    /*
     * WARNING - void declaration
     */
    private void getItemsInConditions(@Nullable EList<Condition> conditions, Set<GenericItem> items) {
        if (conditions != null) {
            for (Condition condition : conditions) {
                String itemName = condition.getItem();
                if (itemName == null) continue;
                try {
                    void genericItem;
                    Item item;
                    Item item2 = item = this.itemUIRegistry.getItem(itemName);
                    if (!(item2 instanceof GenericItem var7_8)) continue;
                    items.add((GenericItem)genericItem);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of(ItemStateChangedEvent.TYPE);
    }

    /*
     * WARNING - void declaration
     */
    public void receive(Event event) {
        void var3_2;
        ItemEvent itemEvent;
        Event event2 = event;
        if (event2 instanceof ItemEvent && (itemEvent = (ItemEvent)event2) == (ItemEvent)var3_2) {
            void itemEvent2;
            String itemName = itemEvent2.getItemName();
            this.stateChangeListeners.forEach(l -> l.itemChanged(itemName));
        }
    }

    @Override
    public void onEvent(SitemapEvent event) {
        Sse sse = this.sse;
        if (sse == null) {
            this.logger.trace("broadcast skipped (no one listened since activation)");
            return;
        }
        OutboundSseEvent outboundSseEvent = sse.newEventBuilder().name("event").mediaType(MediaType.APPLICATION_JSON_TYPE).data((Object)event).build();
        this.broadcaster.sendIf(outboundSseEvent, info -> {
            String sitemapName = sitemapEvent.sitemapName;
            String pageId = sitemapEvent.pageId;
            if (sitemapName != null && sitemapName.equals(this.subscriptions.getSitemapName(info.subscriptionId)) && pageId != null && pageId.equals(this.subscriptions.getPageId(info.subscriptionId))) {
                if (this.logger.isDebugEnabled()) {
                    if (event instanceof SitemapWidgetEvent var5_6) {
                        this.logger.debug("Sent sitemap event for widget {} to subscription {}.", (Object)widgetEvent.widgetId, (Object)info.subscriptionId);
                    } else if (event instanceof ServerAliveEvent) {
                        this.logger.debug("Sent alive event to subscription {}.", (Object)info.subscriptionId);
                    }
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public void onRelease(String subscriptionId) {
        this.logger.debug("SSE connection for subscription {} has been released.", (Object)subscriptionId);
        this.broadcaster.closeAndRemoveIf(info -> info.subscriptionId.equals(subscriptionId));
        this.knownSubscriptions.remove(subscriptionId);
    }

    public void sseEventSinkRemoved(SseEventSink sink, SseSinkInfo info) {
        this.logger.debug("SSE connection for subscription {} has been closed.", (Object)info.subscriptionId);
        this.subscriptions.removeSubscription(info.subscriptionId);
        this.knownSubscriptions.remove(info.subscriptionId);
    }

    private static class BlockingStateChangeListener {
        private final Set<String> items;
        private boolean changed = false;

        public BlockingStateChangeListener(Set<String> items) {
            this.items = items;
        }

        public void itemChanged(String item) {
            if (this.items.contains(item)) {
                this.changed = true;
            }
        }

        public boolean hasChanged() {
            return this.changed;
        }
    }
}

