/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.sitemap;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.io.rest.sitemap.internal.PageChangeListener;
import org.openhab.core.io.rest.sitemap.internal.SitemapEvent;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.events.ItemStatePredictedEvent;
import org.openhab.core.model.core.EventType;
import org.openhab.core.model.core.ModelRepositoryChangeListener;
import org.openhab.core.model.sitemap.SitemapProvider;
import org.openhab.core.model.sitemap.sitemap.LinkableWidget;
import org.openhab.core.model.sitemap.sitemap.Sitemap;
import org.openhab.core.model.sitemap.sitemap.Widget;
import org.openhab.core.thing.events.ChannelDescriptionChangedEvent;
import org.openhab.core.ui.items.ItemUIRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SitemapSubscriptionService.class, EventSubscriber.class}, configurationPid={"org.openhab.sitemapsubscription"})
@NonNullByDefault
public class SitemapSubscriptionService
implements ModelRepositoryChangeListener,
EventSubscriber {
    private static final String SITEMAP_PAGE_SEPARATOR = "#";
    private static final String SITEMAP_SUFFIX = ".sitemap";
    private static final int DEFAULT_MAX_SUBSCRIPTIONS = 50;
    private final Logger logger = LoggerFactory.getLogger(SitemapSubscriptionService.class);
    private final BundleContext bundleContext;
    private final ItemUIRegistry itemUIRegistry;
    private final List<SitemapProvider> sitemapProviders = new ArrayList<SitemapProvider>();
    private final Map<String, String> pageOfSubscription = new ConcurrentHashMap<String, String>();
    private final Map<String, SitemapSubscriptionCallback> callbacks = new ConcurrentHashMap<String, SitemapSubscriptionCallback>();
    private final Map<String, Instant> creationInstants = new ConcurrentHashMap<String, Instant>();
    private final Map<String, ListenerRecord> pageChangeListeners = new ConcurrentHashMap<String, ListenerRecord>();
    private int maxSubscriptions = 50;

    @Activate
    public SitemapSubscriptionService(Map<String, Object> config, @Reference ItemUIRegistry itemUIRegistry, BundleContext bundleContext) {
        this.itemUIRegistry = itemUIRegistry;
        this.bundleContext = bundleContext;
        this.applyConfig(config);
    }

    @Deactivate
    protected void deactivate() {
        this.pageOfSubscription.clear();
        this.callbacks.clear();
        this.creationInstants.clear();
        this.pageChangeListeners.values().forEach(l -> l.serviceRegistration.unregister());
        this.pageChangeListeners.clear();
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        this.applyConfig(config);
    }

    private void applyConfig(Map<String, Object> config) {
        if (config == null) {
            return;
        }
        String max = Objects.toString(config.get("maxSubscriptions"), null);
        if (max != null) {
            try {
                this.maxSubscriptions = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                this.logger.debug("Setting 'maxSubscriptions' must be a number; value '{}' ignored.", (Object)max);
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.add(provider);
        provider.addModelChangeListener((ModelRepositoryChangeListener)this);
    }

    protected void removeSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.remove(provider);
        provider.removeModelChangeListener((ModelRepositoryChangeListener)this);
    }

    public @Nullable String createSubscription(SitemapSubscriptionCallback callback) {
        if (this.maxSubscriptions >= 0 && this.callbacks.size() >= this.maxSubscriptions) {
            this.logger.debug("No new subscription delivered as limit ({}) is already reached", (Object)this.maxSubscriptions);
            return null;
        }
        String subscriptionId = UUID.randomUUID().toString();
        this.callbacks.put(subscriptionId, callback);
        this.creationInstants.put(subscriptionId, Instant.now());
        this.logger.debug("Created new subscription with id {} ({} active subscriptions for a max of {})", new Object[]{subscriptionId, this.callbacks.size(), this.maxSubscriptions});
        return subscriptionId;
    }

    public void removeSubscription(String subscriptionId) {
        ListenerRecord listener;
        this.creationInstants.remove(subscriptionId);
        this.callbacks.remove(subscriptionId);
        String sitemapPage = this.pageOfSubscription.remove(subscriptionId);
        if (sitemapPage != null && !this.pageOfSubscription.values().contains(sitemapPage) && (listener = this.pageChangeListeners.remove(sitemapPage)) != null) {
            listener.serviceRegistration().unregister();
        }
        this.logger.debug("Removed subscription with id {} ({} active subscriptions)", (Object)subscriptionId, (Object)this.callbacks.size());
    }

    public boolean exists(String subscriptionId) {
        return this.callbacks.containsKey(subscriptionId);
    }

    public @Nullable String getPageId(String subscriptionId) {
        String sitemapWithPageId = this.pageOfSubscription.get(subscriptionId);
        return sitemapWithPageId == null ? null : this.extractPageId(sitemapWithPageId);
    }

    public @Nullable String getSitemapName(String subscriptionId) {
        String sitemapWithPageId = this.pageOfSubscription.get(subscriptionId);
        return sitemapWithPageId == null ? null : this.extractSitemapName(sitemapWithPageId);
    }

    private String extractSitemapName(String sitemapWithPageId) {
        return sitemapWithPageId.split(SITEMAP_PAGE_SEPARATOR)[0];
    }

    private String extractPageId(String sitemapWithPageId) {
        return sitemapWithPageId.split(SITEMAP_PAGE_SEPARATOR)[1];
    }

    public void setPageId(String subscriptionId, String sitemapName, String pageId) {
        SitemapSubscriptionCallback callback = this.callbacks.get(subscriptionId);
        if (callback != null) {
            String oldSitemapPage = this.pageOfSubscription.remove(subscriptionId);
            if (oldSitemapPage != null) {
                this.removeCallbackFromListener(oldSitemapPage, callback);
            }
        } else {
            throw new IllegalArgumentException("Subscription " + subscriptionId + " does not exist!");
        }
        this.addCallbackToListener(sitemapName, pageId, callback);
        this.pageOfSubscription.put(subscriptionId, this.getValue(sitemapName, pageId));
        this.logger.debug("Subscription {} changed to page {} of sitemap {} ({} active subscriptions}", new Object[]{subscriptionId, pageId, sitemapName, this.callbacks.size()});
    }

    private void addCallbackToListener(String sitemapName, String pageId, SitemapSubscriptionCallback callback) {
        ListenerRecord listener = this.pageChangeListeners.computeIfAbsent(this.getValue(sitemapName, pageId), v -> {
            PageChangeListener newListener = new PageChangeListener(sitemapName, pageId, this.itemUIRegistry, this.collectWidgets(sitemapName, pageId));
            ServiceRegistration registration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)newListener, null);
            return new ListenerRecord(newListener, registration);
        });
        listener.pageChangeListener().addCallback(callback);
    }

    private EList<Widget> collectWidgets(String sitemapName, String pageId) {
        BasicEList widgets = new BasicEList();
        Sitemap sitemap = this.getSitemap(sitemapName);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                widgets = this.itemUIRegistry.getChildren(sitemap);
            } else {
                Widget pageWidget = this.itemUIRegistry.getWidget(sitemap, pageId);
                if (pageWidget instanceof LinkableWidget var6_7) {
                    widgets = this.itemUIRegistry.getChildren((LinkableWidget)widget);
                    widgets.add((Object)pageWidget);
                }
            }
        }
        return widgets;
    }

    private void removeCallbackFromListener(String sitemapPage, SitemapSubscriptionCallback callback) {
        ListenerRecord oldListener = this.pageChangeListeners.get(sitemapPage);
        if (oldListener != null) {
            oldListener.pageChangeListener().removeCallback(callback);
            if (!this.pageOfSubscription.containsValue(sitemapPage)) {
                oldListener.serviceRegistration().unregister();
                this.pageChangeListeners.remove(sitemapPage);
            }
        }
    }

    private String getValue(String sitemapName, String pageId) {
        return String.valueOf(sitemapName) + SITEMAP_PAGE_SEPARATOR + pageId;
    }

    private @Nullable Sitemap getSitemap(String sitemapName) {
        for (SitemapProvider provider : this.sitemapProviders) {
            Sitemap sitemap = provider.getSitemap(sitemapName);
            if (sitemap == null) continue;
            return sitemap;
        }
        return null;
    }

    public void modelChanged(String modelName, EventType type) {
        if (type != EventType.MODIFIED || !modelName.endsWith(SITEMAP_SUFFIX)) {
            return;
        }
        String changedSitemapName = modelName.substring(0, modelName.length() - SITEMAP_SUFFIX.length());
        for (Map.Entry<String, ListenerRecord> listenerEntry : this.pageChangeListeners.entrySet()) {
            String sitemapWithPage = listenerEntry.getKey();
            String sitemapName = this.extractSitemapName(sitemapWithPage);
            String pageId = this.extractPageId(sitemapWithPage);
            if (!sitemapName.equals(changedSitemapName)) continue;
            EList<Widget> widgets = this.collectWidgets(sitemapName, pageId);
            listenerEntry.getValue().pageChangeListener().sitemapContentChanged(widgets);
        }
    }

    public void checkAliveClients() {
        for (Map.Entry<String, Instant> creationEntry : this.creationInstants.entrySet()) {
            String subscriptionId = creationEntry.getKey();
            SitemapSubscriptionCallback callback = this.callbacks.get(subscriptionId);
            if (this.getPageId(subscriptionId) != null || callback == null || !creationEntry.getValue().plus(Duration.ofSeconds(30L)).isBefore(Instant.now())) continue;
            this.logger.debug("Release subscription {} as sitemap page is not set", (Object)subscriptionId);
            this.removeSubscription(subscriptionId);
            callback.onRelease(subscriptionId);
        }
        this.pageChangeListeners.values().forEach(l -> l.pageChangeListener().sendAliveEvent());
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of(ItemStatePredictedEvent.TYPE, ChannelDescriptionChangedEvent.TYPE);
    }

    public void receive(Event event) {
        Event event2 = event;
        if (event2 instanceof ItemStatePredictedEvent && (var2_3 = (ItemStatePredictedEvent)event2) == (ItemStatePredictedEvent)var3_2) {
            Item item = (Item)this.itemUIRegistry.get((Object)prediction.getItemName());
            if (item instanceof GroupItem) {
                return;
            }
            for (ListenerRecord listener : this.pageChangeListeners.values()) {
                if (prediction.isConfirmation()) {
                    listener.pageChangeListener().keepCurrentState(item);
                    continue;
                }
                listener.pageChangeListener().changeStateTo(item, prediction.getPredictedState());
            }
        } else {
            if (event instanceof ChannelDescriptionChangedEvent item) {
                channelDescriptionChangedEvent.getLinkedItemNames().forEach(itemName -> {
                    for (ListenerRecord listener : this.pageChangeListeners.values()) {
                        listener.pageChangeListener().descriptionChanged((String)itemName);
                    }
                });
            }
        }
    }

    private record ListenerRecord(PageChangeListener pageChangeListener, ServiceRegistration<?> serviceRegistration) {
    }

    public static interface SitemapSubscriptionCallback {
        public void onEvent(SitemapEvent var1);

        public void onRelease(String var1);
    }
}

