/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal.javasound;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.TargetDataLine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.internal.javasound.JavaSoundInputStream;
import org.openhab.core.common.ThreadPoolManager;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AudioSource.class}, immediate=true)
public class JavaSoundAudioSource
implements AudioSource {
    private final Logger logger = LoggerFactory.getLogger(JavaSoundAudioSource.class);
    private final javax.sound.sampled.AudioFormat format = new javax.sound.sampled.AudioFormat(16000.0f, 16, 1, true, false);
    private final AudioFormat audioFormat = JavaSoundAudioSource.convertAudioFormat(this.format);
    private final boolean windowsOS = System.getProperty("os.name", "Unknown").startsWith("Win");
    private @Nullable TargetDataLine microphone;
    private final ConcurrentLinkedQueue<PipedOutputStream> openStreamRefs = new ConcurrentLinkedQueue();
    private @Nullable Future<?> pipeWriteTask;
    private final ScheduledExecutorService executor = ThreadPoolManager.getScheduledPool((String)"OH-core-javasound-source");

    private TargetDataLine initMicrophone(javax.sound.sampled.AudioFormat format) throws AudioException {
        try {
            TargetDataLine microphone = AudioSystem.getTargetDataLine(format);
            microphone.open(format);
            return microphone;
        }
        catch (Exception e) {
            throw new AudioException("Error creating the audio input stream: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioStream getInputStream(AudioFormat expectedFormat) throws AudioException {
        if (!expectedFormat.isCompatible(this.audioFormat)) {
            throw new AudioException("Cannot produce streams in format " + expectedFormat);
        }
        if (!this.windowsOS) {
            final TargetDataLine microphone = this.initMicrophone(this.format);
            JavaSoundInputStream inputStream = new JavaSoundInputStream(new InputStream(){

                @Override
                public int read() throws IOException {
                    return microphone.available();
                }

                @Override
                public int read(byte @Nullable [] b, int off, int len) throws IOException {
                    return microphone.read(b, off, len);
                }

                @Override
                public void close() throws IOException {
                    microphone.close();
                }
            }, this.audioFormat);
            microphone.start();
            return inputStream;
        }
        ConcurrentLinkedQueue<PipedOutputStream> concurrentLinkedQueue = this.openStreamRefs;
        synchronized (concurrentLinkedQueue) {
            PipedInputStream pipedInputStream;
            TargetDataLine microphone = this.microphone;
            if (microphone == null) {
                this.microphone = microphone = this.initMicrophone(this.format);
            }
            final PipedOutputStream pipedOutputStream = new PipedOutputStream();
            try {
                pipedInputStream = new PipedInputStream(pipedOutputStream, 10240){

                    @Override
                    public void close() throws IOException {
                        JavaSoundAudioSource.this.unregisterPipe(pipedOutputStream);
                        super.close();
                    }
                };
            }
            catch (IOException ie) {
                throw new AudioException("Cannot open stream pipe: " + ie.getMessage());
            }
            this.openStreamRefs.add(pipedOutputStream);
            JavaSoundInputStream inputStream = new JavaSoundInputStream(pipedInputStream, this.audioFormat);
            microphone.start();
            this.startPipeWrite();
            return inputStream;
        }
    }

    private void startPipeWrite() {
        if (this.pipeWriteTask == null) {
            this.pipeWriteTask = this.executor.submit(() -> {
                byte[] buffer = new byte[1024];
                while (!this.openStreamRefs.isEmpty()) {
                    TargetDataLine stream = this.microphone;
                    if (stream != null) {
                        try {
                            int lengthRead = stream.read(buffer, 0, buffer.length);
                            for (PipedOutputStream output : this.openStreamRefs) {
                                try {
                                    output.write(buffer, 0, lengthRead);
                                    if (!this.openStreamRefs.contains(output)) continue;
                                    output.flush();
                                }
                                catch (InterruptedIOException e) {
                                    if (this.openStreamRefs.isEmpty()) {
                                        return;
                                    }
                                    this.logger.warn("InterruptedIOException while writing to source pipe: {}", (Object)e.getMessage());
                                }
                                catch (IOException e) {
                                    this.logger.warn("IOException while writing to source pipe: {}", (Object)e.getMessage());
                                }
                                catch (RuntimeException e) {
                                    this.logger.warn("RuntimeException while writing to source pipe: {}", (Object)e.getMessage());
                                }
                            }
                        }
                        catch (RuntimeException e) {
                            this.logger.warn("RuntimeException while reading from JavaSound source: {}", (Object)e.getMessage());
                        }
                        continue;
                    }
                    this.logger.warn("Unable access to microphone stream");
                }
                this.pipeWriteTask = null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterPipe(PipedOutputStream pipedOutputStream) {
        ConcurrentLinkedQueue<PipedOutputStream> concurrentLinkedQueue = this.openStreamRefs;
        synchronized (concurrentLinkedQueue) {
            this.openStreamRefs.remove(pipedOutputStream);
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.openStreamRefs.isEmpty()) {
                TargetDataLine microphone;
                Future<?> pipeWriteTask = this.pipeWriteTask;
                if (pipeWriteTask != null) {
                    pipeWriteTask.cancel(true);
                    this.pipeWriteTask = null;
                }
                if ((microphone = this.microphone) != null) {
                    microphone.close();
                    this.microphone = null;
                }
            }
            try {
                pipedOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "javasound";
    }

    private static AudioFormat convertAudioFormat(javax.sound.sampled.AudioFormat audioFormat) {
        String container = "WAVE";
        String codec = audioFormat.getEncoding().toString();
        Boolean bigEndian = audioFormat.isBigEndian();
        int frameSize = audioFormat.getFrameSize();
        int bitsPerFrame = frameSize * 8;
        Integer bitDepth = -1 == frameSize ? null : Integer.valueOf(bitsPerFrame);
        float frameRate = audioFormat.getFrameRate();
        Integer bitRate = -1.0f == frameRate ? null : Integer.valueOf((int)(frameRate * (float)bitsPerFrame));
        float sampleRate = audioFormat.getSampleRate();
        Long frequency = -1.0f == sampleRate ? null : Long.valueOf((long)sampleRate);
        return new AudioFormat(container, codec, bigEndian, bitDepth, bitRate, frequency);
    }

    @Override
    public String getId() {
        return "javasound";
    }

    @Override
    public String getLabel(@Nullable Locale locale) {
        return "System Microphone";
    }

    @Override
    public Set<AudioFormat> getSupportedFormats() {
        return Set.of(this.audioFormat);
    }
}

