/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal.javasound;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.utils.AudioWaveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class AudioPlayer
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(AudioPlayer.class);
    private final AudioStream audioStream;

    public AudioPlayer(AudioStream audioStream) {
        this.audioStream = audioStream;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block18: {
            openhabAudioFormat = this.audioStream.getFormat();
            audioFormat = this.convertAudioFormat(openhabAudioFormat);
            if (audioFormat == null) {
                this.logger.warn("Audio format is unsupported or does not have enough details in order to be played");
                return;
            }
            info = new DataLine.Info(SourceDataLine.class, audioFormat);
            try {
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(audioFormat);
                break block18;
            }
            catch (Exception e) {
                this.logger.warn("No line found: {}", (Object)e.getMessage());
                this.logger.info("Available lines are:");
                mixerInfo = AudioSystem.getMixerInfo();
                mixer = null;
                cnt = 0;
                ** while (cnt < mixerInfo.length)
            }
lbl-1000:
            // 1 sources

            {
                mixer = AudioSystem.getMixer(mixerInfo[cnt]);
                var13_20 = lineInfos = mixer.getSourceLineInfo();
                var12_19 = lineInfos.length;
                var11_18 = 0;
                while (var11_18 < var12_19) {
                    lineInfo = var13_20[var11_18];
                    this.logger.info("{}", (Object)lineInfo);
                    ++var11_18;
                }
                ++cnt;
                continue;
            }
lbl29:
            // 1 sources

            return;
        }
        line.start();
        nRead = 0;
        abData = new byte[65532];
        try {
            try {
                if ("WAVE".equals(openhabAudioFormat.getContainer())) {
                    AudioWaveUtils.removeFMT(this.audioStream);
                }
                while (-1 != nRead) {
                    nRead = this.audioStream.read(abData, 0, abData.length);
                    if (nRead < 0) continue;
                    line.write(abData, 0, nRead);
                }
            }
            catch (IOException e) {
                this.logger.error("Error while playing audio: {}", (Object)e.getMessage());
                line.drain();
                line.close();
                try {
                    this.audioStream.close();
                }
                catch (IOException var9_14) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            line.drain();
            line.close();
            try {
                this.audioStream.close();
            }
            catch (IOException var9_16) {}
        }
    }

    protected @Nullable javax.sound.sampled.AudioFormat convertAudioFormat(AudioFormat audioFormat) {
        String codec = audioFormat.getCodec();
        AudioFormat.Encoding encoding = new AudioFormat.Encoding(codec);
        if ("PCM_SIGNED".equals(codec)) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if ("ULAW".equals(codec)) {
            encoding = AudioFormat.Encoding.ULAW;
        } else if ("ALAW".equals(codec)) {
            encoding = AudioFormat.Encoding.ALAW;
        }
        Long frequency = audioFormat.getFrequency();
        if (frequency == null) {
            return null;
        }
        float sampleRate = frequency.floatValue();
        Integer bitDepth = audioFormat.getBitDepth();
        if (bitDepth == null) {
            return null;
        }
        int sampleSizeInBits = bitDepth;
        int channels = audioFormat.getChannels() == null ? Integer.valueOf(1) : audioFormat.getChannels();
        int frameSize = channels * sampleSizeInBits / 8;
        float frameRate = (float)channels * sampleRate / (float)frameSize;
        Boolean bigEndian = audioFormat.isBigEndian();
        if (bigEndian == null) {
            return null;
        }
        return new javax.sound.sampled.AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
    }
}

