/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioSource;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.extensions.AbstractConsoleCommandExtension;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.library.types.PercentType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConsoleCommandExtension.class})
@NonNullByDefault
public class AudioConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    static final String SUBCMD_PLAY = "play";
    static final String SUBCMD_STREAM = "stream";
    static final String SUBCMD_SYNTHESIZE = "synthesize";
    static final String SUBCMD_SOURCES = "sources";
    static final String SUBCMD_SINKS = "sinks";
    private final AudioManager audioManager;
    private final LocaleProvider localeProvider;

    @Activate
    public AudioConsoleCommandExtension(@Reference AudioManager audioManager, @Reference LocaleProvider localeProvider) {
        super("audio", "Commands around audio enablement features.");
        this.audioManager = audioManager;
        this.localeProvider = localeProvider;
    }

    public List<String> getUsages() {
        return List.of(this.buildCommandUsage("play [<sink>] <filename>", "plays a sound file from the sounds folder through the optionally specified audio sink(s)"), this.buildCommandUsage("play <sink> <filename> <volume>", "plays a sound file from the sounds folder through the specified audio sink(s) with the specified volume"), this.buildCommandUsage("stream [<sink>] <url>", "streams the sound from the url through the optionally specified audio sink(s)"), this.buildCommandUsage("synthesize [<sink>] \"<melody>\"", "synthesize a tone melody and play it through the optionally specified audio sink(s) (synthesize \"A O A O A\")"), this.buildCommandUsage("synthesize <sink> \"<melody>\" <volume>", "synthesize a tone melody and play it through the optionally specified audio sink(s) with the specified volume"), this.buildCommandUsage(SUBCMD_SOURCES, "lists the audio sources"), this.buildCommandUsage(SUBCMD_SINKS, "lists the audio sinks"));
    }

    public void execute(String[] args, Console console) {
        block27: {
            block25: {
                String subCommand;
                if (args.length <= 0) break block25;
                switch (subCommand = args[0]) {
                    case "play": {
                        if (args.length > 1) {
                            this.play(Arrays.copyOfRange(args, 1, args.length), console);
                        } else {
                            console.println("Specify file to play, and optionally the sink(s) to use (e.g. 'play javasound hello.mp3')");
                        }
                        return;
                    }
                    case "stream": {
                        if (args.length > 1) {
                            this.stream(Arrays.copyOfRange(args, 1, args.length), console);
                        } else {
                            console.println("Specify url to stream from, and optionally the sink(s) to use");
                        }
                        return;
                    }
                    case "synthesize": {
                        if (args.length > 1) {
                            this.synthesizeMelody(Arrays.copyOfRange(args, 1, args.length), console);
                        } else {
                            console.println("Specify file to play, and optionally the sink(s) to use (e.g. 'play javasound A B C:1000')");
                        }
                        return;
                    }
                    case "sources": {
                        this.listSources(console);
                        return;
                    }
                    case "sinks": {
                        this.listSinks(console);
                        return;
                    }
                }
                break block27;
            }
            this.printUsage(console);
        }
    }

    private void listSources(Console console) {
        Set<AudioSource> sources = this.audioManager.getAllSources();
        if (!sources.isEmpty()) {
            AudioSource defaultSource = this.audioManager.getSource();
            Locale locale = this.localeProvider.getLocale();
            sources.stream().sorted(Comparator.comparing(s -> s.getLabel(locale))).forEach(source -> console.println(String.format("%s %s (%s)", source.equals(defaultSource) ? "*" : " ", source.getLabel(locale), source.getId())));
        } else {
            console.println("No audio sources found.");
        }
    }

    private void listSinks(Console console) {
        Set<AudioSink> sinks = this.audioManager.getAllSinks();
        if (!sinks.isEmpty()) {
            AudioSink defaultSink = this.audioManager.getSink();
            Locale locale = this.localeProvider.getLocale();
            sinks.stream().sorted(Comparator.comparing(s -> s.getLabel(locale))).forEach(sink -> console.println(String.format("%s %s (%s)", sink.equals(defaultSink) ? "*" : " ", sink.getLabel(locale), sink.getId())));
        } else {
            console.println("No audio sinks found.");
        }
    }

    private void play(String[] args, Console console) {
        switch (args.length) {
            case 1: {
                this.playOnSink(null, args[0], null, console);
                break;
            }
            case 2: {
                this.playOnSinks(args[0], args[1], null, console);
                break;
            }
            case 3: {
                PercentType volume = null;
                try {
                    volume = PercentType.valueOf((String)args[2]);
                }
                catch (Exception e) {
                    console.println("Specify volume as percentage between 0 and 100");
                    break;
                }
                this.playOnSinks(args[0], args[1], volume, console);
                break;
            }
        }
    }

    private void synthesizeMelody(String[] args, Console console) {
        switch (args.length) {
            case 1: {
                this.playMelodyOnSink(null, args[0], null, console);
                break;
            }
            case 2: {
                this.playMelodyOnSinks(args[0], args[1], null, console);
                break;
            }
            case 3: {
                PercentType volume = null;
                try {
                    volume = PercentType.valueOf((String)args[2]);
                }
                catch (Exception e) {
                    console.println("Specify volume as percentage between 0 and 100");
                    break;
                }
                this.playMelodyOnSink(args[0], args[1], volume, console);
                break;
            }
        }
    }

    private void playMelodyOnSinks(String pattern, String melody, @Nullable PercentType volume, Console console) {
        for (String sinkId : this.audioManager.getSinkIds(pattern)) {
            this.playMelodyOnSink(sinkId, melody, volume, console);
        }
    }

    private void playMelodyOnSink(@Nullable String sinkId, String melody, @Nullable PercentType volume, Console console) {
        this.audioManager.playMelody(melody, sinkId, volume);
    }

    private void playOnSinks(String pattern, String fileName, @Nullable PercentType volume, Console console) {
        for (String sinkId : this.audioManager.getSinkIds(pattern)) {
            this.playOnSink(sinkId, fileName, volume, console);
        }
    }

    private void playOnSink(@Nullable String sinkId, String fileName, @Nullable PercentType volume, Console console) {
        try {
            this.audioManager.playFile(fileName, sinkId, volume);
        }
        catch (AudioException e) {
            console.println(Objects.requireNonNullElse(e.getMessage(), String.format("An error occurred while playing '%s' on sink '%s'", fileName, sinkId)));
        }
    }

    private void stream(String[] args, Console console) {
        switch (args.length) {
            case 1: {
                this.streamOnSink(null, args[0], console);
                break;
            }
            case 2: {
                this.streamOnSinks(args[0], args[1], console);
                break;
            }
        }
    }

    private void streamOnSinks(String pattern, String url, Console console) {
        for (String sinkId : this.audioManager.getSinkIds(pattern)) {
            this.streamOnSink(sinkId, url, console);
        }
    }

    private void streamOnSink(@Nullable String sinkId, String url, Console console) {
        try {
            this.audioManager.stream(url, sinkId);
        }
        catch (AudioException e) {
            console.println(Objects.requireNonNullElse(e.getMessage(), String.format("An error occurred while streaming '%s' to sink '%s'", url, sinkId)));
        }
    }
}

