/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class AudioFormat {
    public static final AudioFormat MP3 = new AudioFormat("NONE", "MP3", null, null, null, null);
    public static final AudioFormat WAV = new AudioFormat("WAVE", "PCM_SIGNED", null, null, null, null);
    public static final AudioFormat OGG = new AudioFormat("OGG", "VORBIS", null, null, null, null);
    public static final AudioFormat AAC = new AudioFormat("NONE", "AAC", null, null, null, null);
    public static final String CONTAINER_NONE = "NONE";
    public static final String CONTAINER_WAVE = "WAVE";
    public static final String CONTAINER_OGG = "OGG";
    public static final String CODEC_PCM_SIGNED = "PCM_SIGNED";
    public static final String CODEC_PCM_UNSIGNED = "PCM_UNSIGNED";
    public static final String CODEC_PCM_ALAW = "ALAW";
    public static final String CODEC_PCM_ULAW = "ULAW";
    public static final String CODEC_MP3 = "MP3";
    public static final String CODEC_VORBIS = "VORBIS";
    public static final String CODEC_AAC = "AAC";
    private final @Nullable String codec;
    private final @Nullable String container;
    private final @Nullable Boolean bigEndian;
    private final @Nullable Integer bitDepth;
    private final @Nullable Integer bitRate;
    private final @Nullable Long frequency;
    private final @Nullable Integer channels;

    public AudioFormat(@Nullable String container, @Nullable String codec, @Nullable Boolean bigEndian, @Nullable Integer bitDepth, @Nullable Integer bitRate, @Nullable Long frequency) {
        this(container, codec, bigEndian, bitDepth, bitRate, frequency, 1);
    }

    public AudioFormat(@Nullable String container, @Nullable String codec, @Nullable Boolean bigEndian, @Nullable Integer bitDepth, @Nullable Integer bitRate, @Nullable Long frequency, @Nullable Integer channels) {
        this.container = container;
        this.codec = codec;
        this.bigEndian = bigEndian;
        this.bitDepth = bitDepth;
        this.bitRate = bitRate;
        this.frequency = frequency;
        this.channels = channels;
    }

    public @Nullable String getCodec() {
        return this.codec;
    }

    public @Nullable String getContainer() {
        return this.container;
    }

    public @Nullable Boolean isBigEndian() {
        return this.bigEndian;
    }

    public @Nullable Integer getBitDepth() {
        return this.bitDepth;
    }

    public @Nullable Integer getBitRate() {
        return this.bitRate;
    }

    public @Nullable Long getFrequency() {
        return this.frequency;
    }

    public @Nullable Integer getChannels() {
        return this.channels;
    }

    public boolean isCompatible(@Nullable AudioFormat audioFormat) {
        if (audioFormat == null) {
            return false;
        }
        if (this.getContainer() != null && !this.getContainer().equals(audioFormat.getContainer())) {
            return false;
        }
        if (this.getCodec() != null && !this.getCodec().equals(audioFormat.getCodec())) {
            return false;
        }
        if (this.isBigEndian() != null && !this.isBigEndian().equals(audioFormat.isBigEndian())) {
            return false;
        }
        if (this.getBitDepth() != null && !this.getBitDepth().equals(audioFormat.getBitDepth())) {
            return false;
        }
        if (this.getBitRate() != null && !this.getBitRate().equals(audioFormat.getBitRate())) {
            return false;
        }
        return this.getFrequency() == null || this.getFrequency().equals(audioFormat.getFrequency());
    }

    public static @Nullable AudioFormat getBestMatch(Set<AudioFormat> inputs, Set<AudioFormat> outputs) {
        AudioFormat preferredFormat = AudioFormat.getPreferredFormat(inputs);
        if (preferredFormat != null) {
            for (AudioFormat output : outputs) {
                if (output.isCompatible(preferredFormat)) {
                    return preferredFormat;
                }
                for (AudioFormat input : inputs) {
                    if (!output.isCompatible(input)) continue;
                    return input;
                }
            }
        }
        return null;
    }

    public static @Nullable AudioFormat getPreferredFormat(Set<AudioFormat> audioFormats) {
        for (AudioFormat currentAudioFormat : audioFormats) {
            if (currentAudioFormat.getCodec() == null || currentAudioFormat.getContainer() == null || currentAudioFormat.isBigEndian() == null || currentAudioFormat.getBitDepth() == null || currentAudioFormat.getBitRate() == null || currentAudioFormat.getFrequency() == null || !CONTAINER_WAVE.equals(currentAudioFormat.getContainer())) continue;
            return currentAudioFormat;
        }
        for (AudioFormat currentAudioFormat : audioFormats) {
            Integer channel;
            AudioFormat format = currentAudioFormat;
            if (format.getCodec() == null || format.getContainer() == null || !CONTAINER_WAVE.equals(format.getContainer())) continue;
            Integer n = channel = format.getChannels() == null ? Integer.valueOf(1) : format.getChannels();
            if (format.isBigEndian() == null) {
                format = new AudioFormat(format.getContainer(), format.getCodec(), Boolean.TRUE, format.getBitDepth(), format.getBitRate(), format.getFrequency(), channel);
            }
            if (format.getBitDepth() == null || format.getBitRate() == null || format.getFrequency() == null) {
                int defaultBitDepth = 16;
                long defaultFrequency = 16384L;
                Integer bitRate = format.getBitRate();
                Long frequency = format.getFrequency();
                Integer bitDepth = format.getBitDepth();
                if (bitRate == null) {
                    if (bitDepth == null) {
                        bitDepth = defaultBitDepth;
                    }
                    if (frequency == null) {
                        frequency = defaultFrequency;
                    }
                    bitRate = bitDepth * frequency.intValue();
                } else if (bitDepth == null) {
                    if (frequency == null) {
                        frequency = defaultFrequency;
                    }
                    bitDepth = bitRate / frequency.intValue();
                } else if (frequency == null) {
                    frequency = bitRate.longValue() / bitDepth.longValue();
                }
                format = new AudioFormat(format.getContainer(), format.getCodec(), format.isBigEndian(), bitDepth, bitRate, frequency, channel);
            }
            return format;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        void var3_2;
        AudioFormat audioFormat;
        Object object = obj;
        if (object instanceof AudioFormat && (audioFormat = (AudioFormat)object) == (AudioFormat)var3_2) {
            void format;
            if (this.getCodec() == null ? format.getCodec() != null : !this.getCodec().equals(format.getCodec())) {
                return false;
            }
            if (this.getContainer() == null ? format.getContainer() != null : !this.getContainer().equals(format.getContainer())) {
                return false;
            }
            if (this.isBigEndian() == null ? format.isBigEndian() != null : !this.isBigEndian().equals(format.isBigEndian())) {
                return false;
            }
            if (this.getBitDepth() == null ? format.getBitDepth() != null : !this.getBitDepth().equals(format.getBitDepth())) {
                return false;
            }
            if (this.getBitRate() == null ? format.getBitRate() != null : !this.getBitRate().equals(format.getBitRate())) {
                return false;
            }
            if (this.getFrequency() == null ? format.getFrequency() != null : !this.getFrequency().equals(format.getFrequency())) {
                return false;
            }
            if (this.getChannels() == null ? format.getChannels() != null : !this.getChannels().equals(format.getChannels())) {
                return false;
            }
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bigEndian == null ? 0 : this.bigEndian.hashCode());
        result = 31 * result + (this.bitDepth == null ? 0 : this.bitDepth.hashCode());
        result = 31 * result + (this.bitRate == null ? 0 : this.bitRate.hashCode());
        result = 31 * result + (this.codec == null ? 0 : this.codec.hashCode());
        result = 31 * result + (this.container == null ? 0 : this.container.hashCode());
        result = 31 * result + (this.frequency == null ? 0 : this.frequency.hashCode());
        result = 31 * result + (this.channels == null ? 0 : this.channels.hashCode());
        return result;
    }

    public String toString() {
        return "AudioFormat [" + (this.codec != null ? "codec=" + this.codec + ", " : "") + (this.container != null ? "container=" + this.container + ", " : "") + (this.bigEndian != null ? "bigEndian=" + this.bigEndian + ", " : "") + (this.bitDepth != null ? "bitDepth=" + this.bitDepth + ", " : "") + (this.bitRate != null ? "bitRate=" + this.bitRate + ", " : "") + (this.frequency != null ? "frequency=" + this.frequency + ", " : "") + (this.channels != null ? "channels=" + this.channels : "") + "]";
    }
}

