/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace.internal.json;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.AddonInfoRegistry;
import org.openhab.core.addon.AddonService;
import org.openhab.core.addon.marketplace.AbstractRemoteAddonService;
import org.openhab.core.addon.marketplace.MarketplaceAddonHandler;
import org.openhab.core.addon.marketplace.internal.json.model.AddonEntryDTO;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.storage.StorageService;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid={"org.openhab.jsonaddonservice"}, property={"service.pid=org.openhab.jsonaddonservice"}, service={AddonService.class})
@ConfigurableService(category="system", label="Json 3rd Party Add-on Service", description_uri="system:jsonaddonservice")
@NonNullByDefault
public class JsonAddonService
extends AbstractRemoteAddonService {
    static final String SERVICE_NAME = "Json 3rd Party Add-on Service";
    static final String CONFIG_URI = "system:jsonaddonservice";
    static final String SERVICE_PID = "org.openhab.jsonaddonservice";
    private static final String SERVICE_ID = "json";
    private static final String ADDON_ID_PREFIX = "json:";
    private static final String CONFIG_URLS = "urls";
    private static final String CONFIG_SHOW_UNSTABLE = "showUnstable";
    private final Logger logger = LoggerFactory.getLogger(JsonAddonService.class);
    private List<String> addonServiceUrls = List.of();
    private boolean showUnstable = false;

    @Activate
    public JsonAddonService(@Reference EventPublisher eventPublisher, @Reference StorageService storageService, @Reference ConfigurationAdmin configurationAdmin, @Reference AddonInfoRegistry addonInfoRegistry, Map<String, Object> config) {
        super(eventPublisher, configurationAdmin, storageService, addonInfoRegistry, SERVICE_PID);
        this.modified(config);
    }

    @Modified
    public void modified(@Nullable Map<String, Object> config) {
        if (config != null) {
            String urls = Objects.requireNonNullElse((String)config.get(CONFIG_URLS), "");
            this.addonServiceUrls = Arrays.asList(urls.split("\\|"));
            this.showUnstable = (Boolean)config.getOrDefault(CONFIG_SHOW_UNSTABLE, false);
            this.cachedRemoteAddons.invalidateValue();
            this.refreshSource();
        }
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    protected void addAddonHandler(MarketplaceAddonHandler handler) {
        this.addonHandlers.add(handler);
    }

    @Override
    protected void removeAddonHandler(MarketplaceAddonHandler handler) {
        this.addonHandlers.remove(handler);
    }

    public String getId() {
        return SERVICE_ID;
    }

    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    protected List<Addon> getRemoteAddons() {
        return this.addonServiceUrls.stream().map(urlString -> {
            try {
                URL url = new URL((String)urlString);
                URLConnection connection = url.openConnection();
                connection.addRequestProperty("Accept", "application/json");
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                    Type type = TypeToken.getParameterized(List.class, (Type[])new Type[]{AddonEntryDTO.class}).getType();
                    return (List)Objects.requireNonNull(this.gson.fromJson((Reader)reader, type));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return List.of();
            }
        }).flatMap(Collection::stream).filter(Objects::nonNull).map(e -> (AddonEntryDTO)e).filter(this::showAddon).map(this::fromAddonEntry).toList();
    }

    private boolean showAddon(AddonEntryDTO addonEntry) {
        if (addonEntry.uid.isBlank()) {
            this.logger.debug("Skipping {} because the UID is not set", (Object)addonEntry);
            return false;
        }
        if (!this.showUnstable && !"stable".equals(addonEntry.maturity)) {
            this.logger.debug("Skipping {} because the the add-on is not stable and showUnstable is disabled.", (Object)addonEntry);
            return false;
        }
        return true;
    }

    @Override
    public @Nullable Addon getAddon(String id, @Nullable Locale locale) {
        String queryId = id.startsWith(ADDON_ID_PREFIX) ? id : ADDON_ID_PREFIX + id;
        return this.cachedAddons.stream().filter(e -> queryId.equals(e.getUid())).findAny().orElse(null);
    }

    @Override
    public @Nullable String getAddonId(URI addonURI) {
        return null;
    }

    private Addon fromAddonEntry(AddonEntryDTO addonEntry) {
        String uid = ADDON_ID_PREFIX + addonEntry.uid;
        boolean installed = this.addonHandlers.stream().anyMatch(handler -> handler.supports(addonEntryDTO.type, addonEntryDTO.contentType) && handler.isInstalled(uid));
        HashMap<String, String> properties = new HashMap<String, String>();
        if (addonEntry.url.endsWith(".jar")) {
            properties.put("jar_download_url", addonEntry.url);
        } else if (addonEntry.url.endsWith(".kar")) {
            properties.put("kar_download_url", addonEntry.url);
        } else if (addonEntry.url.endsWith(".json")) {
            properties.put("json_download_url", addonEntry.url);
        } else if (addonEntry.url.endsWith(".yaml")) {
            properties.put("yaml_download_url", addonEntry.url);
        }
        boolean compatible = true;
        try {
            compatible = this.coreVersion.inRange(addonEntry.compatibleVersions);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Failed to determine compatibility for addon {}: {}", (Object)addonEntry.id, (Object)e.getMessage());
        }
        return Addon.create((String)uid).withType(addonEntry.type).withId(addonEntry.id).withInstalled(installed).withDetailedDescription(addonEntry.description).withContentType(addonEntry.contentType).withAuthor(addonEntry.author).withVersion(addonEntry.version).withLabel(addonEntry.title).withCompatible(compatible).withMaturity(addonEntry.maturity).withProperties(properties).withLink(addonEntry.link).withImageLink(addonEntry.imageUrl).withConfigDescriptionURI(addonEntry.configDescriptionURI).withLoggerPackages(addonEntry.loggerPackages).withConnection(addonEntry.connection).withCountries(addonEntry.countries).build();
    }
}

