/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace.internal.community;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.marketplace.MarketplaceAddonHandler;
import org.openhab.core.addon.marketplace.MarketplaceHandlerException;
import org.openhab.core.addon.marketplace.internal.automation.MarketplaceRuleTemplateProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class CommunityRuleTemplateAddonHandler
implements MarketplaceAddonHandler {
    private static final String JSON_DOWNLOAD_URL_PROPERTY = "json_download_url";
    private static final String YAML_DOWNLOAD_URL_PROPERTY = "yaml_download_url";
    private static final String JSON_CONTENT_PROPERTY = "json_content";
    private static final String YAML_CONTENT_PROPERTY = "yaml_content";
    private static final String RULETEMPLATES_CONTENT_TYPE = "application/vnd.openhab.ruletemplate";
    private final Logger logger = LoggerFactory.getLogger(CommunityRuleTemplateAddonHandler.class);
    private final MarketplaceRuleTemplateProvider marketplaceRuleTemplateProvider;

    @Activate
    public CommunityRuleTemplateAddonHandler(@Reference MarketplaceRuleTemplateProvider marketplaceRuleTemplateProvider) {
        this.marketplaceRuleTemplateProvider = marketplaceRuleTemplateProvider;
    }

    @Override
    public boolean supports(String type, String contentType) {
        return "automation".equals(type) && RULETEMPLATES_CONTENT_TYPE.equals(contentType);
    }

    @Override
    public boolean isInstalled(String id) {
        return this.marketplaceRuleTemplateProvider.getAll().stream().anyMatch(t -> t.getTags().contains(id));
    }

    @Override
    public void install(Addon addon) throws MarketplaceHandlerException {
        try {
            String jsonDownloadUrl = (String)addon.getProperties().get(JSON_DOWNLOAD_URL_PROPERTY);
            String yamlDownloadUrl = (String)addon.getProperties().get(YAML_DOWNLOAD_URL_PROPERTY);
            String jsonContent = (String)addon.getProperties().get(JSON_CONTENT_PROPERTY);
            String yamlContent = (String)addon.getProperties().get(YAML_CONTENT_PROPERTY);
            if (jsonDownloadUrl != null) {
                this.marketplaceRuleTemplateProvider.addTemplateAsJSON(addon.getUid(), this.getTemplateFromURL(jsonDownloadUrl));
            } else if (yamlDownloadUrl != null) {
                this.marketplaceRuleTemplateProvider.addTemplateAsYAML(addon.getUid(), this.getTemplateFromURL(yamlDownloadUrl));
            } else if (jsonContent != null) {
                this.marketplaceRuleTemplateProvider.addTemplateAsJSON(addon.getUid(), jsonContent);
            } else if (yamlContent != null) {
                this.marketplaceRuleTemplateProvider.addTemplateAsYAML(addon.getUid(), yamlContent);
            }
        }
        catch (IOException e) {
            this.logger.error("Rule template from marketplace cannot be downloaded: {}", (Object)e.getMessage());
            throw new MarketplaceHandlerException("Template cannot be downloaded.", e);
        }
        catch (Exception e) {
            this.logger.error("Rule template from marketplace is invalid: {}", (Object)e.getMessage());
            throw new MarketplaceHandlerException("Template is not valid.", e);
        }
    }

    @Override
    public void uninstall(Addon addon) throws MarketplaceHandlerException {
        this.marketplaceRuleTemplateProvider.getAll().stream().filter(t -> t.getTags().contains(addon.getUid())).forEach(w -> this.marketplaceRuleTemplateProvider.remove(w.getUID()));
    }

    private String getTemplateFromURL(String urlString) throws IOException {
        URL u = new URL(urlString);
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = u.openStream();){
            return new String(in.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

