/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class BundleVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<micro>\\d+)(\\.((?<rc>RC)|(?<milestone>M))?(?<qualifier>\\d+))?");
    public static final Pattern RANGE_PATTERN = Pattern.compile("\\[(?<start>\\d+\\.\\d+(?<startmicro>\\.\\d+(\\.\\w+)?)?);(?<end>\\d+\\.\\d+(?<endmicro>\\.\\d+(\\.\\w+)?)?)(?<endtype>[)\\]])");
    private final String version;
    private final int major;
    private final int minor;
    private final int micro;
    private final @Nullable Long qualifier;

    public BundleVersion(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            this.version = version;
            this.major = Integer.parseInt(matcher.group("major"));
            this.minor = Integer.parseInt(matcher.group("minor"));
            this.micro = Integer.parseInt(matcher.group("micro"));
            String qualifier = matcher.group("qualifier");
            if (qualifier != null) {
                long intQualifier = Long.parseLong(qualifier);
                this.qualifier = matcher.group("rc") != null ? Long.valueOf(intQualifier + Integer.MAX_VALUE) : Long.valueOf(intQualifier);
            } else {
                this.qualifier = null;
            }
        } else {
            throw new IllegalArgumentException("Input does not match pattern");
        }
    }

    public boolean inRange(@Nullable String range) throws IllegalArgumentException {
        if (range == null || range.isBlank()) {
            return true;
        }
        Matcher matcher = RANGE_PATTERN.matcher(range);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.valueOf(range) + "is not a valid version range");
        }
        String startString = matcher.group("startmicro") != null ? matcher.group("start") : String.valueOf(matcher.group("start")) + ".0";
        BundleVersion startVersion = new BundleVersion(startString);
        if (this.compareTo(startVersion) < 0) {
            return false;
        }
        String endString = matcher.group("endmicro") != null ? matcher.group("end") : String.valueOf(matcher.group("stop")) + ".0";
        boolean inclusive = "]".equals(matcher.group("endtype"));
        BundleVersion endVersion = new BundleVersion(endString);
        int comparison = this.compareTo(endVersion);
        return inclusive && comparison == 0 || comparison < 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleVersion version = (BundleVersion)o;
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro && Objects.equals(this.qualifier, version.qualifier);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.micro, this.qualifier);
    }

    public int compareTo(BundleVersion other) {
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        if (Objects.equals(this.qualifier, other.qualifier)) {
            return 0;
        }
        if (this.qualifier == null) {
            return 1;
        }
        if (other.qualifier == null) {
            return -1;
        }
        return Long.compare(this.qualifier, other.qualifier);
    }

    public String toString() {
        return this.version;
    }
}

