/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.addon.Addon;
import org.openhab.core.addon.AddonEvent;
import org.openhab.core.addon.AddonEventFactory;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonInfoRegistry;
import org.openhab.core.addon.AddonService;
import org.openhab.core.addon.AddonType;
import org.openhab.core.addon.marketplace.BundleVersion;
import org.openhab.core.addon.marketplace.MarketplaceAddonHandler;
import org.openhab.core.addon.marketplace.MarketplaceHandlerException;
import org.openhab.core.cache.ExpiringCache;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.storage.Storage;
import org.openhab.core.storage.StorageService;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractRemoteAddonService
implements AddonService {
    static final String CONFIG_REMOTE_ENABLED = "remote";
    static final String CONFIG_INCLUDE_INCOMPATIBLE = "includeIncompatible";
    static final Comparator<Addon> BY_COMPATIBLE_AND_VERSION = (addon1, addon2) -> {
        int compatible = Boolean.compare(addon2.getCompatible(), addon1.getCompatible());
        return compatible != 0 ? compatible : new BundleVersion(addon2.getVersion()).compareTo(new BundleVersion(addon1.getVersion()));
    };
    protected final BundleVersion coreVersion;
    protected final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").create();
    protected final Set<MarketplaceAddonHandler> addonHandlers = new HashSet<MarketplaceAddonHandler>();
    protected final Storage<String> installedAddonStorage;
    protected final EventPublisher eventPublisher;
    protected final ConfigurationAdmin configurationAdmin;
    protected final ExpiringCache<List<Addon>> cachedRemoteAddons = new ExpiringCache(Duration.ofMinutes(15L), this::getRemoteAddons);
    protected final AddonInfoRegistry addonInfoRegistry;
    protected List<Addon> cachedAddons = List.of();
    protected List<String> installedAddons = List.of();
    private final Logger logger = LoggerFactory.getLogger(AbstractRemoteAddonService.class);

    public AbstractRemoteAddonService(EventPublisher eventPublisher, ConfigurationAdmin configurationAdmin, StorageService storageService, AddonInfoRegistry addonInfoRegistry, String servicePid) {
        this.addonInfoRegistry = addonInfoRegistry;
        this.eventPublisher = eventPublisher;
        this.configurationAdmin = configurationAdmin;
        this.installedAddonStorage = storageService.getStorage(servicePid);
        this.coreVersion = this.getCoreVersion();
    }

    protected BundleVersion getCoreVersion() {
        return new BundleVersion(FrameworkUtil.getBundle(OpenHAB.class).getVersion().toString());
    }

    private Addon convertFromStorage(Map.Entry<String, @Nullable String> entry) {
        Addon storedAddon = Objects.requireNonNull((Addon)this.gson.fromJson(entry.getValue(), Addon.class));
        AddonInfo addonInfo = this.addonInfoRegistry.getAddonInfo(String.valueOf(storedAddon.getType()) + "-" + storedAddon.getId());
        if (addonInfo != null && storedAddon.getConfigDescriptionURI().isBlank()) {
            return Addon.create((Addon)storedAddon).withConfigDescriptionURI(addonInfo.getConfigDescriptionURI()).build();
        }
        return storedAddon;
    }

    public void refreshSource() {
        if (!this.addonHandlers.stream().allMatch(MarketplaceAddonHandler::isReady)) {
            this.logger.debug("Add-on service '{}' tried to refresh source before add-on handlers ready. Exiting.", this.getClass());
            return;
        }
        ArrayList<Addon> addons = new ArrayList<Addon>();
        try {
            this.installedAddonStorage.stream().map(this::convertFromStorage).forEach(addons::add);
        }
        catch (JsonSyntaxException e) {
            List.copyOf(this.installedAddonStorage.getKeys()).forEach(arg_0 -> this.installedAddonStorage.remove(arg_0));
            this.logger.error("Failed to read JSON database, trying to purge it. You might need to re-install {} from the '{}' service.", (Object)this.installedAddonStorage.getKeys(), (Object)this.getId());
            this.refreshSource();
        }
        List<String> installedAddons = addons.stream().map(Addon::getUid).toList();
        if (this.remoteEnabled()) {
            List remoteAddons = Objects.requireNonNullElse((List)this.cachedRemoteAddons.getValue(), List.of());
            remoteAddons.stream().filter(a -> !installedAddons.contains(a.getUid())).forEach(addons::add);
        }
        addons.forEach(addon -> addon.setInstalled(this.addonHandlers.stream().anyMatch(h -> h.isInstalled(addon.getUid()))));
        boolean showIncompatible = this.includeIncompatible();
        addons.removeIf(addon -> !addon.isInstalled() && !addon.getCompatible() && !showIncompatible);
        HashMap addonMap = new HashMap();
        addons.forEach(a -> {
            boolean bl = addonMap.computeIfAbsent(a.getUid(), k -> new ArrayList()).add(a);
        });
        for (List partialAddonList : addonMap.values()) {
            if (partialAddonList.size() <= 1) continue;
            partialAddonList.stream().sorted(BY_COMPATIBLE_AND_VERSION).skip(1L).forEach(addons::remove);
        }
        this.cachedAddons = addons;
        this.installedAddons = installedAddons;
    }

    protected abstract void addAddonHandler(MarketplaceAddonHandler var1);

    protected abstract void removeAddonHandler(MarketplaceAddonHandler var1);

    protected abstract List<Addon> getRemoteAddons();

    public List<Addon> getAddons(@Nullable Locale locale) {
        this.refreshSource();
        return this.cachedAddons;
    }

    public abstract @Nullable Addon getAddon(String var1, @Nullable Locale var2);

    public List<AddonType> getTypes(@Nullable Locale locale) {
        return AddonType.DEFAULT_TYPES;
    }

    public void install(String id) {
        Addon addon = this.getAddon(id, null);
        if (addon != null) {
            for (MarketplaceAddonHandler handler : this.addonHandlers) {
                if (!handler.supports(addon.getType(), addon.getContentType())) continue;
                if (!handler.isInstalled(addon.getUid())) {
                    try {
                        handler.install(addon);
                        this.installedAddonStorage.put(id, (Object)this.gson.toJson((Object)addon));
                        this.refreshSource();
                        this.postInstalledEvent(addon.getUid());
                    }
                    catch (MarketplaceHandlerException e) {
                        this.postFailureEvent(addon.getUid(), e.getMessage());
                    }
                } else {
                    this.postFailureEvent(addon.getUid(), "Add-on is already installed.");
                }
                return;
            }
        }
        this.postFailureEvent(id, "Add-on not known.");
    }

    public void uninstall(String id) {
        Addon addon = this.getAddon(id, null);
        if (addon != null) {
            for (MarketplaceAddonHandler handler : this.addonHandlers) {
                if (!handler.supports(addon.getType(), addon.getContentType())) continue;
                if (handler.isInstalled(addon.getUid())) {
                    try {
                        handler.uninstall(addon);
                        this.installedAddonStorage.remove(id);
                        this.refreshSource();
                        this.postUninstalledEvent(addon.getUid());
                    }
                    catch (MarketplaceHandlerException e) {
                        this.postFailureEvent(addon.getUid(), e.getMessage());
                    }
                } else {
                    this.installedAddonStorage.remove(id);
                    this.postFailureEvent(addon.getUid(), "Add-on is not installed.");
                }
                return;
            }
        }
        this.postFailureEvent(id, "Add-on not known.");
    }

    public abstract @Nullable String getAddonId(URI var1);

    protected boolean remoteEnabled() {
        Dictionary properties;
        block3: {
            try {
                Configuration configuration = this.configurationAdmin.getConfiguration("org.openhab.addons", null);
                properties = configuration.getProperties();
                if (properties != null) break block3;
                return true;
            }
            catch (IOException e) {
                return true;
            }
        }
        return (Boolean)ConfigParser.valueAsOrElse(properties.get(CONFIG_REMOTE_ENABLED), Boolean.class, (Object)true);
    }

    protected boolean includeIncompatible() {
        Dictionary properties;
        block3: {
            try {
                Configuration configuration = this.configurationAdmin.getConfiguration("org.openhab.addons", null);
                properties = configuration.getProperties();
                if (properties != null) break block3;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return (Boolean)ConfigParser.valueAsOrElse(properties.get(CONFIG_INCLUDE_INCOMPATIBLE), Boolean.class, (Object)false);
    }

    private void postInstalledEvent(String extensionId) {
        AddonEvent event = AddonEventFactory.createAddonInstalledEvent((String)extensionId);
        this.eventPublisher.post((Event)event);
    }

    private void postUninstalledEvent(String extensionId) {
        AddonEvent event = AddonEventFactory.createAddonUninstalledEvent((String)extensionId);
        this.eventPublisher.post((Event)event);
    }

    private void postFailureEvent(String extensionId, @Nullable String msg) {
        AddonEvent event = AddonEventFactory.createAddonFailureEvent((String)extensionId, (String)msg);
        this.eventPublisher.post((Event)event);
    }
}

