/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.tiles;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.ui.tiles.Tile;

@NonNullByDefault
public class ExternalServiceTile
implements Tile {
    private String name;
    private String url;
    private @Nullable String overlay;
    private String imageUrl;

    private ExternalServiceTile(TileBuilder builder) {
        this.name = builder.name;
        this.url = builder.url;
        this.overlay = builder.overlay;
        this.imageUrl = builder.imageUrl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public @Nullable String getOverlay() {
        return this.overlay;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String toString() {
        int maxlen = 100;
        String limitedImageUrl = this.imageUrl;
        if (limitedImageUrl.length() > 100) {
            limitedImageUrl = String.valueOf(this.imageUrl.substring(0, 100)) + "...";
        }
        return "[name=" + this.name + ", url=" + this.url + ", overlay=" + this.overlay + ", imageUrl=" + limitedImageUrl + "]";
    }

    public static class TileBuilder {
        private String name = "";
        private String url = "";
        private @Nullable String overlay;
        private String imageUrl = "";

        public TileBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public TileBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        public TileBuilder withOverlay(@Nullable String overlay) {
            this.overlay = overlay;
            return this;
        }

        public TileBuilder withImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public ExternalServiceTile build() {
            return new ExternalServiceTile(this);
        }
    }
}

