/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.tiles;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.ui.tiles.ExternalServiceTile;
import org.openhab.core.ui.tiles.Tile;
import org.openhab.core.ui.tiles.TileProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, name="org.openhab.core.ui.tiles")
@NonNullByDefault
public class TileService
implements TileProvider {
    private static final String LINK_NAME = "link-name";
    private static final String LINK_URL = "link-url";
    private static final String LINK_IMAGEURL = "link-imageurl";
    private final Logger logger = LoggerFactory.getLogger(TileService.class);
    private final Set<Tile> tiles = new CopyOnWriteArraySet<Tile>();

    @Activate
    public TileService(Map<String, Object> properties) {
        this.addTilesForExternalServices(properties);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addTile(Tile tile) {
        this.tiles.add(tile);
    }

    protected void removeTile(Tile tile) {
        this.tiles.remove(tile);
    }

    @Override
    public Stream<Tile> getTiles() {
        return this.tiles.stream();
    }

    private void addTilesForExternalServices(Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            if (!key.endsWith(LINK_NAME) || key.length() <= LINK_NAME.length()) continue;
            String linkname = key.substring(0, key.length() - LINK_NAME.length());
            String name = (String)properties.getOrDefault(String.valueOf(linkname) + LINK_NAME, "");
            String url = (String)properties.getOrDefault(String.valueOf(linkname) + LINK_URL, "");
            String imageUrl = (String)properties.getOrDefault(String.valueOf(linkname) + LINK_IMAGEURL, "");
            if (!name.isEmpty() && !url.isEmpty()) {
                ExternalServiceTile.TileBuilder builder = new ExternalServiceTile.TileBuilder().withName(name).withUrl(url);
                if (!imageUrl.isEmpty()) {
                    builder = builder.withImageUrl(imageUrl);
                }
                ExternalServiceTile newTile = builder.build();
                this.addTile(newTile);
                this.logger.debug("Tile added: {}", (Object)newTile);
                continue;
            }
            this.logger.warn("Ignore invalid tile '{}': {}", (Object)linkname, (Object)name);
        }
    }
}

