/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Text {
    public static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ssz";

    public static String ltrim(String s) {
        return s.replaceAll("(?s)^\\s+", "");
    }

    public static String rtrim(String s) {
        return s.replaceAll("(?s)\\s+$", "");
    }

    public static String displayFilesize(long fileSizeInBytes) {
        if (fileSizeInBytes >= 0x40000000L) {
            return new BigDecimal(fileSizeInBytes / 1024L / 1024L / 1024L) + " GiB";
        }
        if (fileSizeInBytes >= 0x100000L) {
            return new BigDecimal(fileSizeInBytes / 1024L / 1024L) + " MiB";
        }
        if (fileSizeInBytes >= 1024L) {
            return new BigDecimal(fileSizeInBytes / 1024L) + " KiB";
        }
        return new BigDecimal(fileSizeInBytes) + " bytes";
    }

    public static Calendar fromISO8601String(TimeZone targetTimeZone, String s) {
        SimpleDateFormat format = new SimpleDateFormat(ISO8601_PATTERN);
        format.setTimeZone(targetTimeZone);
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(format.parse(s));
            return cal;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String toISO8601String(TimeZone targetTimeZone, Date datetime) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(datetime);
        return Text.toISO8601String(targetTimeZone, cal);
    }

    public static String toISO8601String(TimeZone targetTimeZone, long unixTime) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(unixTime);
        return Text.toISO8601String(targetTimeZone, cal);
    }

    public static String toISO8601String(TimeZone targetTimeZone, Calendar cal) {
        SimpleDateFormat format = new SimpleDateFormat(ISO8601_PATTERN);
        format.setTimeZone(targetTimeZone);
        try {
            return format.format(cal.getTime());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

