/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.types.UDN;

public class DeviceIdentity
implements Validatable {
    private final UDN udn;
    private final Integer maxAgeSeconds;

    public DeviceIdentity(UDN udn, DeviceIdentity template) {
        this.udn = udn;
        this.maxAgeSeconds = template.getMaxAgeSeconds();
    }

    public DeviceIdentity(UDN udn) {
        this.udn = udn;
        this.maxAgeSeconds = 1800;
    }

    public DeviceIdentity(UDN udn, Integer maxAgeSeconds) {
        this.udn = udn;
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public UDN getUdn() {
        return this.udn;
    }

    public Integer getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceIdentity that = (DeviceIdentity)o;
        return this.udn.equals(that.udn);
    }

    public int hashCode() {
        return this.udn.hashCode();
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") UDN: " + this.getUdn();
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getUdn() == null) {
            errors.add(new ValidationError(this.getClass(), "major", "Device has no UDN"));
        }
        return errors;
    }
}

