/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.cxf.jaxrs.client;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.osgi.service.jaxrs.client.PromiseRxInvoker;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

class PromiseRxInvokerImpl
implements PromiseRxInvoker {
    private final Method _doInvokeAsyncMethod;
    private final PromiseFactory _promiseFactory;
    private final WebClient _webClient;

    public PromiseRxInvokerImpl(WebClient webClient, PromiseFactory promiseFactory) {
        this._webClient = webClient;
        try {
            this._doInvokeAsyncMethod = WebClient.class.getDeclaredMethod("doInvokeAsync", String.class, Object.class, Class.class, Type.class, Class.class, Type.class, InvocationCallback.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
        this._doInvokeAsyncMethod.setAccessible(true);
        this._promiseFactory = promiseFactory;
    }

    public Promise<Response> delete() {
        return this.method("DELETE");
    }

    public <R> Promise<R> delete(Class<R> aClass) {
        return this.method("DELETE", aClass);
    }

    public <R> Promise<R> delete(GenericType<R> genericType) {
        return this.method("DELETE", genericType);
    }

    public Promise<Response> get() {
        return this.method("GET");
    }

    public <R> Promise<R> get(Class<R> aClass) {
        return this.method("GET", aClass);
    }

    public <R> Promise<R> get(GenericType<R> genericType) {
        return this.method("GET", genericType);
    }

    public Promise<Response> head() {
        return this.method("HEAD");
    }

    public <R> Promise<R> method(String s, Class<R> responseType) {
        Deferred deferred = this._promiseFactory.deferred();
        try {
            this._doInvokeAsyncMethod.invoke((Object)this._webClient, s, null, null, null, responseType, responseType, new DeferredHandler(deferred));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return deferred.getPromise();
    }

    public <R> Promise<R> method(String s, Entity<?> entity, Class<R> responseType) {
        Deferred deferred = this._promiseFactory.deferred();
        try {
            this._doInvokeAsyncMethod.invoke((Object)this._webClient, s, entity, null, null, responseType, responseType, new DeferredHandler(deferred));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return deferred.getPromise();
    }

    public <R> Promise<R> method(String s, Entity<?> entity, GenericType<R> genericType) {
        Deferred deferred = this._promiseFactory.deferred();
        try {
            this._doInvokeAsyncMethod.invoke((Object)this._webClient, s, entity, null, null, genericType.getRawType(), genericType.getType(), new DeferredHandler(deferred));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return deferred.getPromise();
    }

    public Promise<Response> method(String s, Entity<?> entity) {
        return this.method(s, entity, Response.class);
    }

    public <R> Promise<R> method(String s, GenericType<R> genericType) {
        Deferred deferred = this._promiseFactory.deferred();
        try {
            this._doInvokeAsyncMethod.invoke((Object)this._webClient, s, null, null, null, genericType.getRawType(), genericType.getType(), new DeferredHandler(deferred));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return deferred.getPromise();
    }

    public Promise<Response> method(String s) {
        return this.method(s, Response.class);
    }

    public Promise<Response> options() {
        return this.method("OPTIONS");
    }

    public <R> Promise<R> options(Class<R> aClass) {
        return this.method("OPTIONS", aClass);
    }

    public <R> Promise<R> options(GenericType<R> genericType) {
        return this.method("OPTIONS", genericType);
    }

    public <R> Promise<R> post(Entity<?> entity, Class<R> aClass) {
        return this.method("POST", entity, aClass);
    }

    public <R> Promise<R> post(Entity<?> entity, GenericType<R> genericType) {
        return this.method("POST", entity, genericType);
    }

    public Promise<Response> post(Entity<?> entity) {
        return this.method("POST", entity);
    }

    public <R> Promise<R> put(Entity<?> entity, Class<R> aClass) {
        return this.method("PUT", entity, aClass);
    }

    public <R> Promise<R> put(Entity<?> entity, GenericType<R> genericType) {
        return this.method("PUT", entity, genericType);
    }

    public Promise<Response> put(Entity<?> entity) {
        return this.method("PUT", entity);
    }

    public Promise<Response> trace() {
        return this.method("TRACE", Response.class);
    }

    public <R> Promise<R> trace(Class<R> aClass) {
        return this.method("TRACE", aClass);
    }

    public <R> Promise<R> trace(GenericType<R> genericType) {
        return this.method("TRACE", genericType);
    }

    private static final class DeferredHandler<R>
    implements InvocationCallback<R> {
        private final Deferred<R> deferred;

        private DeferredHandler(Deferred<R> deferred) {
            this.deferred = deferred;
        }

        public void completed(R response) {
            this.deferred.resolve(response);
        }

        public void failed(Throwable throwable) {
            this.deferred.fail(throwable);
        }
    }
}

