/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.item;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.core.item.EnrichedGroupItemDTO;
import org.openhab.core.io.rest.core.item.EnrichedItemDTO;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.dto.ItemDTO;
import org.openhab.core.items.dto.ItemDTOMapper;
import org.openhab.core.library.items.NumberItem;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationHelper;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.StateDescriptionFragmentBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class EnrichedItemDTOMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrichedItemDTOMapper.class);

    public static EnrichedItemDTO map(Item item, boolean drillDown, @Nullable Predicate<Item> itemFilter, @Nullable UriBuilder uriBuilder, @Nullable Locale locale) {
        ItemDTO itemDTO = ItemDTOMapper.map((Item)item);
        return EnrichedItemDTOMapper.map(item, itemDTO, drillDown, itemFilter, uriBuilder, locale, new ArrayList<Item>());
    }

    private static EnrichedItemDTO mapRecursive(Item item, @Nullable Predicate<Item> itemFilter, @Nullable UriBuilder uriBuilder, @Nullable Locale locale, List<Item> parents) {
        ItemDTO itemDTO = ItemDTOMapper.map((Item)item);
        return EnrichedItemDTOMapper.map(item, itemDTO, true, itemFilter, uriBuilder, locale, parents);
    }

    private static EnrichedItemDTO map(Item item, ItemDTO itemDTO, boolean drillDown, @Nullable Predicate<Item> itemFilter, @Nullable UriBuilder uriBuilder, @Nullable Locale locale, List<Item> parents) {
        if (item instanceof GroupItem) {
            parents.add(item);
        }
        if ((transformedState = EnrichedItemDTOMapper.considerTransformation(state = item.getState().toFullString(), item, locale)) != null && transformedState.equals(state)) {
            transformedState = null;
        }
        StateDescription stateDescription = EnrichedItemDTOMapper.considerTransformation(item.getStateDescription(locale));
        String link = uriBuilder != null ? uriBuilder.build(new Object[]{itemDTO.name}).toASCIIString() : null;
        String unitSymbol = null;
        if (item instanceof NumberItem var13_13) {
            unitSymbol = numberItem.getUnitSymbol();
        }
        if (( instanceOfPatternExpressionValue = item) instanceof GroupItem var15_15) {
            if (drillDown) {
                LinkedHashSet<EnrichedItemDTO> members = new LinkedHashSet<EnrichedItemDTO>();
                for (Item member : groupItem.getMembers()) {
                    if (parents.contains(member)) {
                        LOGGER.error("Recursive group membership found: {} is both, a direct or indirect parent and a child of {}.", (Object)member.getName(), (Object)groupItem.getName());
                        continue;
                    }
                    if (itemFilter != null && !itemFilter.test(member)) continue;
                    members.add(EnrichedItemDTOMapper.mapRecursive(member, itemFilter, uriBuilder, locale, parents));
                }
                memberDTOs = members.toArray(new EnrichedItemDTO[0]);
            } else {
                memberDTOs = new EnrichedItemDTO[]{};
            }
            enrichedItemDTO = new EnrichedGroupItemDTO(itemDTO, memberDTOs, link, state, transformedState, stateDescription, unitSymbol);
        } else {
            enrichedItemDTO = new EnrichedItemDTO(itemDTO, link, state, transformedState, stateDescription, item.getCommandDescription(locale), unitSymbol);
        }
        return enrichedItemDTO;
    }

    private static @Nullable StateDescription considerTransformation(@Nullable StateDescription stateDescription) {
        String pattern;
        if (stateDescription != null && (pattern = stateDescription.getPattern()) != null) {
            try {
                return TransformationHelper.isTransform((String)pattern) ? StateDescriptionFragmentBuilder.create((StateDescription)stateDescription).withPattern(pattern).build().toStateDescription() : stateDescription;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return stateDescription;
    }

    private static @Nullable String considerTransformation(String state, Item item, @Nullable Locale locale) {
        String pattern;
        StateDescription stateDescription = item.getStateDescription(locale);
        if (stateDescription != null && (pattern = stateDescription.getPattern()) != null) {
            try {
                return TransformationHelper.transform((BundleContext)FrameworkUtil.getBundle(EnrichedItemDTOMapper.class).getBundleContext(), (String)pattern, (String)state);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (TransformationException e) {
                LOGGER.warn("Failed transforming the state '{}' on item '{}' with pattern '{}': {}", new Object[]{state, item.getName(), pattern, e.getMessage()});
            }
        }
        return state;
    }
}

