/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.profile;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.thing.profiles.ProfileType;
import org.openhab.core.thing.profiles.ProfileTypeRegistry;
import org.openhab.core.thing.profiles.StateProfileType;
import org.openhab.core.thing.profiles.TriggerProfileType;
import org.openhab.core.thing.profiles.dto.ProfileTypeDTO;
import org.openhab.core.thing.profiles.dto.ProfileTypeDTOMapper;
import org.openhab.core.thing.type.ChannelType;
import org.openhab.core.thing.type.ChannelTypeRegistry;
import org.openhab.core.thing.type.ChannelTypeUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="profile-types")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="profile-types")
@Component
@JaxrsResource
@JaxrsName(value="profile-types")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ProfileTypeResource
implements RESTResource {
    public static final String PATH_PROFILE_TYPES = "profile-types";
    private final ChannelTypeRegistry channelTypeRegistry;
    private final LocaleService localeService;
    private final ProfileTypeRegistry profileTypeRegistry;

    @Activate
    public ProfileTypeResource(@Reference ChannelTypeRegistry channelTypeRegistry, @Reference LocaleService localeService, @Reference ProfileTypeRegistry profileTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
        this.localeService = localeService;
        this.profileTypeRegistry = profileTypeRegistry;
    }

    @GET
    @RolesAllowed(value={"user", "administrator"})
    @Produces(value={"application/json"})
    @Operation(operationId="getProfileTypes", summary="Gets all available profile types.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ProfileTypeDTO.class), uniqueItems=true))})})
    public Response getAll(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="channelTypeUID") @Parameter(description="channel type filter") @Nullable String channelTypeUID, @QueryParam(value="itemType") @Parameter(description="item type filter") @Nullable String itemType) {
        Locale locale = this.localeService.getLocale(language);
        return Response.ok((Object)new Stream2JSONInputStream(this.getProfileTypes(locale, channelTypeUID, itemType))).build();
    }

    protected Stream<ProfileTypeDTO> getProfileTypes(@Nullable Locale locale, @Nullable String channelTypeUID, @Nullable String itemType) {
        return this.profileTypeRegistry.getProfileTypes(locale).stream().filter(this.matchesChannelUID(channelTypeUID, locale)).filter(this.matchesItemType(itemType)).sorted(Comparator.comparing(ProfileType::getLabel)).map(profileType -> ProfileTypeDTOMapper.map((ProfileType)profileType));
    }

    private Predicate<ProfileType> matchesChannelUID(@Nullable String channelTypeUID, @Nullable Locale locale) {
        if (channelTypeUID == null) {
            return t -> true;
        }
        ChannelType channelType = this.channelTypeRegistry.getChannelType(new ChannelTypeUID(channelTypeUID), locale);
        if (channelType == null) {
            return t -> false;
        }
        switch (channelType.getKind()) {
            case STATE: {
                return t -> this.stateProfileMatchesProfileType((ProfileType)t, channelType);
            }
            case TRIGGER: {
                return t -> this.triggerProfileMatchesProfileType((ProfileType)t, channelType);
            }
        }
        return t -> false;
    }

    private Predicate<ProfileType> matchesItemType(@Nullable String itemType) {
        if (itemType == null) {
            return t -> true;
        }
        return t -> this.profileTypeMatchesItemType((ProfileType)t, itemType);
    }

    private boolean profileTypeMatchesItemType(ProfileType pt, String itemType) {
        Collection supportedItemTypesOnProfileType = pt.getSupportedItemTypes();
        return supportedItemTypesOnProfileType.isEmpty() || supportedItemTypesOnProfileType.contains(ItemUtil.getMainItemType((String)itemType)) || supportedItemTypesOnProfileType.contains(itemType);
    }

    private boolean triggerProfileMatchesProfileType(ProfileType profileType, ChannelType channelType) {
        if (profileType instanceof TriggerProfileType var3_4) {
            if (triggerProfileType.getSupportedChannelTypeUIDs().isEmpty()) {
                return true;
            }
            if (triggerProfileType.getSupportedChannelTypeUIDs().contains(channelType.getUID())) {
                return true;
            }
        }
        return false;
    }

    private boolean stateProfileMatchesProfileType(ProfileType profileType, ChannelType channelType) {
        if (profileType instanceof StateProfileType var3_4) {
            if (stateProfileType.getSupportedItemTypesOfChannel().isEmpty()) {
                return true;
            }
            Collection supportedItemTypesOfChannelOnProfileType = stateProfileType.getSupportedItemTypesOfChannel();
            String itemType = channelType.getItemType();
            return itemType != null && supportedItemTypesOfChannelOnProfileType.contains(ItemUtil.getMainItemType((String)itemType));
        }
        return false;
    }
}

