/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.link;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.io.rest.core.link.EnrichedItemChannelLinkDTO;
import org.openhab.core.io.rest.core.link.EnrichedItemChannelLinkDTOMapper;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.thing.Channel;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.UID;
import org.openhab.core.thing.link.AbstractLink;
import org.openhab.core.thing.link.ItemChannelLink;
import org.openhab.core.thing.link.ItemChannelLinkRegistry;
import org.openhab.core.thing.link.ManagedItemChannelLinkProvider;
import org.openhab.core.thing.link.dto.ItemChannelLinkDTO;
import org.openhab.core.thing.profiles.ProfileType;
import org.openhab.core.thing.profiles.ProfileTypeRegistry;
import org.openhab.core.thing.profiles.ProfileTypeUID;
import org.openhab.core.thing.profiles.TriggerProfileType;
import org.openhab.core.thing.type.ChannelKind;
import org.openhab.core.thing.type.ChannelTypeRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="links")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="links")
@Component(service={RESTResource.class, ItemChannelLinkResource.class})
@JaxrsResource
@JaxrsName(value="links")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ItemChannelLinkResource
implements RESTResource {
    public static final String PATH_LINKS = "links";
    private final ItemChannelLinkRegistry itemChannelLinkRegistry;
    private final ManagedItemChannelLinkProvider managedItemChannelLinkProvider;
    private final ThingRegistry thingRegistry;
    private final ItemRegistry itemRegistry;
    private final ProfileTypeRegistry profileTypeRegistry;

    @Activate
    public ItemChannelLinkResource(@Reference ItemRegistry itemRegistry, @Reference ThingRegistry thingRegistry, @Reference ChannelTypeRegistry channelTypeRegistry, @Reference ProfileTypeRegistry profileTypeRegistry, @Reference ItemChannelLinkRegistry itemChannelLinkRegistry, @Reference ManagedItemChannelLinkProvider managedItemChannelLinkProvider) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
        this.managedItemChannelLinkProvider = managedItemChannelLinkProvider;
        this.thingRegistry = thingRegistry;
        this.itemRegistry = itemRegistry;
        this.profileTypeRegistry = profileTypeRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getItemLinks", summary="Gets all available links.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EnrichedItemChannelLinkDTO.class)))})})
    public Response getAll(@QueryParam(value="channelUID") @Parameter(description="filter by channel UID") @Nullable String channelUID, @QueryParam(value="itemName") @Parameter(description="filter by item name") @Nullable String itemName) {
        Stream<EnrichedItemChannelLinkDTO> linkStream = this.itemChannelLinkRegistry.stream().map(link -> EnrichedItemChannelLinkDTOMapper.map(link, this.isEditable(AbstractLink.getIDFor((String)link.getItemName(), (UID)link.getLinkedUID()))));
        if (channelUID != null) {
            linkStream = linkStream.filter(link -> channelUID.equals(link.channelUID));
        }
        if (itemName != null) {
            linkStream = linkStream.filter(link -> itemName.equals(link.itemName));
        }
        return Response.ok((Object)new Stream2JSONInputStream(linkStream)).build();
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{object}")
    @Operation(operationId="removeAllLinksForObject", summary="Delete all links that refer to an item or thing.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK")})
    public Response removeAllLinksForObject(@PathParam(value="object") @Parameter(description="item name or thing UID") String object) {
        int removedLinks;
        try {
            ThingUID thingUID = new ThingUID(object);
            removedLinks = this.itemChannelLinkRegistry.removeLinksForThing(thingUID);
        }
        catch (IllegalArgumentException e) {
            removedLinks = this.itemChannelLinkRegistry.removeLinksForItem(object);
        }
        return Response.ok(Map.of("count", removedLinks)).build();
    }

    @GET
    @Path(value="/{itemName}/{channelUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getItemLink", summary="Retrieves an individual link.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=EnrichedItemChannelLinkDTO.class))}), @ApiResponse(responseCode="404", description="Content does not match the path")})
    public Response getLink(@PathParam(value="itemName") @Parameter(description="item name") String itemName, @PathParam(value="channelUID") @Parameter(description="channel UID") String channelUid) {
        List<EnrichedItemChannelLinkDTO> links = this.itemChannelLinkRegistry.stream().filter(link -> channelUid.equals(link.getLinkedUID().getAsString())).filter(link -> itemName.equals(link.getItemName())).map(link -> EnrichedItemChannelLinkDTOMapper.map(link, this.isEditable(AbstractLink.getIDFor((String)link.getItemName(), (UID)link.getLinkedUID())))).toList();
        if (!links.isEmpty()) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.OK, (Object)((Object)links.get(0)), null);
        }
        return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)("No link found for item '" + itemName + "' + and channelUID '" + channelUid + "'"));
    }

    @PUT
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemName}/{channelUID}")
    @Consumes(value={"application/json"})
    @Operation(operationId="linkItemToChannel", summary="Links an item to a channel.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Content does not match the path"), @ApiResponse(responseCode="405", description="Link is not editable")})
    public Response link(@PathParam(value="itemName") @Parameter(description="itemName") String itemName, @PathParam(value="channelUID") @Parameter(description="channelUID") String channelUid, @Parameter(description="link data") @Nullable ItemChannelLinkDTO bean) {
        ItemChannelLink link;
        ChannelUID uid;
        Item item;
        try {
            item = this.itemRegistry.getItem(itemName);
        }
        catch (ItemNotFoundException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            uid = new ChannelUID(channelUid);
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Channel channel = this.getChannel(uid);
        if (channel == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ChannelKind channelKind = channel.getKind();
        if (ChannelKind.TRIGGER.equals((Object)channelKind)) {
            String itemType = ItemUtil.getMainItemType((String)item.getType());
            if (bean == null || bean.configuration == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String profileUid = (String)bean.configuration.get("profile");
            if (profileUid == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            ProfileType profileType = this.profileTypeRegistry.getProfileTypes().stream().filter(p -> profileUid.equals(((ProfileTypeUID)p.getUID()).getAsString())).findFirst().orElse(null);
            if (!(profileType instanceof TriggerProfileType)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!profileType.getSupportedItemTypes().isEmpty() && !profileType.getSupportedItemTypes().contains(itemType) || !((TriggerProfileType)profileType).getSupportedChannelTypeUIDs().isEmpty() && !((TriggerProfileType)profileType).getSupportedChannelTypeUIDs().contains(channel.getChannelTypeUID())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        if (bean == null) {
            link = new ItemChannelLink(itemName, uid, new Configuration());
        } else {
            if (bean.channelUID != null && !bean.channelUID.equals(channelUid)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (bean.itemName != null && !bean.itemName.equals(itemName)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            link = new ItemChannelLink(itemName, uid, new Configuration(bean.configuration));
        }
        if (this.itemChannelLinkRegistry.get((Object)link.getUID()) == null) {
            this.itemChannelLinkRegistry.add((Identifiable)link);
        } else {
            ItemChannelLink oldLink = (ItemChannelLink)this.itemChannelLinkRegistry.update((Identifiable)link);
            if (oldLink == null) {
                return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
            }
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @DELETE
    @RolesAllowed(value={"administrator"})
    @Path(value="/{itemName}/{channelUID}")
    @Operation(operationId="unlinkItemFromChannel", summary="Unlinks an item from a channel.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Link not found."), @ApiResponse(responseCode="405", description="Link not editable.")})
    public Response unlink(@PathParam(value="itemName") @Parameter(description="itemName") String itemName, @PathParam(value="channelUID") @Parameter(description="channelUID") String channelUid) {
        ChannelUID uid;
        try {
            uid = new ChannelUID(channelUid);
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String linkId = AbstractLink.getIDFor((String)itemName, (UID)uid);
        if (this.itemChannelLinkRegistry.get((Object)linkId) == null) {
            String message = "Link " + linkId + " does not exist!";
            return JSONResponse.createResponse((Response.StatusType)Response.Status.NOT_FOUND, null, (String)message);
        }
        ItemChannelLink result = (ItemChannelLink)this.itemChannelLinkRegistry.remove((Object)linkId);
        if (result == null) {
            return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).build();
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @RolesAllowed(value={"administrator"})
    @Path(value="/purge")
    @Operation(operationId="purgeDatabase", summary="Remove unused/orphaned links.", security={@SecurityRequirement(name="oauth2", scopes={"admin"})}, responses={@ApiResponse(responseCode="200", description="OK")})
    public Response purge() {
        this.itemChannelLinkRegistry.purge();
        return Response.ok().build();
    }

    private boolean isEditable(String linkId) {
        return this.managedItemChannelLinkProvider.get((Object)linkId) != null;
    }

    private @Nullable Channel getChannel(ChannelUID channelUID) {
        Thing thing = this.thingRegistry.get(channelUID.getThingUID());
        if (thing == null) {
            return null;
        }
        return thing.getChannel(channelUID);
    }
}

