/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.item;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.MetadataRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MetadataSelectorMatcher.class})
@NonNullByDefault
public class MetadataSelectorMatcher {
    private final MetadataRegistry metadataRegistry;

    @Activate
    public MetadataSelectorMatcher(@Reference MetadataRegistry metadataRegistry) {
        this.metadataRegistry = metadataRegistry;
    }

    public Set<String> filterNamespaces(@Nullable String namespaceSelector, @Nullable Locale locale) {
        if (namespaceSelector == null || namespaceSelector.isEmpty()) {
            return Set.of();
        }
        Set originalNamespaces = Arrays.stream(namespaceSelector.split(",")).filter(n -> !this.metadataRegistry.isInternalNamespace(n)).map(n -> n.trim()).collect(Collectors.toSet());
        Set allMetadataNamespaces = this.metadataRegistry.getAll().stream().map(metadata -> metadata.getUID().getNamespace()).distinct().collect(Collectors.toSet());
        String namespacePattern = originalNamespaces.stream().collect(Collectors.joining("|"));
        Pattern pattern = Pattern.compile("(" + namespacePattern + ")$");
        Set metadataNamespaces = allMetadataNamespaces.stream().filter(n -> !this.metadataRegistry.isInternalNamespace(n)).filter(pattern.asPredicate()).collect(Collectors.toSet());
        HashSet result = new HashSet(originalNamespaces);
        result.addAll(metadataNamespaces);
        return result.stream().filter(namespace -> namespace.matches("[\\w-]*")).collect(Collectors.toSet());
    }
}

