/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.openhab.core.io.rest.core.internal.GsonMessageBodyReader;
import org.openhab.core.io.rest.core.internal.GsonMessageBodyWriter;
import org.openhab.core.io.rest.core.internal.PlainMessageBodyReader;
import org.openhab.core.io.rest.core.internal.PlainMessageBodyWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsExtension;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsMediaType;

@Component(scope=ServiceScope.PROTOTYPE)
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JaxrsExtension
@JaxrsMediaType(value={"application/json", "text/plain"})
public class MediaTypeExtension<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private final Map<String, MessageBodyReader<T>> readers = new HashMap<String, MessageBodyReader<T>>();
    private final Map<String, MessageBodyWriter<T>> writers = new HashMap<String, MessageBodyWriter<T>>();

    private static String mediaTypeWithoutParams(MediaType mediaType) {
        return String.valueOf(mediaType.getType()) + "/" + mediaType.getSubtype();
    }

    public MediaTypeExtension() {
        Gson gson = new GsonBuilder().create();
        this.readers.put(MediaTypeExtension.mediaTypeWithoutParams(MediaType.APPLICATION_JSON_TYPE), new GsonMessageBodyReader(gson));
        this.readers.put(MediaTypeExtension.mediaTypeWithoutParams(MediaType.TEXT_PLAIN_TYPE), new PlainMessageBodyReader());
        this.writers.put(MediaTypeExtension.mediaTypeWithoutParams(MediaType.APPLICATION_JSON_TYPE), new GsonMessageBodyWriter(gson));
        this.writers.put(MediaTypeExtension.mediaTypeWithoutParams(MediaType.TEXT_PLAIN_TYPE), new PlainMessageBodyWriter());
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyWriter<T> writer = this.writers.get(MediaTypeExtension.mediaTypeWithoutParams(mediaType));
        return writer != null && writer.isWriteable(type, genericType, annotations, mediaType);
    }

    public void writeTo(T object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        MessageBodyWriter<T> writer = this.writers.get(MediaTypeExtension.mediaTypeWithoutParams(mediaType));
        if (writer == null) {
            throw new InternalServerErrorException("unsupported media type");
        }
        writer.writeTo(object, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyReader<T> reader = this.readers.get(MediaTypeExtension.mediaTypeWithoutParams(mediaType));
        return reader != null && reader.isReadable(type, genericType, annotations, mediaType);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MessageBodyReader<T> reader = this.readers.get(MediaTypeExtension.mediaTypeWithoutParams(mediaType));
        if (reader != null) {
            return (T)reader.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        throw new InternalServerErrorException("unsupported media type");
    }
}

