/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.semantics;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.model.yaml.AbstractYamlFile;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlModelListener;
import org.openhab.core.model.yaml.internal.semantics.YamlSemanticTag;
import org.openhab.core.model.yaml.internal.semantics.YamlSemanticTags;
import org.openhab.core.semantics.SemanticTag;
import org.openhab.core.semantics.SemanticTagImpl;
import org.openhab.core.semantics.SemanticTagProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={SemanticTagProvider.class, YamlSemanticTagProvider.class, YamlModelListener.class})
public class YamlSemanticTagProvider
extends AbstractProvider<SemanticTag>
implements SemanticTagProvider,
YamlModelListener<YamlSemanticTag> {
    private final Logger logger = LoggerFactory.getLogger(YamlSemanticTagProvider.class);
    private final Set<SemanticTag> tags = new TreeSet<SemanticTag>(Comparator.comparing(Identifiable::getUID));

    @Activate
    public YamlSemanticTagProvider() {
    }

    @Deactivate
    public void deactivate() {
        this.tags.clear();
    }

    public Collection<SemanticTag> getAll() {
        return this.tags;
    }

    @Override
    public String getRootName() {
        return "tags";
    }

    @Override
    public Class<? extends AbstractYamlFile> getFileClass() {
        return YamlSemanticTags.class;
    }

    @Override
    public Class<YamlSemanticTag> getElementClass() {
        return YamlSemanticTag.class;
    }

    @Override
    public void addedModel(String modelName, Collection<? extends YamlElement> elements) {
        List<SemanticTag> added = elements.stream().map(e -> this.mapSemanticTag((YamlSemanticTag)e)).sorted(Comparator.comparing(Identifiable::getUID)).toList();
        this.tags.addAll(added);
        added.forEach(t -> {
            this.logger.debug("model {} added tag {}", (Object)modelName, t.getUID());
            this.notifyListenersAboutAddedElement(t);
        });
    }

    @Override
    public void updatedModel(String modelName, Collection<? extends YamlElement> elements) {
        List<SemanticTag> updated = elements.stream().map(e -> this.mapSemanticTag((YamlSemanticTag)e)).toList();
        updated.forEach(t -> this.tags.stream().filter(tag -> ((String)tag.getUID()).equals(t.getUID())).findFirst().ifPresentOrElse(oldTag -> {
            this.tags.remove(oldTag);
            this.tags.add((SemanticTag)t);
            this.logger.debug("model {} updated tag {}", (Object)modelName, t.getUID());
            this.notifyListenersAboutUpdatedElement(oldTag, t);
        }, () -> this.logger.debug("model {} tag {} not found", (Object)modelName, t.getUID())));
    }

    @Override
    public void removedModel(String modelName, Collection<? extends YamlElement> elements) {
        List<SemanticTag> removed = elements.stream().map(e -> this.mapSemanticTag((YamlSemanticTag)e)).sorted(Comparator.comparing(Identifiable::getUID).reversed()).toList();
        removed.forEach(t -> this.tags.stream().filter(tag -> ((String)tag.getUID()).equals(t.getUID())).findFirst().ifPresentOrElse(oldTag -> {
            this.tags.remove(oldTag);
            this.logger.debug("model {} removed tag {}", (Object)modelName, t.getUID());
            this.notifyListenersAboutRemovedElement(oldTag);
        }, () -> this.logger.debug("model {} tag {} not found", (Object)modelName, t.getUID())));
    }

    private SemanticTag mapSemanticTag(YamlSemanticTag tagDTO) {
        if (tagDTO.uid == null) {
            throw new IllegalArgumentException("The argument 'tagDTO.uid' must not be null.");
        }
        return new SemanticTagImpl(tagDTO.uid, tagDTO.label, tagDTO.description, tagDTO.synonyms);
    }
}

