/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.model.yaml.AbstractYamlFile;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlModelListener;
import org.openhab.core.model.yaml.YamlParseException;
import org.openhab.core.service.WatchService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true)
public class YamlModelRepository
implements WatchService.WatchEventListener {
    private final Logger logger = LoggerFactory.getLogger(YamlModelRepository.class);
    private final WatchService watchService;
    private final Path watchPath;
    private final ObjectMapper yamlReader;
    private final Map<String, List<YamlModelListener<?>>> listeners = new ConcurrentHashMap();
    private final Map<Path, List<? extends YamlElement>> objects = new ConcurrentHashMap<Path, List<? extends YamlElement>>();

    @Activate
    public YamlModelRepository(@Reference(target="(watchservice.name=configWatcher)") WatchService watchService) {
        this.watchService = watchService;
        this.yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.yamlReader.findAndRegisterModules();
        watchService.registerListener((WatchService.WatchEventListener)this, Path.of("", new String[0]));
        this.watchPath = watchService.getWatchPath();
    }

    @Deactivate
    public void deactivate() {
        this.watchService.unregisterListener((WatchService.WatchEventListener)this);
    }

    public synchronized void processWatchEvent(WatchService.Kind kind, Path path) {
        Path fullPath = this.watchPath.resolve(path);
        String dirName = path.subpath(0, 1).toString();
        if (Files.isDirectory(fullPath, new LinkOption[0]) || fullPath.toFile().isHidden() || !fullPath.toString().endsWith(".yaml")) {
            this.logger.trace("Ignored {}", (Object)fullPath);
            return;
        }
        this.getListeners(dirName).forEach(listener -> this.processWatchEvent(dirName, kind, fullPath, (YamlModelListener<?>)listener));
    }

    private void processWatchEvent(String dirName, WatchService.Kind kind, Path fullPath, YamlModelListener<?> listener) {
        Map<String, YamlElement> oldObjects;
        Map<Object, Object> newObjects;
        this.logger.debug("processWatchEvent dirName={} kind={} fullPath={} listener={}", new Object[]{dirName, kind, fullPath, listener.getClass().getSimpleName()});
        if (kind == WatchService.Kind.DELETE) {
            newObjects = Map.of();
            List<YamlElement> oldListObjects = this.objects.remove(fullPath);
            if (oldListObjects == null) {
                oldListObjects = List.of();
            }
            oldObjects = oldListObjects.stream().collect(Collectors.toMap(YamlElement::getId, obj -> obj));
        } else {
            AbstractYamlFile yamlData;
            try {
                yamlData = this.readYamlFile(fullPath, listener.getFileClass());
            }
            catch (YamlParseException e) {
                this.logger.warn("Failed to parse Yaml file {} with DTO class {}: {}", new Object[]{fullPath, listener.getFileClass().getName(), e.getMessage()});
                return;
            }
            List<? extends YamlElement> newListObjects = yamlData.getElements();
            newObjects = newListObjects.stream().collect(Collectors.toMap(YamlElement::getId, obj -> obj));
            List<YamlElement> oldListObjects = this.objects.get(fullPath);
            if (oldListObjects == null) {
                oldListObjects = List.of();
            }
            oldObjects = oldListObjects.stream().collect(Collectors.toMap(YamlElement::getId, obj -> obj));
            this.objects.put(fullPath, newListObjects);
        }
        String modelName = fullPath.toFile().getName();
        modelName = modelName.substring(0, modelName.indexOf(".yaml"));
        List<YamlElement> listElements = oldObjects.entrySet().stream().filter(entry -> ((YamlElement)entry.getValue()).getClass().equals(listener.getElementClass()) && !newObjects.containsKey(entry.getKey())).map(Map.Entry::getValue).toList();
        if (!listElements.isEmpty()) {
            listener.removedModel(modelName, listElements);
        }
        if (!(listElements = newObjects.entrySet().stream().filter(entry -> ((YamlElement)entry.getValue()).getClass().equals(listener.getElementClass()) && !oldObjects.containsKey(entry.getKey())).map(Map.Entry::getValue).toList()).isEmpty()) {
            listener.addedModel(modelName, listElements);
        }
        if (!(listElements = newObjects.entrySet().stream().filter(entry -> ((YamlElement)entry.getValue()).getClass().equals(listener.getElementClass()) && oldObjects.containsKey(entry.getKey()) && !((YamlElement)entry.getValue()).equals(oldObjects.get(entry.getKey()))).map(Map.Entry::getValue).toList()).isEmpty()) {
            listener.updatedModel(modelName, listElements);
        }
    }

    private AbstractYamlFile readYamlFile(Path path, Class<? extends AbstractYamlFile> dtoClass) throws YamlParseException {
        this.logger.info("Loading model '{}'", (Object)path.toFile().getName());
        this.logger.debug("readYamlFile {} with {}", (Object)path.toFile().getAbsolutePath(), (Object)dtoClass.getName());
        try {
            AbstractYamlFile dto = (AbstractYamlFile)this.yamlReader.readValue(path.toFile(), dtoClass);
            if (!dto.isValid()) {
                throw new YamlParseException("The file is not valid, some checks failed!");
            }
            return dto;
        }
        catch (IOException e) {
            throw new YamlParseException(e);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addYamlModelListener(YamlModelListener<?> listener) {
        String dirName = listener.getRootName();
        this.logger.debug("Adding model listener for {}", (Object)dirName);
        this.getListeners(dirName).add(listener);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<Path> stream = Files.walk(this.watchPath.resolve(dirName), new FileVisitOption[0]);){
                stream.forEach(path -> {
                    if (!Files.isDirectory(path, new LinkOption[0]) && !path.toFile().isHidden() && path.toString().endsWith(".yaml")) {
                        this.processWatchEvent(dirName, WatchService.Kind.CREATE, (Path)path, listener);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void removeYamlModelListener(YamlModelListener<?> listener) {
        String dirName = listener.getRootName();
        this.logger.debug("Removing model listener for {}", (Object)dirName);
        this.getListeners(dirName).remove(listener);
    }

    private List<YamlModelListener<?>> getListeners(String dirName) {
        return Objects.requireNonNull(this.listeners.computeIfAbsent(dirName, k -> new CopyOnWriteArrayList()));
    }
}

