/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractYamlFile
implements YamlFile {
    private final Logger logger = LoggerFactory.getLogger(AbstractYamlFile.class);
    public int version;

    @Override
    public abstract List<? extends YamlElement> getElements();

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isValid() {
        List<? extends YamlElement> elts = this.getElements();
        long nbDistinctIds = elts.stream().map(YamlElement::getId).distinct().count();
        if (nbDistinctIds < (long)elts.size()) {
            this.logger.debug("Elements with same ids detected in the file");
            return false;
        }
        int i = 0;
        while (i < elts.size()) {
            if (!elts.get(i).isValid()) {
                this.logger.debug("Error in element {}", (Object)(i + 1));
                return false;
            }
            ++i;
        }
        return true;
    }
}

