/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiServletContext
implements ServletContext {
    public static final Logger LOG = LoggerFactory.getLogger(OsgiServletContext.class);
    private ServletContext containerServletContext;
    private final OsgiContextModel osgiContextModel;
    private final ServletContextModel servletContextModel;
    private final ClassLoader classLoader;
    private final WebContainerContext defaultWebContainerContext;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private String[] welcomeFiles;
    private boolean welcomeFilesRedirect = false;
    private ServiceRegistration<ServletContext> registration;
    private final List<ServletContextAttributeListener> attributeListeners = new CopyOnWriteArrayList<ServletContextAttributeListener>();
    private final SessionCookieConfig defaultSessionCookieConfig;
    private final Set<String> attributesToClearBeforeRestart = new HashSet<String>();
    private boolean acceptsServletContextListeners = true;

    public OsgiServletContext(ServletContext containerServletContext, OsgiContextModel osgiContextModel, ServletContextModel servletContextModel, SessionCookieConfig defaultSessionCookieConfig, ClassLoader loader) {
        this.containerServletContext = containerServletContext;
        this.osgiContextModel = osgiContextModel;
        this.servletContextModel = servletContextModel;
        Bundle ownerBundle = osgiContextModel.getOwnerBundle();
        this.defaultWebContainerContext = osgiContextModel.resolveHttpContext(ownerBundle);
        if (ownerBundle != null && ownerBundle.getBundleContext() != null) {
            this.attributes.put("osgi-bundlecontext", ownerBundle.getBundleContext());
            this.attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", ownerBundle.getBundleContext());
        }
        this.attributes.putAll(osgiContextModel.getInitialContextAttributes());
        this.defaultSessionCookieConfig = defaultSessionCookieConfig;
        this.classLoader = loader == null ? (ownerBundle != null && ownerBundle.adapt(BundleWiring.class) != null ? ((BundleWiring)ownerBundle.adapt(BundleWiring.class)).getClassLoader() : null) : loader;
    }

    public WebContainerContext getResolvedWebContainerContext() {
        return this.defaultWebContainerContext;
    }

    public void register() {
        if (this.registration == null) {
            try {
                BundleContext bc;
                LOG.info("Registering {} as OSGi service for \"{}\" context path", (Object)this, (Object)this.osgiContextModel.getContextPath());
                Bundle bundle = this.osgiContextModel.getOwnerBundle();
                if (bundle == null) {
                    bundle = FrameworkUtil.getBundle(OsgiServletContext.class);
                }
                BundleContext bundleContext = bc = bundle == null ? null : bundle.getBundleContext();
                if (bc != null) {
                    Hashtable<String, String> properties = new Hashtable<String, String>();
                    ((Dictionary)properties).put("osgi.web.symbolicname", bundle.getSymbolicName());
                    ((Dictionary)properties).put("osgi.web.version", bundle.getVersion() == null ? Version.emptyVersion.toString() : bundle.getVersion().toString());
                    ((Dictionary)properties).put("osgi.web.contextpath", this.osgiContextModel.getContextPath());
                    ((Dictionary)properties).put("osgi.web.contextname", this.osgiContextModel.getName());
                    this.registration = bc.registerService(ServletContext.class, (Object)this, properties);
                }
            }
            catch (Exception e) {
                LOG.error("Error registering {} as OSGi service: {}", new Object[]{this, e.getMessage(), e});
            }
        }
    }

    public void unregister() {
        if (this.registration != null) {
            try {
                LOG.info("Unegistering {} as OSGi service for \"{}\" context path", (Object)this, (Object)this.osgiContextModel.getContextPath());
                this.registration.unregister();
            }
            catch (Exception e) {
                if (this.osgiContextModel.getOwnerBundle().getState() == 32) {
                    LOG.error("Error unregistering {} from OSGi registry: {}", new Object[]{this, e.getMessage(), e});
                }
            }
            finally {
                this.registration = null;
            }
        }
    }

    public void releaseWebContainerContext() {
        this.osgiContextModel.releaseHttpContext(this.osgiContextModel.getOwnerBundle());
    }

    public Set<String> getAttributesToClearBeforeRestart() {
        return this.attributesToClearBeforeRestart;
    }

    public void clearAttributesFromPreviousCycle() {
        for (String name : this.attributesToClearBeforeRestart) {
            this.removeAttribute(name);
        }
        this.attributesToClearBeforeRestart.clear();
        this.attributes.clear();
        Bundle ownerBundle = this.osgiContextModel.getOwnerBundle();
        if (ownerBundle != null && ownerBundle.getBundleContext() != null) {
            this.attributes.put("osgi-bundlecontext", ownerBundle.getBundleContext());
            this.attributes.put("org.springframework.osgi.web.org.osgi.framework.BundleContext", ownerBundle.getBundleContext());
        }
        this.attributes.putAll(this.osgiContextModel.getInitialContextAttributes());
    }

    public OsgiContextModel getOsgiContextModel() {
        return this.osgiContextModel;
    }

    public ServletContextModel getServletContextModel() {
        return this.servletContextModel;
    }

    public void setContainerServletContext(ServletContext containerServletContext) {
        this.containerServletContext = containerServletContext;
    }

    public ServletContext getContainerServletContext() {
        return this.containerServletContext;
    }

    public String[] getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void setWelcomeFiles(String[] welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
    }

    public boolean isWelcomeFilesRedirect() {
        return this.welcomeFilesRedirect;
    }

    public void setWelcomeFilesRedirect(boolean redirect) {
        this.welcomeFilesRedirect = redirect;
    }

    public void noMoreServletContextListeners() {
        this.acceptsServletContextListeners = false;
    }

    public boolean acceptsServletContextListeners() {
        return this.acceptsServletContextListeners;
    }

    public void allowServletContextListeners() {
        this.acceptsServletContextListeners = true;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException("addFilter() is not supported.");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException("addFilter() is not supported.");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException("addFilter() is not supported.");
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException("addListener() is not supported.");
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException("addListener() is not supported.");
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException("addListener() is not supported.");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException("addServlet() is not supported.");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException("addServlet() is not supported.");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException("addServlet() is not supported.");
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("createFilter() is not supported.");
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("createListener() is not supported.");
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("createServlet() is not supported.");
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException("declareRoles() is not supported.");
    }

    public boolean setInitParameter(String name, String value) {
        throw new UnsupportedOperationException("setInitParameter() is not supported.");
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException("setSessionTrackingModes() is not supported.");
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new UnsupportedOperationException("addJspFile() is not supported.");
    }

    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (value == null) {
            value = this.containerServletContext.getAttribute(name);
        }
        return value;
    }

    public Enumeration<String> getAttributeNames() {
        LinkedHashSet keys = new LinkedHashSet();
        Enumeration e = this.containerServletContext.getAttributeNames();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        keys.addAll(this.attributes.keySet());
        return Collections.enumeration(keys);
    }

    public void setAttribute(String name, Object object) {
        Object oldValue = this.attributes.get(name);
        if (object == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, object);
        }
        if (!this.attributeListeners.isEmpty()) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, oldValue == null ? object : oldValue);
            for (ServletContextAttributeListener l : this.attributeListeners) {
                if (oldValue == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (object == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this.attributes.get(name);
        this.attributes.remove(name);
        if (oldValue != null && !this.attributeListeners.isEmpty()) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, oldValue);
            for (ServletContextAttributeListener l : this.attributeListeners) {
                l.attributeRemoved(event);
            }
        }
    }

    public void addServletContextAttributeListener(ServletContextAttributeListener eventListener) {
        this.attributeListeners.add(eventListener);
    }

    public void removeServletContextAttributeListener(ServletContextAttributeListener eventListener) {
        this.attributeListeners.remove(eventListener);
    }

    public String getContextPath() {
        String contextPath = this.osgiContextModel.getContextPath();
        if ("/".equals(contextPath)) {
            return "";
        }
        return contextPath;
    }

    public ServletContext getContext(String uripath) {
        return this.containerServletContext.getContext(uripath);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.containerServletContext.getDefaultSessionTrackingModes();
    }

    public int getEffectiveMajorVersion() {
        return this.containerServletContext.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.containerServletContext.getEffectiveMinorVersion();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.containerServletContext.getEffectiveSessionTrackingModes();
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.containerServletContext.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.containerServletContext.getFilterRegistrations();
    }

    public int getMajorVersion() {
        return this.containerServletContext.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.containerServletContext.getMinorVersion();
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.containerServletContext.getServlet(name);
    }

    public Enumeration<String> getServletNames() {
        return this.containerServletContext.getServletNames();
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.containerServletContext.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.containerServletContext.getServletRegistrations();
    }

    public Enumeration<Servlet> getServlets() {
        return this.containerServletContext.getServlets();
    }

    public String getVirtualServerName() {
        return this.containerServletContext.getVirtualServerName();
    }

    public String getServerInfo() {
        return this.containerServletContext.getServerInfo();
    }

    public void log(String msg) {
        this.containerServletContext.log(msg);
    }

    public void log(Exception exception, String msg) {
        this.containerServletContext.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.containerServletContext.log(message, throwable);
    }

    public SessionCookieConfig getSessionCookieConfig() {
        SessionCookieConfig scc = this.osgiContextModel.getSessionConfiguration().getSessionCookieConfig();
        if (scc == null) {
            return this.defaultSessionCookieConfig;
        }
        return scc;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.osgiContextModel.getJspConfigDescriptor();
    }

    public int getSessionTimeout() {
        return this.osgiContextModel.getSessionConfiguration().getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.containerServletContext.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        return this.containerServletContext.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        this.containerServletContext.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        return this.containerServletContext.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        this.containerServletContext.setResponseCharacterEncoding(encoding);
    }

    public String getMimeType(String file) {
        return this.getMimeType(this.defaultWebContainerContext, file);
    }

    public String getMimeType(WebContainerContext context, String file) {
        String mimeType = context.getMimeType(file);
        if (mimeType == null) {
            mimeType = this.containerServletContext.getMimeType(file);
        }
        return mimeType;
    }

    public String getRealPath(String path) {
        return this.getRealPath(this.defaultWebContainerContext, path);
    }

    public String getRealPath(WebContainerContext context, String path) {
        return context.getRealPath(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.getResource(this.defaultWebContainerContext, path);
    }

    public URL getResource(WebContainerContext context, String path) throws MalformedURLException {
        Map mapping = (Map)this.osgiContextModel.getInitialContextAttributes().get("org.ops4j.pax.web.javax.faces.FACELETS_LIBRARIES");
        if (mapping != null && mapping.containsKey(path)) {
            return (URL)mapping.get(path);
        }
        return context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getResourceAsStream(this.defaultWebContainerContext, path);
    }

    public InputStream getResourceAsStream(WebContainerContext context, String path) {
        URL resource = context.getResource(path);
        if (resource != null) {
            try {
                return resource.openStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    public Set<String> getResourcePaths(String path) {
        return this.getResourcePaths(this.defaultWebContainerContext, path);
    }

    public Set<String> getResourcePaths(WebContainerContext context, String path) {
        return context.getResourcePaths(path);
    }

    public String getInitParameter(String name) {
        String param = this.osgiContextModel.getContextParams().get(name);
        if (param == null) {
            param = this.containerServletContext.getInitParameter(name);
        }
        return param;
    }

    public Enumeration<String> getInitParameterNames() {
        LinkedHashSet keys = new LinkedHashSet();
        Enumeration e = this.containerServletContext.getInitParameterNames();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        keys.addAll(this.osgiContextModel.getContextParams().keySet());
        return Collections.enumeration(keys);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.containerServletContext.getRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (this.osgiContextModel.isWab()) {
            return this.containerServletContext.getNamedDispatcher(name);
        }
        ServletModel servletModel = this.servletContextModel.getServletNameMapping().get(name);
        if (servletModel == null) {
            return null;
        }
        if (servletModel.getContextModels().contains(this.osgiContextModel)) {
            return this.containerServletContext.getNamedDispatcher(name);
        }
        return null;
    }

    public String getServletContextName() {
        return this.osgiContextModel.getName();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String toString() {
        return "OsgiServletContext{model=" + this.osgiContextModel + "}";
    }
}

