/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mqtt.reconnect;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.mqtt.MqttBrokerConnection;
import org.openhab.core.io.transport.mqtt.reconnect.AbstractReconnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class PeriodicReconnectStrategy
extends AbstractReconnectStrategy {
    private final Logger logger = LoggerFactory.getLogger(PeriodicReconnectStrategy.class);
    private final int reconnectFrequency;
    private final int firstReconnectAfter;
    private @Nullable ScheduledExecutorService scheduler = null;
    private @Nullable ScheduledFuture<?> scheduledTask;

    public PeriodicReconnectStrategy() {
        this(60000, 10000);
    }

    public PeriodicReconnectStrategy(int reconnectFrequency, int firstReconnectAfter) {
        this.reconnectFrequency = reconnectFrequency;
        this.firstReconnectAfter = firstReconnectAfter;
    }

    @Override
    public synchronized void start() {
        if (this.scheduler == null) {
            this.scheduler = Executors.newScheduledThreadPool(1);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
            this.scheduledTask = null;
        }
    }

    public synchronized boolean isStarted() {
        return this.scheduler != null;
    }

    @Override
    public synchronized void lostConnection() {
        if (this.scheduler == null) {
            return;
        }
        if (this.brokerConnection == null) {
            this.stop();
            return;
        }
        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
            return;
        }
        assert (this.scheduler != null);
        this.scheduledTask = this.scheduler.scheduleWithFixedDelay(() -> {
            MqttBrokerConnection brokerConnection = this.brokerConnection;
            if (brokerConnection == null) {
                this.stop();
                return;
            }
            this.logger.info("Try to restore connection to '{}'. Next attempt in {}ms", (Object)brokerConnection.getHost(), (Object)this.getReconnectFrequency());
            brokerConnection.start().exceptionally(e -> {
                this.logger.warn("Broker connection couldn't be started", e);
                return false;
            });
        }, this.getFirstReconnectAfter(), this.getReconnectFrequency(), TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void connectionEstablished() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
            this.scheduledTask = null;
        }
    }

    @Override
    public synchronized boolean isReconnecting() {
        return this.scheduledTask != null;
    }

    public int getReconnectFrequency() {
        return this.reconnectFrequency;
    }

    public int getFirstReconnectAfter() {
        return this.firstReconnectAfter;
    }
}

