/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mqtt;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.mqtt.MqttBrokerConnection;

@NonNullByDefault
public class MqttBrokerConnectionConfig {
    public @Nullable String name;
    public @Nullable String host;
    public @Nullable Integer port;
    public boolean secure = true;
    public boolean hostnameValidated = true;
    public MqttBrokerConnection.Protocol protocol = MqttBrokerConnection.DEFAULT_PROTOCOL;
    public MqttBrokerConnection.MqttVersion mqttVersion = MqttBrokerConnection.DEFAULT_MQTT_VERSION;
    public @Nullable String username;
    public @Nullable String password;
    public @Nullable String clientID;
    public Integer qos = 0;
    public @Nullable Integer keepAlive;
    public @Nullable String lwtTopic;
    public @Nullable String lwtMessage;
    public Integer lwtQos = 0;
    public Boolean lwtRetain = false;

    public String getBrokerID() {
        Integer port;
        String name = this.name;
        if (name != null && name.length() > 0) {
            return name;
        }
        StringBuilder b = new StringBuilder();
        if (this.host != null) {
            b.append(this.host);
        }
        if ((port = this.port) != null) {
            b.append(":");
            b.append(port.toString());
        }
        if (this.secure) {
            b.append(":s");
        }
        return b.toString();
    }

    public String toString() {
        Integer port;
        StringBuilder b = new StringBuilder();
        if (this.name != null) {
            b.append(this.name);
            b.append(", ");
        }
        if (this.host != null) {
            b.append(this.host);
        }
        if ((port = this.port) != null) {
            b.append(":");
            b.append(port.toString());
        }
        if (this.secure) {
            b.append(":s");
        }
        if (this.hostnameValidated) {
            b.append(":v");
        }
        return b.toString();
    }
}

