/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mqtt;

import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.mqtt.MqttConnectionObserver;
import org.openhab.core.io.transport.mqtt.MqttConnectionState;
import org.openhab.core.io.transport.mqtt.MqttException;
import org.openhab.core.io.transport.mqtt.MqttMessageSubscriber;
import org.openhab.core.io.transport.mqtt.MqttWillAndTestament;
import org.openhab.core.io.transport.mqtt.internal.Subscription;
import org.openhab.core.io.transport.mqtt.internal.client.Mqtt3AsyncClientWrapper;
import org.openhab.core.io.transport.mqtt.internal.client.Mqtt5AsyncClientWrapper;
import org.openhab.core.io.transport.mqtt.internal.client.MqttAsyncClientWrapper;
import org.openhab.core.io.transport.mqtt.reconnect.AbstractReconnectStrategy;
import org.openhab.core.io.transport.mqtt.reconnect.PeriodicReconnectStrategy;
import org.openhab.core.io.transport.mqtt.ssl.CustomTrustManagerFactory;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class MqttBrokerConnection {
    final Logger logger = LoggerFactory.getLogger(MqttBrokerConnection.class);
    public static final Protocol DEFAULT_PROTOCOL = Protocol.TCP;
    public static final MqttVersion DEFAULT_MQTT_VERSION = MqttVersion.V3;
    public static final int DEFAULT_KEEPALIVE_INTERVAL = 60;
    public static final int DEFAULT_QOS = 0;
    protected final Protocol protocol;
    protected final String host;
    protected final int port;
    protected final boolean secure;
    protected final boolean hostnameValidated;
    protected final MqttVersion mqttVersion;
    private @Nullable TrustManagerFactory trustManagerFactory = InsecureTrustManagerFactory.INSTANCE;
    protected final String clientId;
    private @Nullable String user;
    private @Nullable String password;
    private int qos = 0;
    private @Nullable MqttWillAndTestament lastWill;
    protected @Nullable AbstractReconnectStrategy reconnectStrategy;
    private int keepAliveInterval = 60;
    protected @Nullable MqttAsyncClientWrapper client;
    protected boolean isConnecting = false;
    protected final List<MqttConnectionObserver> connectionObservers = new CopyOnWriteArrayList<MqttConnectionObserver>();
    protected final Map<String, Subscription> subscribers = new ConcurrentHashMap<String, Subscription>();
    protected final AtomicReference<@Nullable ScheduledFuture<?>> timeoutFuture = new AtomicReference<Object>(null);
    protected @Nullable ScheduledExecutorService timeoutExecutor;
    private int timeout = 1200;
    private boolean unsubscribeOnStop = true;
    protected ConnectionCallback connectionCallback;

    public MqttBrokerConnection(String host, @Nullable Integer port, boolean secure, @Nullable String clientId) {
        this(host, port, secure, true, clientId);
    }

    public MqttBrokerConnection(String host, @Nullable Integer port, boolean secure, boolean hostnameValidated, @Nullable String clientId) {
        this(Protocol.TCP, MqttVersion.V3, host, port, secure, hostnameValidated, clientId);
    }

    public MqttBrokerConnection(Protocol protocol, MqttVersion mqttVersion, String host, @Nullable Integer port, boolean secure, @Nullable String clientId) {
        this(protocol, mqttVersion, host, port, secure, true, clientId);
    }

    public MqttBrokerConnection(Protocol protocol, MqttVersion mqttVersion, String host, @Nullable Integer port, boolean secure, boolean hostnameValidated, @Nullable String clientId) {
        this.protocol = protocol;
        this.host = host;
        this.secure = secure;
        this.hostnameValidated = hostnameValidated;
        this.mqttVersion = mqttVersion;
        String newClientID = clientId;
        if (newClientID == null) {
            newClientID = UUID.randomUUID().toString();
        } else if (newClientID.length() > 65535) {
            throw new IllegalArgumentException("Client ID cannot be longer than 65535 characters");
        }
        if (port != null && (port <= 0 || port > 65535)) {
            throw new IllegalArgumentException("Port is not within a valid range");
        }
        this.port = port != null ? port : (secure ? 8883 : 1883);
        this.clientId = newClientID;
        this.setReconnectStrategy(new PeriodicReconnectStrategy());
        this.connectionCallback = new ConnectionCallback(this);
    }

    public void setReconnectStrategy(AbstractReconnectStrategy reconnectStrategy) {
        this.reconnectStrategy = reconnectStrategy;
        reconnectStrategy.setBrokerConnection(this);
    }

    public @Nullable AbstractReconnectStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    public void setTimeoutExecutor(@Nullable ScheduledExecutorService executor, int timeoutInMS) {
        this.timeoutExecutor = executor;
        this.timeout = timeoutInMS;
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagerFactory = trustManagers.length != 0 ? new CustomTrustManagerFactory(trustManagers) : null;
    }

    public TrustManager[] getTrustManagers() {
        if (this.trustManagerFactory != null) {
            return this.trustManagerFactory.getTrustManagers();
        }
        return new TrustManager[0];
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public MqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHostnameValidated() {
        return this.secure & this.hostnameValidated;
    }

    public void setCredentials(@Nullable String user, @Nullable String password) {
        this.user = user;
        this.password = password;
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public @Nullable String getUser() {
        return this.user;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        if (qos < 0 || qos > 2) {
            throw new IllegalArgumentException();
        }
        this.qos = qos;
    }

    public @Nullable MqttWillAndTestament getLastWill() {
        return this.lastWill;
    }

    public void setLastWill(@Nullable MqttWillAndTestament lastWill, boolean applyImmediately) throws ConfigurationException, MqttException {
        this.lastWill = lastWill;
        if (applyImmediately) {
            this.stop();
            this.start();
        }
    }

    public void setLastWill(@Nullable MqttWillAndTestament lastWill) {
        this.lastWill = lastWill;
    }

    public void setUnsubscribeOnStop(boolean unsubscribeOnStop) {
        this.unsubscribeOnStop = unsubscribeOnStop;
    }

    public String getClientId() {
        return this.clientId;
    }

    public MqttConnectionState connectionState() {
        if (this.isConnecting) {
            return MqttConnectionState.CONNECTING;
        }
        return this.client != null && this.client.getState().isConnected() ? MqttConnectionState.CONNECTED : MqttConnectionState.DISCONNECTED;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        if (keepAliveInterval <= 0) {
            throw new IllegalArgumentException("Keep alive cannot be <=0");
        }
        this.keepAliveInterval = keepAliveInterval;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> subscribe(String topic, MqttMessageSubscriber subscriber) {
        boolean needsSubscribe;
        Subscription subscription;
        Map<String, Subscription> map = this.subscribers;
        synchronized (map) {
            subscription = this.subscribers.computeIfAbsent(topic, t -> new Subscription());
            needsSubscribe = subscription.isEmpty();
            subscription.add(subscriber);
        }
        if (needsSubscribe) {
            return this.subscribeRaw(topic, subscription);
        }
        return CompletableFuture.completedFuture(true);
    }

    protected CompletableFuture<Boolean> subscribeRaw(String topic, Subscription subscription) {
        this.logger.trace("subscribeRaw message consumer for topic '{}' from broker '{}'", (Object)topic, (Object)this.host);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        MqttAsyncClientWrapper mqttClient = this.client;
        if (mqttClient != null && mqttClient.getState().isConnected()) {
            mqttClient.subscribe(topic, this.qos, subscription).whenComplete((s, t) -> {
                if (t == null) {
                    this.logger.trace("Successfully subscribed to topic {}", (Object)topic);
                    future.complete(true);
                } else {
                    this.logger.warn("Failed subscribing to topic {}", (Object)topic, t);
                    future.completeExceptionally(new MqttException((Throwable)t));
                }
            });
        } else {
            future.complete(false);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> unsubscribe(String topic, MqttMessageSubscriber subscriber) {
        MqttAsyncClientWrapper mqttClient;
        boolean needsUnsubscribe;
        Map<String, Subscription> map = this.subscribers;
        synchronized (map) {
            @Nullable Subscription subscription = this.subscribers.get(topic);
            if (subscription == null) {
                this.logger.trace("Tried to unsubscribe {} from topic {}, but subscriber list is empty", (Object)subscriber, (Object)topic);
                return CompletableFuture.completedFuture(true);
            }
            subscription.remove(subscriber);
            if (subscription.isEmpty()) {
                needsUnsubscribe = true;
                this.subscribers.remove(topic);
            } else {
                needsUnsubscribe = false;
            }
        }
        if (needsUnsubscribe && (mqttClient = this.client) != null) {
            this.logger.trace("Subscriber list is empty after removing {}, unsubscribing topic {} from client", (Object)subscriber, (Object)topic);
            return this.unsubscribeRaw(mqttClient, topic);
        }
        return CompletableFuture.completedFuture(true);
    }

    protected CompletableFuture<Boolean> unsubscribeRaw(MqttAsyncClientWrapper client, String topic) {
        this.logger.trace("Unsubscribing message consumer for topic '{}' from broker '{}'", (Object)topic, (Object)this.host);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (!client.getState().isConnected()) {
            return CompletableFuture.completedFuture(false);
        }
        client.unsubscribe(topic).whenComplete((s, t) -> {
            if (t == null) {
                future.complete(true);
            } else {
                future.completeExceptionally(new MqttException((Throwable)t));
            }
        });
        return future;
    }

    public synchronized void addConnectionObserver(MqttConnectionObserver connectionObserver) {
        this.connectionObservers.add(connectionObserver);
    }

    public synchronized void removeConnectionObserver(MqttConnectionObserver connectionObserver) {
        this.connectionObservers.remove(connectionObserver);
    }

    public boolean hasConnectionObservers() {
        return !this.connectionObservers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> start() {
        ScheduledFuture<?> timeoutFuture;
        MqttAsyncClientWrapper client;
        MqttBrokerConnection mqttBrokerConnection = this;
        synchronized (mqttBrokerConnection) {
            if (this.connectionState() != MqttConnectionState.DISCONNECTED) {
                return CompletableFuture.completedFuture(true);
            }
            this.isConnecting = true;
            this.connectionObservers.forEach(o -> o.connectionStateChanged(MqttConnectionState.CONNECTING, null));
        }
        if (this.reconnectStrategy != null) {
            this.reconnectStrategy.start();
        }
        if (this.client != null) {
            this.client.disconnect();
            this.client = null;
        }
        CompletableFuture<Boolean> future = this.connectionCallback.createFuture();
        this.client = client = this.createClient();
        client.connect(this.lastWill, this.keepAliveInterval, this.user, this.password);
        this.logger.info("Starting MQTT broker connection to '{}' with clientid {}", (Object)this.host, (Object)this.getClientId());
        ScheduledExecutorService executor = this.timeoutExecutor;
        if (executor != null && (timeoutFuture = this.timeoutFuture.getAndSet(executor.schedule(() -> this.connectionCallback.onDisconnected(new TimeoutException("connect timed out")), (long)this.timeout, TimeUnit.MILLISECONDS))) != null) {
            timeoutFuture.cancel(false);
        }
        return future;
    }

    protected MqttAsyncClientWrapper createClient() {
        if (this.mqttVersion == MqttVersion.V3) {
            return new Mqtt3AsyncClientWrapper(this.host, this.port, this.clientId, this.protocol, this.secure, this.hostnameValidated, this.connectionCallback, this.trustManagerFactory);
        }
        return new Mqtt5AsyncClientWrapper(this.host, this.port, this.clientId, this.protocol, this.secure, this.hostnameValidated, this.connectionCallback, this.trustManagerFactory);
    }

    protected boolean finalizeStopAfterDisconnect(boolean v) {
        MqttAsyncClientWrapper client = this.client;
        if (client != null && this.connectionState() != MqttConnectionState.DISCONNECTED) {
            client.disconnect();
        }
        this.client = null;
        this.connectionObservers.forEach(o -> o.connectionStateChanged(MqttConnectionState.DISCONNECTED, null));
        return v;
    }

    public CompletableFuture<Void> unsubscribeAll() {
        MqttAsyncClientWrapper client = this.client;
        ArrayList futures = new ArrayList();
        if (client != null) {
            this.subscribers.forEach((topic, subscription) -> futures.add(this.unsubscribeRaw(client, (String)topic)));
            this.subscribers.clear();
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    public CompletableFuture<Boolean> stop() {
        MqttAsyncClientWrapper client = this.client;
        if (client == null) {
            return CompletableFuture.completedFuture(true);
        }
        this.logger.trace("Closing the MQTT broker connection '{}'", (Object)this.host);
        this.isConnecting = false;
        this.cancelTimeoutFuture();
        if (this.reconnectStrategy != null) {
            this.reconnectStrategy.stop();
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (client.getState().isConnected()) {
            if (this.unsubscribeOnStop) {
                this.unsubscribeAll().thenRun(() -> this.doDisconnect(future));
            } else {
                this.doDisconnect(future);
            }
        } else {
            future.complete(true);
        }
        return future.thenApply(this::finalizeStopAfterDisconnect);
    }

    private void doDisconnect(CompletableFuture<Boolean> future) {
        this.client.disconnect().whenComplete((m, t) -> future.complete(t == null));
    }

    public CompletableFuture<Boolean> publish(String topic, byte[] payload, int qos, boolean retain) {
        MqttAsyncClientWrapper client = this.client;
        if (client == null) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        client.publish(topic, payload, retain, qos).whenComplete((m, t) -> {
            if (t == null) {
                future.complete(true);
            } else {
                future.completeExceptionally(new MqttException((Throwable)t));
            }
        });
        return future;
    }

    protected void cancelTimeoutFuture() {
        ScheduledFuture timeoutFuture = this.timeoutFuture.getAndSet(null);
        if (timeoutFuture != null) {
            timeoutFuture.cancel(false);
        }
    }

    public class ConnectionCallback
    implements MqttClientConnectedListener,
    MqttClientDisconnectedListener {
        private final MqttBrokerConnection connection;
        private final Runnable cancelTimeoutFuture;
        private CompletableFuture<Boolean> future = new CompletableFuture();

        public ConnectionCallback(MqttBrokerConnection mqttBrokerConnectionImpl) {
            this.connection = mqttBrokerConnectionImpl;
            this.cancelTimeoutFuture = mqttBrokerConnectionImpl::cancelTimeoutFuture;
        }

        public void onConnected(@Nullable MqttClientConnectedContext context) {
            this.cancelTimeoutFuture.run();
            this.connection.isConnecting = false;
            if (this.connection.reconnectStrategy != null) {
                this.connection.reconnectStrategy.connectionEstablished();
            }
            ArrayList futures = new ArrayList();
            this.connection.subscribers.forEach((topic, subscription) -> futures.add(this.connection.subscribeRaw((String)topic, (Subscription)subscription)));
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> {
                this.future.complete(true);
                this.connection.connectionObservers.forEach(o -> o.connectionStateChanged(this.connection.connectionState(), null));
            });
        }

        public void onDisconnected(@Nullable MqttClientDisconnectedContext context) {
            if (context != null) {
                Throwable throwable = context.getCause();
                this.onDisconnected(throwable);
            } else {
                this.onDisconnected(new Throwable("unknown disconnect reason"));
            }
        }

        public void onDisconnected(Throwable t) {
            this.cancelTimeoutFuture.run();
            this.future.complete(false);
            this.connection.connectionObservers.forEach(o -> o.connectionStateChanged(MqttConnectionState.DISCONNECTED, t));
            if (this.connection.isConnecting) {
                this.connection.isConnecting = false;
            }
            if (this.connection.reconnectStrategy != null) {
                this.connection.reconnectStrategy.lostConnection();
            }
        }

        public CompletableFuture<Boolean> createFuture() {
            this.future = new CompletableFuture();
            return this.future;
        }
    }

    public static enum MqttVersion {
        V3,
        V5;

    }

    public static enum Protocol {
        TCP,
        WEBSOCKETS;

    }
}

