/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.icon;

import java.io.InputStream;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.ui.icon.IconProvider;
import org.openhab.core.ui.icon.IconSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractResourceIconProvider
implements IconProvider {
    private final Logger logger = LoggerFactory.getLogger(AbstractResourceIconProvider.class);
    protected final TranslationProvider i18nProvider;

    public AbstractResourceIconProvider(TranslationProvider i18nProvider) {
        this.i18nProvider = i18nProvider;
    }

    @Override
    public Set<IconSet> getIconSets() {
        return this.getIconSets(null);
    }

    @Override
    public @Nullable Integer hasIcon(String category, String iconSetId, IconSet.Format format) {
        return this.hasResource(iconSetId, String.valueOf(category.toLowerCase()) + "." + format.toString().toLowerCase()) ? this.getPriority() : null;
    }

    @Override
    public @Nullable InputStream getIcon(String category, String iconSetId, @Nullable String state, IconSet.Format format) {
        String resourceWithState;
        String iconState;
        String resourceWithoutState = String.valueOf(category.toLowerCase()) + "." + format.toString().toLowerCase();
        if (state == null) {
            return this.getResource(iconSetId, resourceWithoutState);
        }
        if (state.contains(" ")) {
            try {
                String firstPart = state.substring(0, state.indexOf(" "));
                Double.valueOf(firstPart);
                iconState = firstPart;
            }
            catch (NumberFormatException e) {
                iconState = state;
            }
        } else {
            iconState = state;
        }
        if (this.hasResource(iconSetId, resourceWithState = String.valueOf(category.toLowerCase()) + "-" + iconState.toLowerCase() + "." + format.toString().toLowerCase())) {
            return this.getResource(iconSetId, resourceWithState);
        }
        try {
            Double stateAsDouble = Double.valueOf(iconState);
            if (stateAsDouble >= 0.0 && stateAsDouble <= 100.0) {
                int i = stateAsDouble.intValue();
                while (i >= 0) {
                    String resourceWithNumberState = String.valueOf(category.toLowerCase()) + "-" + i + "." + format.toString().toLowerCase();
                    if (this.hasResource(iconSetId, resourceWithNumberState)) {
                        return this.getResource(iconSetId, resourceWithNumberState);
                    }
                    --i;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.logger.debug("Use icon {} as {} is not found", (Object)resourceWithoutState, (Object)resourceWithState);
        return this.getResource(iconSetId, resourceWithoutState);
    }

    protected abstract Integer getPriority();

    protected abstract @Nullable InputStream getResource(String var1, String var2);

    protected abstract boolean hasResource(String var1, String var2);
}

