/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.CryptoServiceConstraintsException;
import org.bouncycastle.crypto.CryptoServiceProperties;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import org.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.BouncyCastleProviderConfiguration;
import org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle.pqc.jcajce.provider.bike.BIKEKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.cmce.CMCEKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.dilithium.DilithiumKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.falcon.FalconKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.hqc.HQCKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.kyber.KyberKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.lms.LMSKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.newhope.NHKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.ntru.NTRUKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.picnic.PicnicKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.sphincs.Sphincs256KeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.sphincsplus.SPHINCSPlusKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.xmss.XMSSKeyFactorySpi;
import org.bouncycastle.pqc.jcajce.provider.xmss.XMSSMTKeyFactorySpi;
import org.bouncycastle.util.Strings;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static final Logger LOG = Logger.getLogger(BouncyCastleProvider.class.getName());
    private static String info = "BouncyCastle Security Provider v1.76";
    public static final String PROVIDER_NAME = "BC";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final Class revChkClass = ClassUtil.loadClass(BouncyCastleProvider.class, (String)"java.security.cert.PKIXRevocationChecker");
    private static final String SYMMETRIC_PACKAGE = "org.bouncycastle.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF1", "PBEPBKDF2", "PBEPKCS12", "TLSKDF", "SCRYPT"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash", "SipHash128", "Poly1305"};
    private static final CryptoServiceProperties[] SYMMETRIC_CIPHERS = new CryptoServiceProperties[]{BouncyCastleProvider.service((String)"AES", (int)256), BouncyCastleProvider.service((String)"ARC4", (int)20), BouncyCastleProvider.service((String)"ARIA", (int)256), BouncyCastleProvider.service((String)"Blowfish", (int)128), BouncyCastleProvider.service((String)"Camellia", (int)256), BouncyCastleProvider.service((String)"CAST5", (int)128), BouncyCastleProvider.service((String)"CAST6", (int)256), BouncyCastleProvider.service((String)"ChaCha", (int)128), BouncyCastleProvider.service((String)"DES", (int)56), BouncyCastleProvider.service((String)"DESede", (int)112), BouncyCastleProvider.service((String)"GOST28147", (int)128), BouncyCastleProvider.service((String)"Grainv1", (int)128), BouncyCastleProvider.service((String)"Grain128", (int)128), BouncyCastleProvider.service((String)"HC128", (int)128), BouncyCastleProvider.service((String)"HC256", (int)256), BouncyCastleProvider.service((String)"IDEA", (int)128), BouncyCastleProvider.service((String)"Noekeon", (int)128), BouncyCastleProvider.service((String)"RC2", (int)128), BouncyCastleProvider.service((String)"RC5", (int)128), BouncyCastleProvider.service((String)"RC6", (int)256), BouncyCastleProvider.service((String)"Rijndael", (int)256), BouncyCastleProvider.service((String)"Salsa20", (int)128), BouncyCastleProvider.service((String)"SEED", (int)128), BouncyCastleProvider.service((String)"Serpent", (int)256), BouncyCastleProvider.service((String)"Shacal2", (int)128), BouncyCastleProvider.service((String)"Skipjack", (int)80), BouncyCastleProvider.service((String)"SM4", (int)128), BouncyCastleProvider.service((String)"TEA", (int)128), BouncyCastleProvider.service((String)"Twofish", (int)256), BouncyCastleProvider.service((String)"Threefish", (int)128), BouncyCastleProvider.service((String)"VMPC", (int)128), BouncyCastleProvider.service((String)"VMPCKSA3", (int)128), BouncyCastleProvider.service((String)"XTEA", (int)128), BouncyCastleProvider.service((String)"XSalsa20", (int)128), BouncyCastleProvider.service((String)"OpenSSLPBKDF", (int)128), BouncyCastleProvider.service((String)"DSTU7624", (int)256), BouncyCastleProvider.service((String)"GOST3412_2015", (int)256), BouncyCastleProvider.service((String)"Zuc", (int)128)};
    private static final String ASYMMETRIC_PACKAGE = "org.bouncycastle.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES", "COMPOSITE", "EXTERNAL"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "GM", "EdEC", "LMS", "SPHINCSPlus", "Dilithium", "Falcon", "NTRU"};
    private static final String DIGEST_PACKAGE = "org.bouncycastle.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b", "Blake2s", "DSTU7564", "Haraka", "Blake3"};
    private static final String KEYSTORE_PACKAGE = "org.bouncycastle.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "BCFKS", "PKCS12"};
    private static final String SECURE_RANDOM_PACKAGE = "org.bouncycastle.jcajce.provider.drbg.";
    private static final String[] SECURE_RANDOMS = new String[]{"DRBG"};
    private Map<String, Provider.Service> serviceMap = new ConcurrentHashMap();

    public BouncyCastleProvider() {
        super("BC", 1.76, info);
        AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setup() {
        this.loadAlgorithms("org.bouncycastle.jcajce.provider.digest.", DIGESTS);
        this.loadAlgorithms("org.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_GENERIC);
        this.loadAlgorithms("org.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_MACS);
        this.loadAlgorithms("org.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_CIPHERS);
        this.loadAlgorithms("org.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_GENERIC);
        this.loadAlgorithms("org.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_CIPHERS);
        this.loadAlgorithms("org.bouncycastle.jcajce.provider.keystore.", KEYSTORES);
        this.loadAlgorithms("org.bouncycastle.jcajce.provider.drbg.", SECURE_RANDOMS);
        this.loadPQCKeys();
        this.put((Object)"X509Store.CERTIFICATE/COLLECTION", (Object)"org.bouncycastle.jce.provider.X509StoreCertCollection");
        this.put((Object)"X509Store.ATTRIBUTECERTIFICATE/COLLECTION", (Object)"org.bouncycastle.jce.provider.X509StoreAttrCertCollection");
        this.put((Object)"X509Store.CRL/COLLECTION", (Object)"org.bouncycastle.jce.provider.X509StoreCRLCollection");
        this.put((Object)"X509Store.CERTIFICATEPAIR/COLLECTION", (Object)"org.bouncycastle.jce.provider.X509StoreCertPairCollection");
        this.put((Object)"X509Store.CERTIFICATE/LDAP", (Object)"org.bouncycastle.jce.provider.X509StoreLDAPCerts");
        this.put((Object)"X509Store.CRL/LDAP", (Object)"org.bouncycastle.jce.provider.X509StoreLDAPCRLs");
        this.put((Object)"X509Store.ATTRIBUTECERTIFICATE/LDAP", (Object)"org.bouncycastle.jce.provider.X509StoreLDAPAttrCerts");
        this.put((Object)"X509Store.CERTIFICATEPAIR/LDAP", (Object)"org.bouncycastle.jce.provider.X509StoreLDAPCertPairs");
        this.put((Object)"X509StreamParser.CERTIFICATE", (Object)"org.bouncycastle.jce.provider.X509CertParser");
        this.put((Object)"X509StreamParser.ATTRIBUTECERTIFICATE", (Object)"org.bouncycastle.jce.provider.X509AttrCertParser");
        this.put((Object)"X509StreamParser.CRL", (Object)"org.bouncycastle.jce.provider.X509CRLParser");
        this.put((Object)"X509StreamParser.CERTIFICATEPAIR", (Object)"org.bouncycastle.jce.provider.X509CertPairParser");
        this.put((Object)"Cipher.BROKENPBEWITHMD5ANDDES", (Object)"org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put((Object)"Cipher.BROKENPBEWITHSHA1ANDDES", (Object)"org.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put((Object)"Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", (Object)"org.bouncycastle.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        if (revChkClass != null) {
            this.put((Object)"CertPathValidator.RFC3281", (Object)"org.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3281", (Object)"org.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.RFC3280", (Object)"org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put((Object)"CertPathBuilder.RFC3280", (Object)"org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
            this.put((Object)"CertPathValidator.PKIX", (Object)"org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put((Object)"CertPathBuilder.PKIX", (Object)"org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
        } else {
            this.put((Object)"CertPathValidator.RFC3281", (Object)"org.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3281", (Object)"org.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.RFC3280", (Object)"org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3280", (Object)"org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.PKIX", (Object)"org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.PKIX", (Object)"org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        }
        this.put((Object)"CertStore.Collection", (Object)"org.bouncycastle.jce.provider.CertStoreCollectionSpi");
        this.put((Object)"CertStore.LDAP", (Object)"org.bouncycastle.jce.provider.X509LDAPCertStoreSpi");
        this.put((Object)"CertStore.Multi", (Object)"org.bouncycastle.jce.provider.MultiCertStoreSpi");
        this.put((Object)"Alg.Alias.CertStore.X509LDAP", (Object)"LDAP");
        this.getService("SecureRandom", "DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Provider.Service getService(String string, String string2) {
        String string3 = Strings.toUpperCase(string2);
        String string4 = string + "." + string3;
        Provider.Service service = (Provider.Service)this.serviceMap.get(string4);
        if (service == null) {
            BouncyCastleProvider bouncyCastleProvider = this;
            synchronized (bouncyCastleProvider) {
                service = !this.serviceMap.containsKey(string4) ? (Provider.Service)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */) : (Provider.Service)this.serviceMap.get(string4);
            }
        }
        return service;
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            this.loadServiceClass(string, stringArray[i]);
        }
    }

    private void loadAlgorithms(String string, CryptoServiceProperties[] cryptoServicePropertiesArray) {
        for (int i = 0; i != cryptoServicePropertiesArray.length; ++i) {
            CryptoServiceProperties cryptoServiceProperties = cryptoServicePropertiesArray[i];
            try {
                CryptoServicesRegistrar.checkConstraints(cryptoServiceProperties);
                this.loadServiceClass(string, cryptoServiceProperties.getServiceName());
                continue;
            }
            catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("service for " + cryptoServiceProperties.getServiceName() + " ignored due to constraints");
            }
        }
    }

    private void loadServiceClass(String string, String string2) {
        Class clazz = ClassUtil.loadClass(BouncyCastleProvider.class, (String)(string + string2 + "$Mappings"));
        if (clazz != null) {
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure((ConfigurableProvider)this);
            }
            catch (Exception exception) {
                throw new InternalError("cannot create instance of " + string + string2 + "$Mappings : " + exception);
            }
        }
    }

    private void loadPQCKeys() {
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.sphincs256, (AsymmetricKeyInfoConverter)new Sphincs256KeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.newHope, (AsymmetricKeyInfoConverter)new NHKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss, (AsymmetricKeyInfoConverter)new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmss, (AsymmetricKeyInfoConverter)new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss_mt, (AsymmetricKeyInfoConverter)new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmssmt, (AsymmetricKeyInfoConverter)new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, (AsymmetricKeyInfoConverter)new LMSKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.picnic_key, (AsymmetricKeyInfoConverter)new PicnicKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.falcon_512, (AsymmetricKeyInfoConverter)new FalconKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.falcon_1024, (AsymmetricKeyInfoConverter)new FalconKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium2, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium3, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium5, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium2_aes, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium3_aes, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium5_aes, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber512, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber768, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece348864_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece460896_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece6688128_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece6960119_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece8192128_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike128, (AsymmetricKeyInfoConverter)new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike192, (AsymmetricKeyInfoConverter)new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike256, (AsymmetricKeyInfoConverter)new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc128, (AsymmetricKeyInfoConverter)new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc192, (AsymmetricKeyInfoConverter)new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc256, (AsymmetricKeyInfoConverter)new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber512_aes, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber768_aes, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024_aes, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps2048509, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps2048677, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps4096821, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhrss701, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String string, Object object) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((BouncyCastleProviderConfiguration)CONFIGURATION).setParameter(string, object);
        }
    }

    public boolean hasAlgorithm(String string, String string2) {
        return this.containsKey((Object)(string + "." + string2)) || this.containsKey((Object)("Alg.Alias." + string + "." + string2));
    }

    public void addAlgorithm(String string, String string2) {
        if (this.containsKey((Object)string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put((Object)string, (Object)string2);
    }

    public void addAlgorithm(String string, String string2, Map<String, String> map) {
        this.addAlgorithm(string, string2);
        this.addAttributes(string, map);
    }

    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        this.addAlgorithm(string + "." + aSN1ObjectIdentifier, string2);
        this.addAlgorithm(string + ".OID." + aSN1ObjectIdentifier, string2);
    }

    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, Map<String, String> map) {
        this.addAlgorithm(string, aSN1ObjectIdentifier, string2);
        this.addAttributes(string + "." + aSN1ObjectIdentifier, map);
        this.addAttributes(string + ".OID." + aSN1ObjectIdentifier, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
        }
    }

    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
    }

    public void addAttributes(String string, Map<String, String> map) {
        this.put((Object)(string + " ImplementedIn"), (Object)"Software");
        for (String string2 : map.keySet()) {
            String string3 = string + " " + string2;
            if (this.containsKey((Object)string3)) {
                throw new IllegalStateException("duplicate provider attribute key (" + string3 + ") found");
            }
            this.put((Object)string3, (Object)map.get(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        if (subjectPublicKeyInfo.getAlgorithm().getAlgorithm().on(BCObjectIdentifiers.picnic_key)) {
            return new PicnicKeyFactorySpi().generatePublic(subjectPublicKeyInfo);
        }
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter((ASN1ObjectIdentifier)subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter((ASN1ObjectIdentifier)privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }

    private static CryptoServiceProperties service(String string, int n) {
        return new JcaCryptoService(string, n);
    }

    static /* synthetic */ void access$000(BouncyCastleProvider bouncyCastleProvider) {
        bouncyCastleProvider.setup();
    }

    static /* synthetic */ Provider.Service access$101(BouncyCastleProvider bouncyCastleProvider, String string, String string2) {
        return super.getService(string, string2);
    }

    static /* synthetic */ Map access$200(BouncyCastleProvider bouncyCastleProvider) {
        return bouncyCastleProvider.serviceMap;
    }

    static /* synthetic */ Object access$301(BouncyCastleProvider bouncyCastleProvider, Object object) {
        return super.remove(object);
    }

    static /* synthetic */ void access$401(BouncyCastleProvider bouncyCastleProvider, Provider.Service service) {
        super.putService(service);
    }
}

