/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.persistence.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.model.core.EventType;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.core.ModelRepositoryChangeListener;
import org.openhab.core.model.persistence.persistence.AllConfig;
import org.openhab.core.model.persistence.persistence.CronStrategy;
import org.openhab.core.model.persistence.persistence.EqualsFilter;
import org.openhab.core.model.persistence.persistence.Filter;
import org.openhab.core.model.persistence.persistence.FilterDetails;
import org.openhab.core.model.persistence.persistence.GroupConfig;
import org.openhab.core.model.persistence.persistence.IncludeFilter;
import org.openhab.core.model.persistence.persistence.ItemConfig;
import org.openhab.core.model.persistence.persistence.NotEqualsFilter;
import org.openhab.core.model.persistence.persistence.NotIncludeFilter;
import org.openhab.core.model.persistence.persistence.PersistenceConfiguration;
import org.openhab.core.model.persistence.persistence.PersistenceModel;
import org.openhab.core.model.persistence.persistence.Strategy;
import org.openhab.core.model.persistence.persistence.ThresholdFilter;
import org.openhab.core.model.persistence.persistence.TimeFilter;
import org.openhab.core.persistence.PersistenceItemConfiguration;
import org.openhab.core.persistence.config.PersistenceAllConfig;
import org.openhab.core.persistence.config.PersistenceGroupConfig;
import org.openhab.core.persistence.config.PersistenceItemConfig;
import org.openhab.core.persistence.filter.PersistenceEqualsFilter;
import org.openhab.core.persistence.filter.PersistenceFilter;
import org.openhab.core.persistence.filter.PersistenceIncludeFilter;
import org.openhab.core.persistence.filter.PersistenceThresholdFilter;
import org.openhab.core.persistence.filter.PersistenceTimeFilter;
import org.openhab.core.persistence.registry.PersistenceServiceConfiguration;
import org.openhab.core.persistence.registry.PersistenceServiceConfigurationProvider;
import org.openhab.core.persistence.strategy.PersistenceCronStrategy;
import org.openhab.core.persistence.strategy.PersistenceStrategy;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PersistenceServiceConfigurationProvider.class})
@NonNullByDefault
public class PersistenceModelManager
extends AbstractProvider<PersistenceServiceConfiguration>
implements ModelRepositoryChangeListener,
PersistenceServiceConfigurationProvider {
    private final Logger logger = LoggerFactory.getLogger(PersistenceModelManager.class);
    private final Map<String, PersistenceServiceConfiguration> configurations = new ConcurrentHashMap<String, PersistenceServiceConfiguration>();
    private final ModelRepository modelRepository;

    @Activate
    public PersistenceModelManager(@Reference ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        modelRepository.getAllModelNamesOfType("persist").forEach(modelName -> this.modelChanged((String)modelName, EventType.ADDED));
    }

    @Deactivate
    protected void deactivate() {
        this.modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.modelRepository.getAllModelNamesOfType("persist").forEach(modelName -> this.modelChanged((String)modelName, EventType.REMOVED));
    }

    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith(".persist")) {
            String serviceName = this.serviceName(modelName);
            if (type == EventType.REMOVED) {
                PersistenceServiceConfiguration removed = this.configurations.remove(serviceName);
                this.notifyListenersAboutRemovedElement(removed);
            } else {
                PersistenceModel model = (PersistenceModel)this.modelRepository.getModel(modelName);
                if (model != null) {
                    PersistenceServiceConfiguration newConfiguration = new PersistenceServiceConfiguration(serviceName, this.mapConfigs((List<PersistenceConfiguration>)model.getConfigs()), this.mapStrategies((List<Strategy>)model.getDefaults()), this.mapStrategies((List<Strategy>)model.getStrategies()), this.mapFilters((List<Filter>)model.getFilters()));
                    PersistenceServiceConfiguration oldConfiguration = this.configurations.put(serviceName, newConfiguration);
                    if (oldConfiguration == null) {
                        if (type != EventType.ADDED) {
                            this.logger.warn("Model {} is inconsistent: An updated event was sent, but there is no old configuration. Adding it now.", (Object)modelName);
                        }
                        this.notifyListenersAboutAddedElement(newConfiguration);
                    } else {
                        if (type != EventType.MODIFIED) {
                            this.logger.warn("Model {} is inconsistent: An added event was sent, but there is an old configuration. Replacing it now.", (Object)modelName);
                        }
                        this.notifyListenersAboutUpdatedElement(oldConfiguration, newConfiguration);
                    }
                } else {
                    this.logger.error("The model repository reported a {} event for model '{}' but the model could not be found in the repository. ", (Object)type, (Object)modelName);
                }
            }
        }
    }

    private String serviceName(String modelName) {
        return modelName.substring(0, modelName.length() - ".persist".length());
    }

    private List<PersistenceItemConfiguration> mapConfigs(List<PersistenceConfiguration> configs) {
        LinkedList<PersistenceItemConfiguration> lst = new LinkedList<PersistenceItemConfiguration>();
        for (PersistenceConfiguration config : configs) {
            lst.add(this.mapConfig(config));
        }
        return lst;
    }

    private PersistenceItemConfiguration mapConfig(PersistenceConfiguration config) {
        LinkedList<Object> items = new LinkedList<Object>();
        for (EObject item : config.getItems()) {
            if (item instanceof AllConfig) {
                items.add(new PersistenceAllConfig());
                continue;
            }
            if (item instanceof GroupConfig var5_5) {
                items.add(new PersistenceGroupConfig(groupConfig.getGroup()));
                continue;
            }
            if (!(item instanceof ItemConfig var7_7)) continue;
            items.add(new PersistenceItemConfig(itemConfig.getItem()));
        }
        return new PersistenceItemConfiguration(items, config.getAlias(), this.mapStrategies((List<Strategy>)config.getStrategies()), this.mapFilters((List<Filter>)config.getFilters()));
    }

    private List<PersistenceStrategy> mapStrategies(List<Strategy> strategies) {
        LinkedList<PersistenceStrategy> lst = new LinkedList<PersistenceStrategy>();
        for (Strategy strategy : strategies) {
            lst.add(this.mapStrategy(strategy));
        }
        return lst;
    }

    /*
     * WARNING - void declaration
     */
    private PersistenceStrategy mapStrategy(Strategy strategy) {
        void var3_2;
        CronStrategy cronStrategy;
        Strategy strategy2 = strategy;
        if (strategy2 instanceof CronStrategy && (cronStrategy = (CronStrategy)strategy2) == (CronStrategy)var3_2) {
            void cronStrategy2;
            return new PersistenceCronStrategy(strategy.getName(), cronStrategy2.getCronExpression());
        }
        return new PersistenceStrategy(strategy.getName());
    }

    private List<PersistenceFilter> mapFilters(List<Filter> filters) {
        LinkedList<PersistenceFilter> lst = new LinkedList<PersistenceFilter>();
        for (Filter filter : filters) {
            lst.add(this.mapFilter(filter));
        }
        return lst;
    }

    /*
     * WARNING - void declaration
     */
    private PersistenceFilter mapFilter(Filter filter) {
        void var3_2;
        TimeFilter timeFilter;
        FilterDetails filterDetails = filter.getDefinition();
        if (filterDetails instanceof TimeFilter && (timeFilter = (TimeFilter)filterDetails) == (TimeFilter)var3_2) {
            void timeFilter2;
            return new PersistenceTimeFilter(filter.getName(), timeFilter2.getValue(), timeFilter2.getUnit());
        }
         instanceOfPatternExpressionValue = filter.getDefinition();
        if ( instanceOfPatternExpressionValue instanceof ThresholdFilter var4_5) {
            void thresholdFilter;
            return new PersistenceThresholdFilter(filter.getName(), thresholdFilter.getValue(), thresholdFilter.getUnit(), Boolean.valueOf(thresholdFilter.isRelative()));
        }
         instanceOfPatternExpressionValue = filter.getDefinition();
        if ( instanceOfPatternExpressionValue instanceof EqualsFilter var6_7) {
            void equalsFilter;
            return new PersistenceEqualsFilter(filter.getName(), equalsFilter.getValues(), Boolean.valueOf(false));
        }
         instanceOfPatternExpressionValue = filter.getDefinition();
        if ( instanceOfPatternExpressionValue instanceof NotEqualsFilter var8_9) {
            void notEqualsFilter;
            return new PersistenceEqualsFilter(filter.getName(), notEqualsFilter.getValues(), Boolean.valueOf(true));
        }
         instanceOfPatternExpressionValue = filter.getDefinition();
        if ( instanceOfPatternExpressionValue instanceof IncludeFilter var10_11) {
            void includeFilter;
            return new PersistenceIncludeFilter(filter.getName(), includeFilter.getLower(), includeFilter.getUpper(), includeFilter.getUnit(), Boolean.valueOf(false));
        }
         instanceOfPatternExpressionValue = filter.getDefinition();
        if ( instanceOfPatternExpressionValue instanceof NotIncludeFilter var12_13) {
            void notIncludeFilter;
            return new PersistenceIncludeFilter(filter.getName(), notIncludeFilter.getLower(), notIncludeFilter.getUpper(), notIncludeFilter.getUnit(), Boolean.valueOf(true));
        }
        throw new IllegalArgumentException("Unknown filter type " + filter.getClass());
    }

    public Collection<PersistenceServiceConfiguration> getAll() {
        return List.copyOf(this.configurations.values());
    }
}

