/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonInfoProvider;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.AddonFinderConstants;
import org.openhab.core.config.discovery.addon.AddonFinderService;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.openhab.core.i18n.LocaleProvider;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={AddonSuggestionService.class}, name="addon-suggestion-service", configurationPid={"org.openhab.addons"})
public class AddonSuggestionService
implements AutoCloseable {
    public static final String SERVICE_NAME = "addon-suggestion-service";
    public static final String CONFIG_PID = "org.openhab.addons";
    private final Logger logger = LoggerFactory.getLogger(AddonSuggestionService.class);
    private final Set<AddonInfoProvider> addonInfoProviders = ConcurrentHashMap.newKeySet();
    private final List<AddonFinder> addonFinders = Collections.synchronizedList(new ArrayList());
    private final ConfigurationAdmin configurationAdmin;
    private final LocaleProvider localeProvider;
    private @Nullable AddonFinderService addonFinderService;
    private @Nullable Map<String, Object> config;
    private final ScheduledExecutorService scheduler;
    private final Map<String, Boolean> baseFinderConfig = new ConcurrentHashMap<String, Boolean>();
    private final List<Future<?>> tasks = new CopyOnWriteArrayList();

    @Activate
    public AddonSuggestionService(@Reference ConfigurationAdmin configurationAdmin, @Reference LocaleProvider localeProvider, @Nullable Map<String, Object> config) {
        this.configurationAdmin = configurationAdmin;
        this.localeProvider = localeProvider;
        AddonFinderConstants.SUGGESTION_FINDERS.forEach(f -> {
            Boolean bl = this.baseFinderConfig.put((String)f, true);
        });
        this.modified(config);
        this.changed();
        this.scheduler = ThreadPoolManager.getScheduledPool((String)"common");
        this.tasks.add(this.scheduler.scheduleWithFixedDelay(this::syncConfiguration, 1L, 1L, TimeUnit.MINUTES));
    }

    @Deactivate
    protected void deactivate() {
        this.tasks.forEach(task -> {
            boolean bl = task.cancel(true);
        });
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addAddonFinderService(AddonFinderService addonFinderService) {
        this.addonFinderService = addonFinderService;
        this.modified(this.config);
    }

    protected void removeAddonFinderService(AddonFinderService addonFinderService) {
        AddonFinderService finderService = this.addonFinderService;
        if (finderService != null && addonFinderService.getClass().isAssignableFrom(finderService.getClass())) {
            this.addonFinderService = null;
        }
    }

    @Modified
    public void modified(@Nullable Map<String, Object> config) {
        this.baseFinderConfig.forEach((finder, cfg) -> {
            String cfgParam = AddonFinderConstants.SUGGESTION_FINDER_CONFIGS.get(finder);
            if (cfgParam != null) {
                boolean enabled = config != null ? ((Boolean)ConfigParser.valueAsOrElse(config.get(cfgParam), Boolean.class, (Object)cfg)).booleanValue() : cfg.booleanValue();
                this.baseFinderConfig.put((String)finder, enabled);
                String feature = AddonFinderConstants.SUGGESTION_FINDER_FEATURES.get(finder);
                AddonFinderService finderService = this.addonFinderService;
                if (feature != null && finderService != null) {
                    if (enabled) {
                        this.tasks.add(this.scheduler.submit(() -> finderService.install(feature)));
                    } else {
                        this.tasks.add(this.scheduler.submit(() -> finderService.uninstall(feature)));
                    }
                }
            }
        });
        this.config = config;
    }

    private void syncConfiguration() {
        try {
            Dictionary cfg = this.configurationAdmin.getConfiguration(CONFIG_PID).getProperties();
            if (cfg == null) {
                return;
            }
            HashMap<String, Object> cfgMap = new HashMap<String, Object>();
            Enumeration enumeration = cfg.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                cfgMap.put(key, cfg.get(key));
            }
            if (!cfgMap.equals(this.config)) {
                this.modified(cfgMap);
            }
        }
        catch (IOException | IllegalStateException e) {
            this.logger.debug("Exception occurred while trying to sync the configuration: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFinderEnabled(AddonFinder finder) {
        void var3_2;
        BaseAddonFinder baseAddonFinder;
        AddonFinder addonFinder = finder;
        if (addonFinder instanceof BaseAddonFinder && (baseAddonFinder = (BaseAddonFinder)addonFinder) == (BaseAddonFinder)var3_2) {
            void baseFinder;
            return this.baseFinderConfig.getOrDefault(baseFinder.getServiceName(), true);
        }
        return true;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addAddonInfoProvider(AddonInfoProvider addonInfoProvider) {
        this.addonInfoProviders.add(addonInfoProvider);
        this.changed();
    }

    public void removeAddonInfoProvider(AddonInfoProvider addonInfoProvider) {
        if (this.addonInfoProviders.remove(addonInfoProvider)) {
            this.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addAddonFinder(AddonFinder addonFinder) {
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            this.addonFinders.add(addonFinder);
        }
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAddonFinder(AddonFinder addonFinder) {
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            this.addonFinders.remove(addonFinder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changed() {
        List candidates = this.addonInfoProviders.stream().map(p -> p.getAddonInfos(this.localeProvider.getLocale())).flatMap(Collection::stream).toList();
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            this.addonFinders.stream().filter(this::isFinderEnabled).forEach(f -> f.setAddonCandidates(candidates));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deactivate
    public void close() throws Exception {
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            this.addonFinders.clear();
        }
        this.addonInfoProviders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AddonInfo> getSuggestedAddons(@Nullable Locale locale) {
        List<AddonFinder> list = this.addonFinders;
        synchronized (list) {
            return this.addonFinders.stream().filter(this::isFinderEnabled).map(f -> f.getSuggestedAddons()).flatMap(Collection::stream).collect(Collectors.toSet());
        }
    }
}

