/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ephemeris.internal;

import de.jollyday.Holiday;
import de.jollyday.HolidayManager;
import de.jollyday.ManagerParameter;
import de.jollyday.ManagerParameters;
import de.jollyday.parameter.CalendarPartManagerParameter;
import de.jollyday.util.ResourceUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigOptionProvider;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.config.core.ParameterOption;
import org.openhab.core.ephemeris.EphemerisManager;
import org.openhab.core.i18n.LocaleProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.openhab.ephemeris", property={"service.pid=org.openhab.ephemeris"})
@ConfigurableService(category="system", label="Ephemeris", description_uri="system:ephemeris")
@NonNullByDefault
public class EphemerisManagerImpl
implements EphemerisManager,
ConfigOptionProvider {
    private final Logger logger = LoggerFactory.getLogger(EphemerisManagerImpl.class);
    protected static final String CONFIG_URI = "system:ephemeris";
    public static final String CONFIG_DAYSET_PREFIX = "dayset-";
    public static final String CONFIG_DAYSET_WEEKEND = "weekend";
    public static final String CONFIG_COUNTRY = "country";
    public static final String CONFIG_REGION = "region";
    public static final String CONFIG_CITY = "city";
    private static final String RESOURCES_ROOT = "jollyday/";
    private static final String JOLLYDAY_COUNTRY_DESCRIPTIONS = "jollyday/descriptions/country_descriptions.properties";
    private static final String PROPERTY_COUNTRY_DESCRIPTION_PREFIX = "country.description.";
    private static final String PROPERTY_COUNTRY_DESCRIPTION_DELIMITER = "\\.";
    final List<ParameterOption> countries = new ArrayList<ParameterOption>();
    final Map<String, List<ParameterOption>> regions = new HashMap<String, List<ParameterOption>>();
    final Map<String, List<ParameterOption>> cities = new HashMap<String, List<ParameterOption>>();
    final Map<String, Set<DayOfWeek>> daysets = new HashMap<String, Set<DayOfWeek>>();
    private final Map<Object, HolidayManager> holidayManagers = new HashMap<Object, HolidayManager>();
    private final List<String> countryParameters = new ArrayList<String>();
    private final ResourceUtil resourceUtil = new ResourceUtil();
    private final LocaleProvider localeProvider;
    private final Bundle bundle;
    @NonNullByDefault(value={})
    private String country;
    private @Nullable String region;

    @Activate
    public EphemerisManagerImpl(@Reference LocaleProvider localeProvider, BundleContext bundleContext) {
        this.localeProvider = localeProvider;
        this.bundle = bundleContext.getBundle();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = this.bundle.getResource(JOLLYDAY_COUNTRY_DESCRIPTIONS).openStream();){
                Properties properties = new Properties();
                properties.load(stream);
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this::parseProperty));
                this.sortByLabel(this.countries);
                this.regions.values().forEach(this::sortByLabel);
                this.cities.values().forEach(this::sortByLabel);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            this.logger.warn("The resource '{}' could not be loaded properly! ConfigDescription options are not available.", (Object)JOLLYDAY_COUNTRY_DESCRIPTIONS, (Object)e);
        }
    }

    private void sortByLabel(List<ParameterOption> parameterOptions) {
        parameterOptions.sort(Comparator.comparing(ParameterOption::getLabel));
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        config.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(CONFIG_DAYSET_PREFIX)).forEach(e -> {
            try {
                String[] setNameParts = ((String)e.getKey()).split("-");
                if (setNameParts.length > 1) {
                    String setName = setNameParts[1];
                    Object entry = e.getValue();
                    if (entry instanceof String) {
                        String value = entry.toString();
                        while (value.startsWith("[")) {
                            value = value.substring(1);
                        }
                        while (value.endsWith("]")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        String[] setDefinition = value.split(",");
                        if (setDefinition.length > 0) {
                            this.addDayset(setName, List.of(setDefinition));
                        } else {
                            this.logger.warn("Erroneous day set definition {} : {}", e.getKey(), entry);
                        }
                    } else {
                        if (entry instanceof Iterable value) {
                            this.addDayset(setName, (Iterable<?>)iterable);
                        }
                    }
                } else {
                    this.logger.warn("Erroneous day set definition {}", e.getKey());
                }
            }
            catch (IllegalArgumentException ex) {
                this.logger.warn("Erroneous day set definition {}: {}", e.getKey(), (Object)ex.getMessage());
            }
        });
        Object configValue = config.get(CONFIG_COUNTRY);
        if (configValue != null) {
            this.country = configValue.toString().toLowerCase();
        } else {
            this.country = this.localeProvider.getLocale().getCountry().toLowerCase();
            this.logger.debug("Using system default country '{}' ", (Object)this.country);
        }
        configValue = config.get(CONFIG_REGION);
        if (configValue != null) {
            String region = configValue.toString().toLowerCase();
            this.countryParameters.add(region);
            this.region = region;
        } else {
            this.region = null;
        }
        configValue = config.get(CONFIG_CITY);
        if (configValue != null) {
            this.countryParameters.add(configValue.toString());
        }
    }

    public @Nullable Collection<ParameterOption> getParameterOptions(URI uri, String param, @Nullable String context, @Nullable Locale locale) {
        block16: {
            if (!CONFIG_URI.equals(uri.toString())) break block16;
            switch (param) {
                case "country": {
                    return this.countries;
                }
                case "region": {
                    if (this.regions.containsKey(this.country)) {
                        return this.regions.get(this.country);
                    }
                }
                case "city": {
                    if (this.region == null || !this.cities.containsKey(this.region)) break;
                    return this.cities.get(this.region);
                }
            }
            if (param.startsWith(CONFIG_DAYSET_PREFIX)) {
                Locale nullSafeLocale = locale == null ? this.localeProvider.getLocale() : locale;
                ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
                DayOfWeek[] dayOfWeekArray = DayOfWeek.values();
                int n = dayOfWeekArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DayOfWeek day = dayOfWeekArray[n2];
                    ParameterOption option = new ParameterOption(day.name(), day.getDisplayName(TextStyle.FULL, nullSafeLocale));
                    options.add(option);
                    ++n2;
                }
                return options;
            }
        }
        return null;
    }

    private URL getUrl(String filename) throws FileNotFoundException {
        if (Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
            try {
                return new URL("file:" + filename);
            }
            catch (MalformedURLException e) {
                throw new FileNotFoundException(e.getMessage());
            }
        }
        throw new FileNotFoundException(filename);
    }

    /*
     * WARNING - void declaration
     */
    private HolidayManager getHolidayManager(Object managerKey) {
        HolidayManager holidayManager = this.holidayManagers.get(managerKey);
        if (holidayManager == null) {
            void stringKey;
            URL urlOverride;
            String string;
            Object object = managerKey;
            ManagerParameter parameters = object instanceof String && (string = (String)object) == (String)object ? ((urlOverride = this.bundle.getResource(RESOURCES_ROOT + CalendarPartManagerParameter.getConfigurationFileName((String)stringKey))) != null ? ManagerParameters.create((URL)urlOverride) : ManagerParameters.create((String)stringKey)) : ManagerParameters.create((URL)((URL)managerKey));
            holidayManager = HolidayManager.getInstance((ManagerParameter)parameters);
            this.holidayManagers.put(managerKey, holidayManager);
        }
        return holidayManager;
    }

    private List<Holiday> getHolidays(ZonedDateTime from, int span, HolidayManager holidayManager) {
        LocalDate fromDate = from.toLocalDate();
        LocalDate toDate = from.plusDays(span).toLocalDate();
        Set days = holidayManager.getHolidays(fromDate, toDate, this.countryParameters.toArray(new String[0]));
        return days.stream().sorted(Comparator.comparing(Holiday::getDate)).toList();
    }

    @Override
    public long getDaysUntil(ZonedDateTime from, String searchedHoliday) {
        return this.getDaysUntil(from, searchedHoliday, this.getHolidayManager(this.country));
    }

    @Override
    public long getDaysUntil(ZonedDateTime from, String searchedHoliday, URL resource) {
        return this.getDaysUntil(from, searchedHoliday, this.getHolidayManager(resource));
    }

    @Override
    public long getDaysUntil(ZonedDateTime from, String searchedHoliday, String filename) throws FileNotFoundException {
        return this.getDaysUntil(from, searchedHoliday, this.getUrl(filename));
    }

    private long getDaysUntil(ZonedDateTime from, String searchedHoliday, HolidayManager holidayManager) {
        List<Holiday> sortedHolidays = this.getHolidays(from, 366, holidayManager);
        Optional<Holiday> result = sortedHolidays.stream().filter(holiday -> searchedHoliday.equalsIgnoreCase(holiday.getPropertiesKey())).findFirst();
        return result.map(holiday -> from.toLocalDate().until(holiday.getDate(), ChronoUnit.DAYS)).orElse(-1L);
    }

    private @Nullable String getFirstBankHolidayKey(ZonedDateTime from, int span, HolidayManager holidayManager) {
        Optional holiday = this.getHolidays(from, span, holidayManager).stream().findFirst();
        return holiday.map(Holiday::getPropertiesKey).orElse(null);
    }

    @Override
    public boolean isBankHoliday(ZonedDateTime date) {
        return !this.getHolidays(date, 0, this.getHolidayManager(this.country)).isEmpty();
    }

    @Override
    public boolean isBankHoliday(ZonedDateTime date, URL resource) {
        return !this.getHolidays(date, 0, this.getHolidayManager(resource)).isEmpty();
    }

    @Override
    public boolean isBankHoliday(ZonedDateTime date, String filename) throws FileNotFoundException {
        return this.isBankHoliday(date, this.getUrl(filename));
    }

    @Override
    public boolean isWeekend(ZonedDateTime date) {
        return this.isInDayset(CONFIG_DAYSET_WEEKEND, date);
    }

    @Override
    public boolean isInDayset(String daysetName, ZonedDateTime date) {
        Set<DayOfWeek> dayset = this.daysets.get(daysetName);
        if (dayset != null) {
            DayOfWeek dow = date.getDayOfWeek();
            return dayset.contains(dow);
        }
        this.logger.warn("This dayset is not configured : {}", (Object)daysetName);
        return false;
    }

    @Override
    public @Nullable String getBankHolidayName(ZonedDateTime date) {
        return this.getFirstBankHolidayKey(date, 0, this.getHolidayManager(this.country));
    }

    @Override
    public @Nullable String getBankHolidayName(ZonedDateTime date, URL resource) {
        return this.getFirstBankHolidayKey(date, 0, this.getHolidayManager(resource));
    }

    @Override
    public @Nullable String getBankHolidayName(ZonedDateTime date, String filename) throws FileNotFoundException {
        return this.getBankHolidayName(date, this.getUrl(filename));
    }

    @Override
    public @Nullable String getNextBankHoliday(ZonedDateTime from) {
        return this.getFirstBankHolidayKey(from, 365, this.getHolidayManager(this.country));
    }

    @Override
    public @Nullable String getNextBankHoliday(ZonedDateTime from, URL resource) {
        return this.getFirstBankHolidayKey(from, 365, this.getHolidayManager(resource));
    }

    @Override
    public @Nullable String getNextBankHoliday(ZonedDateTime from, String filename) throws FileNotFoundException {
        return this.getNextBankHoliday(from, this.getUrl(filename));
    }

    private void addDayset(String setName, Iterable<?> values) {
        HashSet<DayOfWeek> dayset = new HashSet<DayOfWeek>();
        for (Object day : values) {
            String dayString = day.toString().toUpperCase().replaceAll("[^A-Z]", "");
            dayset.add(DayOfWeek.valueOf(dayString));
        }
        this.daysets.put(setName, dayset);
    }

    void parseProperty(Object key, Object value) throws IllegalArgumentException {
        String property = key.toString().replace(PROPERTY_COUNTRY_DESCRIPTION_PREFIX, "");
        String[] parts = property.split(PROPERTY_COUNTRY_DESCRIPTION_DELIMITER);
        String name = value.toString();
        switch (parts.length) {
            case 1: {
                this.countries.add(new ParameterOption(EphemerisManagerImpl.getValidPart(parts[0]), name));
                break;
            }
            case 2: {
                String part = EphemerisManagerImpl.getValidPart(parts[0]);
                ParameterOption option = new ParameterOption(EphemerisManagerImpl.getValidPart(parts[1]), name);
                List<ParameterOption> regionsPart = this.regions.get(part);
                if (regionsPart != null) {
                    regionsPart.add(option);
                    break;
                }
                ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
                options.add(option);
                this.regions.put(part, options);
                break;
            }
            case 3: {
                String part = EphemerisManagerImpl.getValidPart(parts[1]);
                ParameterOption option = new ParameterOption(EphemerisManagerImpl.getValidPart(parts[2]), name);
                List<ParameterOption> citiesPart = this.cities.get(part);
                if (citiesPart != null) {
                    citiesPart.add(option);
                    break;
                }
                ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
                options.add(option);
                this.cities.put(part, options);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unable to parse property '%s = %s'.", key, value));
            }
        }
    }

    private static String getValidPart(String part) {
        String subject = part.trim();
        if (!subject.isEmpty()) {
            return subject.toLowerCase();
        }
        throw new IllegalArgumentException("Unable to parse property - token is empty.");
    }

    @Override
    public @Nullable String getHolidayDescription(@Nullable String holiday) {
        return holiday != null ? this.resourceUtil.getHolidayDescription(this.localeProvider.getLocale(), holiday) : null;
    }
}

