/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.config.core.Configuration;
import org.slf4j.Logger;

public class ReferenceResolver {
    public static void updateConfiguration(Configuration config, Map<String, ?> context, Logger logger) {
        for (String configKey : config.keySet()) {
            Object o = config.get(configKey);
            if (o instanceof String var6_6) {
                result = ReferenceResolver.resolveProperty(config, context, logger, configKey, (String)string);
                config.put(configKey, result);
                continue;
            }
             instanceOfPatternExpressionValue = o;
            if (!( instanceOfPatternExpressionValue instanceof List) || (result = (List) instanceOfPatternExpressionValue) != (List) instanceOfPatternExpressionValue) continue;
            ArrayList<Object> resultList = new ArrayList<Object>();
            for (Object obj : list) {
                if (!(obj instanceof String var13_13)) continue;
                resultList.add(ReferenceResolver.resolveProperty(config, context, logger, configKey, (String)string));
            }
            config.put(configKey, resultList);
        }
    }

    private static Object resolveProperty(Configuration config, Map<String, ?> context, Logger logger, String configKey, String childConfigPropertyValue) {
        String result;
        if (ReferenceResolver.isReference(childConfigPropertyValue)) {
            Object result2 = ReferenceResolver.resolveReference(childConfigPropertyValue, context);
            if (result2 != null) {
                return result2;
            }
        } else if (ReferenceResolver.containsPattern(childConfigPropertyValue) && (result = ReferenceResolver.resolvePattern(childConfigPropertyValue, context, logger)) != null) {
            return result;
        }
        return childConfigPropertyValue;
    }

    public static Map<String, Object> getCompositeChildContext(Module module, Map<String, ?> compositeContext) {
        HashMap<String, Object> resultContext = new HashMap<String, Object>();
        Map<String, String> inputs = null;
        if (module instanceof Condition var4_5) {
            inputs = condition.getInputs();
        } else {
            if (module instanceof Action var6_7) {
                inputs = action.getInputs();
            }
        }
        if (inputs != null) {
            for (Map.Entry input : inputs.entrySet()) {
                String inputName = (String)input.getKey();
                String inputValue = (String)input.getValue();
                if (!ReferenceResolver.isReference(inputValue)) continue;
                Object result = ReferenceResolver.resolveReference(inputValue, compositeContext);
                resultContext.put(inputName, result);
            }
        }
        return resultContext;
    }

    public static Object resolveReference(String reference, Map<String, ?> context) {
        String result = reference;
        if (ReferenceResolver.isReference(reference)) {
            String trimmedVal = reference.trim();
            String key = trimmedVal.substring(2, trimmedVal.length() - 2);
            result = context.get(key);
        }
        return result;
    }

    private static String resolvePattern(String reference, Map<String, ?> context, Logger logger) {
        int start;
        StringBuilder sb = new StringBuilder();
        int previous = 0;
        while ((start = reference.indexOf("{{", previous)) != -1) {
            sb.append(reference.substring(previous, start));
            int end = reference.indexOf("}}", start + 2);
            if (end == -1) {
                previous = start;
                String msg = "Couldn't parse referenced key: " + reference.substring(start) + ": expected reference syntax-> {{referencedKey}}";
                logger.warn(msg);
                throw new IllegalArgumentException(msg);
            }
            String referencedKey = reference.substring(start + 2, end);
            Object referencedValue = context.get(referencedKey);
            if (referencedValue != null) {
                sb.append(referencedValue);
            } else {
                String msg = "Cannot find reference for {{" + referencedKey + "}} , it will remain the same.";
                logger.warn(msg);
                sb.append("{{" + referencedKey + "}}");
            }
            previous = end + 2;
        }
        sb.append(reference.substring(previous));
        return sb.toString();
    }

    private static boolean isReference(String value) {
        String trimmedVal;
        String string = trimmedVal = value == null ? null : value.trim();
        return trimmedVal != null && trimmedVal.lastIndexOf("{{") == 0 && trimmedVal.indexOf("}}") == trimmedVal.length() - 2 && trimmedVal.length() > 4;
    }

    private static boolean containsPattern(String value) {
        return value != null && value.trim().contains("{{") && value.trim().indexOf("{{") < value.trim().indexOf("}}");
    }

    public static int getNextRefToken(String ref, int startIndex) {
        int idx1 = ref.indexOf(91, startIndex);
        int idx2 = ref.indexOf(46, startIndex);
        if (idx1 != -1 && (idx2 == -1 || idx1 < idx2)) {
            return idx1;
        }
        if (idx2 != -1 && (idx1 == -1 || idx2 < idx1)) {
            return idx2;
        }
        return -1;
    }

    public static String[] splitReferenceToTokens(String reference) throws IllegalArgumentException {
        if (reference == null) {
            return null;
        }
        String regex = "\\[{1}\\\"{1}.+\\\"{1}\\]{1}|\\[{1}\\d+\\]{1}|[^\\[\\]\\.][A-Za-z0-9_-]+[^\\]\\[\\.]";
        Pattern pattern = Pattern.compile("\\[{1}\\\"{1}.+\\\"{1}\\]{1}|\\[{1}\\d+\\]{1}|[^\\[\\]\\.][A-Za-z0-9_-]+[^\\]\\[\\.]");
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(reference);
        while (matcher.find()) {
            String token = matcher.group();
            if (token.startsWith("[\"")) {
                token = token.substring(2, token.length() - 2);
            } else if (token.startsWith("[")) {
                token = token.substring(1, token.length() - 1);
            }
            if (token.isEmpty()) {
                throw new IllegalArgumentException("Invalid reference syntax in reference: " + reference);
            }
            result.add(token);
        }
        return (String[])result.stream().toArray(String[]::new);
    }

    public static Object resolveComplexDataReference(Object object, String ... tokens) throws IllegalArgumentException, SecurityException {
        if (object == null) {
            throw new IllegalArgumentException("Object is null.");
        }
        if (tokens == null) {
            return object;
        }
        try {
            Object obj = object;
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                if (obj instanceof Map var7_8) {
                    obj = ReferenceResolver.getValueFromMap(map, token);
                } else {
                    if (obj instanceof List var9_10) {
                        obj = ReferenceResolver.getValueFromList(list, Integer.parseInt(token));
                    } else {
                        Class<?> objClass = obj.getClass();
                        obj = ReferenceResolver.getValueFromBean(objClass, obj, token);
                    }
                }
                ++n2;
            }
            return obj;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Invalid reference path. A field from the reference path doesn't exist", e);
        }
    }

    private static Object getValueFromMap(Map<?, ?> map, String key) {
        return map.get(key);
    }

    private static Object getValueFromList(List<?> list, int index) {
        return list.get(index);
    }

    private static Object getValueFromBean(Class<?> objClass, Object bean, String fieldName) throws NoSuchFieldException, SecurityException {
        try {
            Field f = objClass.getDeclaredField(fieldName);
            if (!f.canAccess(bean)) {
                f.setAccessible(true);
            }
            return f.get(bean);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

