/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.config.core.Configuration;

public class ConfigurationNormalizer {
    public static <T extends Module> void normalizeModuleConfigurations(List<T> modules, ModuleTypeRegistry mtRegistry) {
        for (Module module : modules) {
            ModuleType mt = (ModuleType)mtRegistry.get(module.getTypeUID());
            if (mt == null) continue;
            Map<String, ConfigDescriptionParameter> mapConfigDescriptions = ConfigurationNormalizer.getConfigDescriptionMap(mt.getConfigurationDescriptions());
            ConfigurationNormalizer.normalizeConfiguration(module.getConfiguration(), mapConfigDescriptions);
        }
    }

    public static Map<String, ConfigDescriptionParameter> getConfigDescriptionMap(List<ConfigDescriptionParameter> configDesc) {
        HashMap<String, ConfigDescriptionParameter> mapConfigDescs = new HashMap<String, ConfigDescriptionParameter>();
        for (ConfigDescriptionParameter configDescriptionParameter : configDesc) {
            mapConfigDescs.put(configDescriptionParameter.getName(), configDescriptionParameter);
        }
        return mapConfigDescs;
    }

    /*
     * WARNING - void declaration
     */
    public static void normalizeConfiguration(Configuration configuration, Map<String, ConfigDescriptionParameter> configDescriptionMap) {
        for (Map.Entry<String, ConfigDescriptionParameter> entry : configDescriptionMap.entrySet()) {
            void string;
            String string2;
            String parameterName;
            Object value;
            Object object;
            ConfigDescriptionParameter parameter = entry.getValue();
            if (parameter == null || (object = (value = configuration.get(parameterName = entry.getKey()))) instanceof String && (string2 = (String)object) == (String)object && string.contains("${")) continue;
            if (value == null) {
                String defaultValue = parameter.getDefault();
                if (defaultValue == null) {
                    configuration.remove(parameterName);
                    continue;
                }
                configuration.put(parameterName, ConfigUtil.normalizeType((Object)defaultValue, (ConfigDescriptionParameter)parameter));
                continue;
            }
            configuration.put(parameterName, ConfigUtil.normalizeType((Object)value, (ConfigDescriptionParameter)parameter));
        }
    }
}

