/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.parser;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.parser.ParsingNestedException;

@NonNullByDefault
public class ParsingException
extends Exception {
    private List<ParsingNestedException> exceptions;

    public ParsingException(ParsingNestedException e) {
        this.exceptions = List.of(e);
    }

    public ParsingException(List<ParsingNestedException> exceptions) {
        this.exceptions = exceptions;
    }

    @Override
    public @Nullable String getMessage() {
        StringBuilder writer = new StringBuilder();
        for (ParsingNestedException e : this.exceptions) {
            writer.append(String.valueOf(e.getMessage()) + "\n");
        }
        return writer.toString();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        int size = 0;
        for (ParsingNestedException e : this.exceptions) {
            size += e.getStackTrace().length;
        }
        int index = 0;
        StackTraceElement[] st = new StackTraceElement[size];
        for (ParsingNestedException exception : this.exceptions) {
            StackTraceElement[] ste = exception.getStackTrace();
            System.arraycopy(ste, 0, st, index, ste.length);
            index += ste.length;
        }
        return st;
    }
}

