/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.file;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.internal.provider.file.AbstractFileProvider;
import org.openhab.core.automation.internal.provider.file.AutomationWatchService;
import org.openhab.core.service.WatchService;

@NonNullByDefault
public class WatchServiceUtil {
    private static final Map<AbstractFileProvider, Map<String, AutomationWatchService>> WATCH_SERVICES = new HashMap<AbstractFileProvider, Map<String, AutomationWatchService>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeWatchService(String watchingDir, AbstractFileProvider provider, WatchService watchService) {
        AutomationWatchService aws = null;
        Map<AbstractFileProvider, Map<String, AutomationWatchService>> map = WATCH_SERVICES;
        synchronized (map) {
            Map<String, AutomationWatchService> watchers = WATCH_SERVICES.get(provider);
            if (watchers == null) {
                watchers = new HashMap<String, AutomationWatchService>();
                WATCH_SERVICES.put(provider, watchers);
            }
            if (watchers.get(watchingDir) == null) {
                aws = new AutomationWatchService(provider, watchService, watchingDir);
                watchers.put(watchingDir, aws);
            }
        }
        if (aws != null) {
            aws.activate();
            provider.importResources(new File(watchingDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deactivateWatchService(String watchingDir, AbstractFileProvider provider) {
        AutomationWatchService aws = null;
        Map<AbstractFileProvider, Map<String, AutomationWatchService>> map = WATCH_SERVICES;
        synchronized (map) {
            Map<String, AutomationWatchService> watchers = WATCH_SERVICES.get(provider);
            if (watchers != null) {
                aws = watchers.remove(watchingDir);
                if (watchers.isEmpty()) {
                    WATCH_SERVICES.remove(provider);
                }
            }
        }
        if (aws != null) {
            aws.deactivate();
            Path sourcePath = aws.getSourcePath();
            provider.removeResources(sourcePath.toFile());
        }
    }
}

