/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractFileProvider<@NonNull E>
implements Provider<E> {
    protected static final String CONFIG_PROPERTY_ROOTS = "roots";
    protected final Logger logger = LoggerFactory.getLogger(AbstractFileProvider.class);
    protected final String rootSubdirectory;
    protected String[] configurationRoots;
    protected final Map<String, E> providedObjectsHolder = new ConcurrentHashMap<String, E>();
    private final Map<String, Parser<E>> parsers = new ConcurrentHashMap<String, Parser<E>>();
    private final Map<URL, List<String>> providerPortfolio = new ConcurrentHashMap<URL, List<String>>();
    private final Map<String, List<URL>> urls = new ConcurrentHashMap<String, List<URL>>();
    private final List<ProviderChangeListener<E>> listeners = new ArrayList<ProviderChangeListener<E>>();

    public AbstractFileProvider(String root) {
        this.rootSubdirectory = root;
        this.configurationRoots = new String[]{String.valueOf(OpenHAB.getConfigFolder()) + File.separator + "automation"};
    }

    public void activate(Map<String, Object> config) {
        this.modified(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        String[] stringArray = this.configurationRoots;
        int n = this.configurationRoots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            this.deactivateWatchService(String.valueOf(root) + File.separator + this.rootSubdirectory);
            ++n2;
        }
        this.urls.clear();
        this.parsers.clear();
        List<ProviderChangeListener<E>> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
        this.providerPortfolio.clear();
        this.providedObjectsHolder.clear();
    }

    public synchronized void modified(Map<String, Object> config) {
        int n;
        int n2;
        String[] stringArray;
        String roots = (String)config.get(CONFIG_PROPERTY_ROOTS);
        if (roots != null) {
            stringArray = this.configurationRoots;
            n2 = this.configurationRoots.length;
            n = 0;
            while (n < n2) {
                String root = stringArray[n];
                if (!roots.contains(root)) {
                    this.deactivateWatchService(String.valueOf(root) + File.separator + this.rootSubdirectory);
                }
                ++n;
            }
            this.configurationRoots = roots.split(",");
        }
        stringArray = this.configurationRoots;
        n2 = this.configurationRoots.length;
        n = 0;
        while (n < n2) {
            String configurationRoot = stringArray[n];
            this.initializeWatchService(String.valueOf(configurationRoot) + File.separator + this.rootSubdirectory);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderChangeListener(ProviderChangeListener<E> listener) {
        List<ProviderChangeListener<E>> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProviderChangeListener(ProviderChangeListener<E> listener) {
        List<ProviderChangeListener<E>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void importResources(File file) {
        block6: {
            if (!file.exists()) break block6;
            File[] files = file.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!f.isHidden()) {
                        this.importResources(f);
                    }
                    ++n2;
                }
            } else {
                try {
                    URL url = file.toURI().toURL();
                    String parserType = this.getParserType(url);
                    this.importFile(parserType, url);
                }
                catch (MalformedURLException e) {
                    this.logger.debug("Can't create a URL", (Throwable)e);
                }
            }
        }
    }

    public void removeResources(File file) {
        String path = file.getAbsolutePath();
        for (URL key : this.providerPortfolio.keySet()) {
            try {
                File f = new File(key.toURI());
                if (!f.getAbsolutePath().startsWith(path)) continue;
                List<String> portfolio = this.providerPortfolio.remove(key);
                this.removeElements(portfolio);
            }
            catch (URISyntaxException e) {
                this.logger.debug("Can't create a URI", (Throwable)e);
            }
        }
    }

    public void addParser(Parser<E> parser, Map<String, String> properties) {
        String parserType = properties.get("format");
        parserType = parserType == null ? "json" : parserType;
        this.parsers.put(parserType, parser);
        List<URL> value = this.urls.get(parserType);
        if (value != null && !value.isEmpty()) {
            for (URL url : value) {
                this.importFile(parserType, url);
            }
        }
    }

    public void removeParser(Parser<E> parser, Map<String, String> properties) {
        String parserType = properties.get("format");
        parserType = parserType == null ? "json" : parserType;
        this.parsers.remove(parserType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void importFile(String parserType, URL url) {
        Parser<E> parser = this.parsers.get(parserType);
        if (parser != null) {
            InputStream is = null;
            InputStreamReader inputStreamReader = null;
            try {
                try {
                    is = url.openStream();
                    BufferedInputStream bis = new BufferedInputStream(is);
                    inputStreamReader = new InputStreamReader(bis);
                    Set<E> providedObjects = parser.parse(inputStreamReader);
                    this.updateProvidedObjectsHolder(url, providedObjects);
                    return;
                }
                catch (ParsingException e) {
                    this.logger.debug("{}", (Object)e.getMessage(), (Object)e);
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (is == null) return;
                    try {
                        is.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
                catch (IOException e) {
                    block31: {
                        this.logger.debug("{}", (Object)e.getMessage(), (Object)e);
                        if (inputStreamReader == null) break block31;
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (is == null) return;
                    try {
                        is.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Map<String, List<URL>> map = this.urls;
        synchronized (map) {
            List<URL> value = this.urls.get(parserType);
            if (value == null) {
                value = new ArrayList<URL>();
                this.urls.put(parserType, value);
            }
            value.add(url);
        }
        this.logger.debug("Parser {} not available", (Object)parserType, (Object)new Exception());
    }

    protected void updateProvidedObjectsHolder(URL url, Set<E> providedObjects) {
        if (providedObjects != null && !providedObjects.isEmpty()) {
            ArrayList<String> uids = new ArrayList<String>();
            for (E providedObject : providedObjects) {
                String uid = this.getUID(providedObject);
                uids.add(uid);
                @Nullable E oldProvidedObject = this.providedObjectsHolder.put(uid, providedObject);
                this.notifyListeners(oldProvidedObject, providedObject);
            }
            this.providerPortfolio.put(url, uids);
        }
    }

    protected void removeElements(@Nullable List<String> objectsForRemove) {
        if (objectsForRemove != null) {
            for (String removedObject : objectsForRemove) {
                this.notifyListeners(this.providedObjectsHolder.remove(removedObject));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(@Nullable E oldElement, E newElement) {
        List<ProviderChangeListener<E>> list = this.listeners;
        synchronized (list) {
            for (ProviderChangeListener<E> listener : this.listeners) {
                if (oldElement != null) {
                    listener.updated((Provider)this, oldElement, newElement);
                    continue;
                }
                listener.added((Provider)this, newElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(@Nullable E removedObject) {
        if (removedObject != null) {
            List<ProviderChangeListener<E>> list = this.listeners;
            synchronized (list) {
                for (ProviderChangeListener<E> listener : this.listeners) {
                    listener.removed((Provider)this, removedObject);
                }
            }
        }
    }

    protected abstract String getUID(E var1);

    protected abstract void initializeWatchService(String var1);

    protected abstract void deactivateWatchService(String var1);

    private String getParserType(URL url) {
        String fileName = url.getPath();
        int index = fileName.lastIndexOf(".");
        String extension = index != -1 ? fileName.substring(index + 1) : "";
        return extension.isEmpty() || "txt".equals(extension) ? "json" : extension;
    }
}

