/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider;

import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class Vendor {
    private static final String DELIMITER = ";";
    private String vendorSymbolicName;
    private String vendorID;
    private String vendorVersion;
    private int rulesCount = 0;

    public Vendor(String nameversion) {
        int index = nameversion.indexOf(DELIMITER);
        this.vendorSymbolicName = nameversion.substring(0, index);
        this.vendorVersion = nameversion.substring(++index);
        this.vendorID = this.parseSymbolicName();
    }

    public Vendor(String name, String version) {
        this.vendorSymbolicName = name;
        this.vendorVersion = version;
        this.vendorID = this.parseSymbolicName();
    }

    public String getVendorSymbolicName() {
        return this.vendorSymbolicName;
    }

    public String getVendorID() {
        return this.vendorID;
    }

    public String getVendorVersion() {
        return this.vendorVersion;
    }

    public void setVendorVersion(String version) {
        this.vendorVersion = version;
    }

    public int count() {
        return this.rulesCount++;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        void var3_2;
        Vendor vendor;
        Object object = obj;
        if (object instanceof Vendor && (vendor = (Vendor)object) == (Vendor)var3_2) {
            void other;
            return this.vendorSymbolicName.equals(other.vendorSymbolicName) && this.vendorVersion.equals(other.vendorVersion);
        }
        return false;
    }

    public int hashCode() {
        return this.vendorSymbolicName.hashCode() + this.vendorVersion.hashCode();
    }

    public String toString() {
        return String.valueOf(this.vendorSymbolicName) + DELIMITER + this.vendorVersion;
    }

    private String parseSymbolicName() {
        String res = "";
        StringTokenizer tokenizer = new StringTokenizer(this.vendorSymbolicName, ".");
        while (tokenizer.hasMoreTokens()) {
            res = String.valueOf(res) + tokenizer.nextToken() + "_";
        }
        return res;
    }
}

