/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class HostFragmentMappingUtil {
    private static Map<Bundle, List<Bundle>> hostFragmentMapping = new HashMap<Bundle, List<Bundle>>();
    static PackageAdmin pkgAdmin;

    static Set<Map.Entry<Bundle, List<Bundle>>> getMapping() {
        return hostFragmentMapping.entrySet();
    }

    static List<Bundle> returnHostBundles(Bundle fragment) {
        ArrayList<Bundle> hosts = new ArrayList();
        Bundle[] bundles = pkgAdmin.getHosts(fragment);
        if (bundles != null) {
            hosts = Arrays.asList(bundles);
        } else {
            for (Bundle host : hostFragmentMapping.keySet()) {
                if (!hostFragmentMapping.get(host).contains(fragment)) continue;
                hosts.add(host);
            }
        }
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Bundle> fillHostFragmentMapping(Bundle host) {
        ArrayList<Bundle> fragments = new ArrayList();
        Bundle[] bundles = pkgAdmin.getFragments(host);
        if (bundles != null) {
            fragments = Arrays.asList(bundles);
        }
        Map<Bundle, List<Bundle>> map = hostFragmentMapping;
        synchronized (map) {
            hostFragmentMapping.put(host, fragments);
        }
        return fragments;
    }

    static void fillHostFragmentMapping(List<Bundle> hosts) {
        for (Bundle host : hosts) {
            HostFragmentMappingUtil.fillHostFragmentMapping(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean needToProcessFragment(Bundle fragment, List<Bundle> hosts) {
        if (hosts.isEmpty()) {
            return false;
        }
        Map<Bundle, List<Bundle>> map = hostFragmentMapping;
        synchronized (map) {
            Bundle host;
            List<Bundle> fragments;
            Iterator<Bundle> iterator = hosts.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((fragments = hostFragmentMapping.get(host = iterator.next())) == null || !fragments.contains(fragment));
            return false;
        }
    }

    static boolean isFragmentBundle(Bundle bundle) {
        PackageAdmin pkgAdmin = HostFragmentMappingUtil.pkgAdmin;
        if (pkgAdmin == null) {
            throw new IllegalStateException();
        }
        return pkgAdmin.getBundleType(bundle) == 1;
    }
}

