/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.parser.gson;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.dto.ActionTypeDTOMapper;
import org.openhab.core.automation.dto.CompositeActionTypeDTO;
import org.openhab.core.automation.dto.CompositeConditionTypeDTO;
import org.openhab.core.automation.dto.CompositeTriggerTypeDTO;
import org.openhab.core.automation.dto.ConditionTypeDTOMapper;
import org.openhab.core.automation.dto.ModuleTypeDTO;
import org.openhab.core.automation.dto.TriggerTypeDTOMapper;
import org.openhab.core.automation.internal.parser.gson.AbstractGSONParser;
import org.openhab.core.automation.internal.parser.gson.ModuleTypeParsingContainer;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.automation.parser.ParsingNestedException;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.ConditionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.TriggerType;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(immediate=true, service={Parser.class}, property={"parser.type=parser.module.type", "format=json"})
public class ModuleTypeGSONParser
extends AbstractGSONParser<ModuleType> {
    @Override
    public Set<ModuleType> parse(InputStreamReader reader) throws ParsingException {
        try {
            ModuleTypeParsingContainer mtContainer = (ModuleTypeParsingContainer)gson.fromJson((Reader)reader, ModuleTypeParsingContainer.class);
            HashSet<ModuleType> result = new HashSet<ModuleType>();
            this.addAll(result, mtContainer.triggers);
            this.addAll(result, mtContainer.conditions);
            this.addAll(result, mtContainer.actions);
            return result;
        }
        catch (Exception e) {
            throw new ParsingException(new ParsingNestedException(1, null, e));
        }
    }

    @Override
    public void serialize(Set<ModuleType> dataObjects, OutputStreamWriter writer) throws Exception {
        Map<String, List<? extends ModuleType>> map = this.createMapByType(dataObjects);
        gson.toJson(map, (Appendable)writer);
    }

    private void addAll(Set<ModuleType> result, @Nullable List<? extends ModuleTypeDTO> moduleTypes) {
        if (moduleTypes != null) {
            for (ModuleTypeDTO moduleTypeDTO : moduleTypes) {
                if (moduleTypeDTO instanceof CompositeTriggerTypeDTO var5_5) {
                    result.add(TriggerTypeDTOMapper.map((CompositeTriggerTypeDTO)tO));
                    continue;
                }
                if (moduleTypeDTO instanceof CompositeConditionTypeDTO var7_7) {
                    result.add(ConditionTypeDTOMapper.map((CompositeConditionTypeDTO)tO));
                    continue;
                }
                if (!(moduleTypeDTO instanceof CompositeActionTypeDTO var9_9)) continue;
                result.add(ActionTypeDTOMapper.map((CompositeActionTypeDTO)tO));
            }
        }
    }

    private Map<String, List<? extends ModuleType>> createMapByType(Set<ModuleType> dataObjects) {
        HashMap<String, List<? extends ModuleType>> map = new HashMap<String, List<? extends ModuleType>>();
        ArrayList<void> triggers = new ArrayList<void>();
        ArrayList<void> conditions = new ArrayList<void>();
        ArrayList<void> actions = new ArrayList<void>();
        for (ModuleType moduleType : dataObjects) {
            if (moduleType instanceof TriggerType var8_8) {
                triggers.add(type);
                continue;
            }
            if (moduleType instanceof ConditionType var10_10) {
                conditions.add(type);
                continue;
            }
            if (!(moduleType instanceof ActionType var12_12)) continue;
            actions.add(type);
        }
        map.put("triggers", triggers);
        map.put("conditions", conditions);
        map.put("actions", actions);
        return map;
    }
}

